!= dcpam ϵ絤ͥǥ Ver. 1
!
!= dcpam radiation model for the Earth's atmosphere Ver. 1
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: radiation_dcpam_E_V1.f90,v 1.1 2010-01-11 01:28:11 yot Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module radiation_dcpam_E_V1
  !
  != dcpam ϵ絤ͥǥ Ver. 1
  !
  != dcpam radiation model for the Earth's atmosphere Ver. 1
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϵ絤ͥǥ.
  !
  ! This is a radiation model for the Earth's atmospehre.
  !
  ! Radiation in the wavenumber range from   40 to  2600 cm-1 
  ! is calculated in the routine of long wave radiation. 
  ! Radiation in the wavenumber range from 2600 to 66667 cm-1 (0.15 to 3.85 micron) 
  ! is calculated in the routine of shortwave radiation. 
  !
  !== References
  !
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#radiation_DennouAGCM_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_dcpam_E_V1_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: RadiationDcpamEV1Flux

  character(*), parameter:: module_name = 'radiation_dcpam_E_V1'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: radiation_dcpam_E_V1.f90,v 1.1 2010-01-11 01:28:11 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadiationDcpamEV1Flux(                                                &
    & xy_SurfAlbedo,                                                               &
    & xyz_Press, xyr_Press, xyz_Temp, xyz_QVap, xyz_QO3, xyz_Height, xy_SurfTemp,  &
    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                                 &
    & )


    ! USE statements
    !

    ! dcpam ϵ絤ûͥǥ Ver. 1
    ! dcpam short wave radiation model for the Earth's atmosphere Ver. 1
    !
    use radiation_dcpam_E_SW_V1, only: RadiationDcpamESWV1Flux

    ! Roewe and Liou (1978) ˤĹͥǥ
    ! Long radiation model described by Roewe and Liou (1978)
    !
    use radiation_RL78, only: RadiationRL78Flux

    real(DP), intent(in ) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xyz_Press    ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyr_Press    ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in ) :: xyz_Temp     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_QVap     ( 0:imax-1, 1:jmax, 1:kmax )
                              ! $ q $ .   . Mass mixing ratio of constituents (1)
    real(DP), intent(in ) :: xyz_QO3      ( 0:imax-1, 1:jmax, 1:kmax )
                              ! O3 ʬ (1)
                              ! O3 distribution (1)
    real(DP), intent(in ) :: xyz_Height   ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
    real(DP), intent(out) :: xyr_RadSFlux ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)



    ! 
    ! Initialization
    !
    if ( .not. radiation_dcpam_E_V1_inited ) call RadiationDcpamEV1Init


    ! dcpam ϵ絤ûͥǥ Ver. 1
    ! dcpam short wave radiation model for the Earth's atmosphere Ver. 1
    !
    call RadiationDcpamESWV1Flux(                                 &
      & xy_SurfAlbedo,                                                  &
      & xyz_Press, xyr_Press, xyz_Temp, xyz_QVap, xyz_QO3, xyz_Height,  &
      & xyr_RadSFlux                                                    &
      & )


    ! Roewe and Liou (1978) ˤĹͥǥ
    ! Long radiation model described by Roewe and Liou (1978)
    !
    call RadiationRL78Flux( &
      & xyz_Temp, xyz_QVap, xyz_QO3, xyr_Press, xyz_Press, xy_SurfTemp, & ! (in )
      & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
      & )


  end subroutine RadiationDcpamEV1Flux

  !--------------------------------------------------------------------------------------

  subroutine RadiationDcpamEV1Init

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

!!$    ! NAMELIST ѿ
!!$    ! NAMELIST group name
!!$    !
!!$    namelist /radiation_dcpam_SWEV1_nml/ &
!!$      & FactorCondToCloud
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "radiation_dcpam_SWEV1#RadiationDcpamSWEV1Init"
!!$          ! Υɤ򻲾ȤΤ.
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "radiation_dcpam_SWEV1#RadiationDcpamSWEV1Init" for the default values.
!!$          !
!!$
!!$
!!$    ! ǥեͤ
!!$    ! Default values settings
!!$    !
!!$
!!$
!!$
!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = radiation_dcpam_SWEV1_nml, & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if




    !  ; Print
    !
!!$    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'FactorCondToCloud = %f', d = (/ FactorCondToCloud /) )
!!$    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    radiation_dcpam_E_V1_inited = .true.

  end subroutine RadiationDcpamEV1Init

  !--------------------------------------------------------------------------------------

end module radiation_dcpam_E_V1
