!= ɽ̥ǡ
!
!= Prepare surface data
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: surface_data.f90,v 1.5 2010-01-22 05:26:49 yot Exp $ 
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module surface_data
  !
  != ɽ̥ǡ
  !
  != Prepare surface data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! GCM Ѥɽ̥ǡޤ.
  ! ߤϻŪ Hosaka et al. (1998)  SST ʬۤͿޤ.
  !
  ! Surface data for GCM is generated.
  ! Now, SST profile in Hosaka et al. (1998) is provided tentatively.
  !
  !== Procedures List
  !
  ! SetSurfData   :: ɽ̥ǡμ
  ! ------------  :: ------------
  ! SetSurfData   :: Set surface data
  !
  !== NAMELIST
  !
  ! NAMELIST#surface_data_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetSurfData

  ! ѿ
  ! Public variables
  !
  logical, save, public:: surface_data_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  character(STRING), save:: Pattern
                              ! ɽ̥ǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Surface data pattern. 
                              ! Available patterns are as follows.
                              ! 
                              ! * "Hosaka et al. (1998)"
                              ! * "Homogeneous"
                              ! 
  real(DP), save:: SurfTemp
                              ! ɽ̲٤δ. 
                              ! Standard value of surface temperature
  real(DP), save:: Albedo
                              ! ɽ٥. 
                              ! Surface albedo
  real(DP), save:: HumidCoef
                              ! ɽ. 
                              ! Surface humidity coefficient
  real(DP), save:: RoughLength
                              ! ɽĹ. 
                              ! Surface rough length
  real(DP), save:: HeatCapacity
                              ! ɽǮ. 
                              ! Surface heat capacity
  real(DP), save:: TempFlux
                              ! Ǯեå. 
                              ! Ground temperature flux
  integer, save:: SurfCond
                              ! ɽ (0: , 1: ). 
                              ! Surface condition (0: fixed, 1: variable)
  real(DP), save:: SeaIceConc
                              ! ɹ̩
                              ! Sea ice concentration

  character(*), parameter:: module_name = 'surface_data'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: surface_data.f90,v 1.5 2010-01-22 05:26:49 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface SetSurfData
    module procedure SetSurfData
  end interface

contains

  subroutine SetSurfData( &
    & xy_SurfTemp, xy_SurfAlbedo, xy_SurfHumidCoef, & ! (out)
    & xy_SurfRoughLength, xy_SurfHeatCapacity,      & ! (out)
    & xy_GroundTempFlux, xy_SurfCond,               & ! (out)
    & xy_SeaIceConc &                                 ! (out)
    & )
    !
    ! GCM Ѥɽ̥ǡ֤ޤ.
    !
    ! Return surface data for GCM.
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat                 ! $ \varphi $ [rad.] . . Latitude

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out), optional:: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(out), optional:: xy_SurfAlbedo (0:imax-1, 1:jmax)
                              ! ɽ٥. 
                              ! Surface albedo
    real(DP), intent(out), optional:: xy_SurfHumidCoef (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(out), optional:: xy_SurfRoughLength (0:imax-1, 1:jmax)
                              ! ɽĹ. 
                              ! Surface rough length
    real(DP), intent(out), optional:: xy_SurfHeatCapacity (0:imax-1, 1:jmax)
                              ! ɽǮ. 
                              ! Surface heat capacity
    real(DP), intent(out), optional:: xy_GroundTempFlux (0:imax-1, 1:jmax)
                              ! Ǯեå. 
                              ! Ground temperature flux
    integer , intent(out), optional:: xy_SurfCond (0:imax-1, 1:jmax)
                              ! ɽ (0: , 1: ) . 
                              ! Surface condition (0: fixed, 1: variable)
    real(DP), intent(out), optional:: xy_SeaIceConc(0:imax-1, 1:jmax)
                              ! ɹ̩
                              ! Sea ice concentration

    ! ѿ
    ! Work variables
    !
!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. surface_data_inited ) call SurfDataInit

    select case ( LChar( trim(Pattern) ) )

    case ( 'homogeneous' )
      ! SST 
      ! SST is homogeneous
      !

      if ( present(xy_SurfTemp        ) ) xy_SurfTemp         = SurfTemp
      if ( present(xy_SurfAlbedo      ) ) xy_SurfAlbedo       = Albedo
      if ( present(xy_SurfHumidCoef   ) ) xy_SurfHumidCoef    = HumidCoef
      if ( present(xy_SurfRoughLength ) ) xy_SurfRoughLength  = RoughLength
      if ( present(xy_SurfHeatCapacity) ) xy_SurfHeatCapacity = HeatCapacity
      if ( present(xy_GroundTempFlux  ) ) xy_GroundTempFlux   = TempFlux
      if ( present(xy_SurfCond        ) ) xy_SurfCond         = SurfCond
      if ( present(xy_SeaIceConc      ) ) xy_SeaIceConc       = SeaIceConc

    case ( 'hosaka et al. (1998)' )
      ! Hosaka et al. (1998) ˤѤ줿 SST
      ! SST used in Hosaka et al. (1998)
      !

      if ( present(xy_SurfAlbedo      ) ) xy_SurfAlbedo       = Albedo
      if ( present(xy_SurfHumidCoef   ) ) xy_SurfHumidCoef    = HumidCoef
      if ( present(xy_SurfRoughLength ) ) xy_SurfRoughLength  = RoughLength
      if ( present(xy_SurfHeatCapacity) ) xy_SurfHeatCapacity = HeatCapacity
      if ( present(xy_GroundTempFlux  ) ) xy_GroundTempFlux   = TempFlux
      if ( present(xy_SurfCond        ) ) xy_SurfCond         = SurfCond
      if ( present(xy_SeaIceConc      ) ) xy_SeaIceConc       = SeaIceConc

      if ( present( xy_SurfTemp ) ) then
        call Hosakaetal98SST( &
          & xy_SurfTemp  & ! (out)
          & )
      end if

    case ( 'nh01_control' )
      ! Neale and Hoskins (2001)  Control experiment ˤѤ줿 SST
      ! SST used for Control experiment by Neale and Hoskins (2001)
      !

      if ( present(xy_SurfAlbedo      ) ) xy_SurfAlbedo       = Albedo
      if ( present(xy_SurfHumidCoef   ) ) xy_SurfHumidCoef    = HumidCoef
      if ( present(xy_SurfRoughLength ) ) xy_SurfRoughLength  = RoughLength
      if ( present(xy_SurfHeatCapacity) ) xy_SurfHeatCapacity = HeatCapacity
      if ( present(xy_GroundTempFlux  ) ) xy_GroundTempFlux   = TempFlux
      if ( present(xy_SurfCond        ) ) xy_SurfCond         = SurfCond
      if ( present(xy_SeaIceConc      ) ) xy_SeaIceConc       = SeaIceConc

      if ( present( xy_SurfTemp ) ) then
        call NH01SST( &
          & 'control',     & ! (in   )
          & xy_SurfTemp  & ! (inout)
          & )
      end if

    case default
      call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
        & c1 = trim(Pattern) )
    end select

  end subroutine SetSurfData

  !-------------------------------------------------------------------

  subroutine Hosakaetal98SST( &
    & xy_SurfTemp  & ! (out)
    & )
    !
    ! GCM Ѥɽ̥ǡ֤ޤ.
    !
    ! Return surface data for GCM.
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat                 ! $ \varphi $ [rad.] . . Latitude

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out) :: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature

    ! ѿ (Hosaka et al. (1998))
    ! Work variables (Hosaka et al. (1998))
    !
    real(DP):: TempEq         ! ƻ (Τˤ LatCenter ) Ǥβ.
                              ! Temperature on the equator 
                              ! (on LatCenter, to be exact)
    real(DP):: LatCenter      ! ٺǹΰ. 
                              ! Latitude on which temperature is maximum.
    real(DP):: LatFlatWidth   ! ٤ʿó. 
                              ! Latitude width in which temperature is flattened
    integer:: jp
    integer:: jm

    real(DP):: LatA, Alpha, Beta, Gamma

    real(DP):: Phi1, AlphaBeta4, Phi, LatAPlus, LatAMinus
    real(DP):: SurfTempMx

    ! ѿ
    ! Work variables
    !
!!$    integer:: i               ! ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. surface_data_inited ) call SurfDataInit

    ! Hosaka et al. (1998) ˤѤ줿 SST
    ! SST used in Hosaka et al. (1998)
    !

!!$    TempEq       = SurfTemp
    TempEq       = 302.0_DP
    LatCenter    =   0.0_DP
    LatFlatWidth =   7.0_DP

    LatA         =  30.0_DP
    Alpha        =  60.0_DP
    Beta         =  32.0_DP
    Gamma        =   0.0_DP

    Phi1 = abs( LatA * PI / 180.0_DP )
    AlphaBeta4  = 2.0_DP *( Phi1**3 ) * ( Beta / Alpha )

    do j = 1, jmax
      Phi = abs( y_Lat(j) - LatCenter * PI / 180.0_DP )
      xy_SurfTemp (:,j) = &
        & TempEq &
        & - Alpha / 2.0_DP &
        &   * ( Phi - max( sqrt( Phi1**2 + AlphaBeta4 ) - sqrt( ( Phi - Phi1 )**2 + AlphaBeta4 ), 0.0_DP ) ) &
        & + Gamma * ( Phi**3 )
    end do

    ! 濴 LatCenter +/- LatFlatWidth δ֤ʿó
    ! Flatten between LatCenter +/- LatFlatWidth
    !
    if ( LatFlatWidth < 0.0_DP ) then
      LatFlatWidth = - LatFlatWidth
    end if
    LatAPlus = ( LatCenter + LatFlatWidth ) * PI / 180.0_DP
    LatAMinus = ( LatCenter - LatFlatWidth ) * PI / 180.0_DP

    jp = 1
    jm = jmax
    do j = 1, jmax
      if ( y_Lat(j) <= LatAPlus ) then
        jp = j
        if ( j == jmax ) jp = jp - 1
      end if
      if ( y_Lat(j) < LatAMinus ) then
        jm = j
        if ( j == jmax ) jm = jm - 1
      end if
    end do

    if ( jmax /= 1 ) then
      SurfTempMx = &
        & (   xy_SurfTemp(1,jm) * ( y_Lat(jm+1) - LatAMinus ) &
        &   + xy_SurfTemp(1,jm+1) * ( LatAMinus - y_Lat(jm) ) &
        & ) &
        & / ( y_Lat(jm+1) - y_Lat(jm) )

      xy_SurfTemp(:,jm+1:jp) = SurfTempMx
    end if


  end subroutine Hosakaetal98SST

  !-------------------------------------------------------------------

  recursive subroutine NH01SST( &
    & SSTType,     & ! (in   )
    & xy_SurfTemp  & ! (inout)
    & )
    !
    ! Set SST described by Neale and Hoskins (2001)
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon,         &      ! $ \lambda $ [rad.] . . Longitude
      & y_Lat                 ! $ \varphi $ [rad.] . . Latitude

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none
    character(len=*), intent(in   ) :: SSTType
    real(DP)        , intent(inout) :: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲.
                              ! Surface temperature

    ! ѿ
    ! Work variables
    !
    real(DP) :: Temp0         ! Zero degree Celsius
                              ! Latitude width in which temperature is flattened
    real(DP) :: xy_SurfTempTmp1 (0:imax-1, 1:jmax)
    real(DP) :: xy_SurfTempTmp2 (0:imax-1, 1:jmax)

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
!!$    integer:: k               ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    Temp0 = 273.15d0

    if ( SSTType == 'control' ) then
      ! Neale and Hoskins (2001)  control experiment ˤѤ줿 SST
      ! SST used for control experiment by Neale and Hoskins (2001)
      !

      do j = 1, jmax
        if ( abs( y_Lat(j) ) < PI / 3.0d0 ) then
          xy_SurfTemp(:,j) = 27.0d0 * ( 1.0d0 - sin( 3.0d0 * y_Lat(j) / 2.0d0 )**2 )
        else
          xy_SurfTemp(:,j) = 0.0d0
        end if
      end do
      xy_SurfTemp = xy_SurfTemp + Temp0


    else if ( SSTType == 'peaked' ) then
      ! Neale and Hoskins (2001)  Peaked experiment ˤѤ줿 SST
      ! SST used for Peaked experiment by Neale and Hoskins (2001)
      !

      do j = 1, jmax
        if ( abs( y_Lat(j) ) < PI / 3.0d0 ) then
          xy_SurfTemp(:,j) = 27.0d0 * ( 1.0d0 - 3.0d0 * abs( y_Lat(j) ) / PI )
        else
          xy_SurfTemp(:,j) = 0.0d0
        end if
      end do
      xy_SurfTemp = xy_SurfTemp + Temp0

    else if ( SSTType == 'flat' ) then
      ! Neale and Hoskins (2001)  Flat experiment ˤѤ줿 SST
      ! SST used for Flat experiment by Neale and Hoskins (2001)
      !

      do j = 1, jmax
        if ( abs( y_Lat(j) ) < PI / 3.0d0 ) then
          xy_SurfTemp(:,j) = 27.0d0 * ( 1.0d0 - sin( 3.0d0 * y_Lat(j) / 2.0d0 )**4 )
        else
          xy_SurfTemp(:,j) = 0.0d0
        end if
      end do
      xy_SurfTemp = xy_SurfTemp + Temp0

    else if ( SSTType == 'control-5n' ) then
      ! Neale and Hoskins (2001)  Control-5N experiment ˤѤ줿 SST
      ! SST used for Control-5N experiment by Neale and Hoskins (2001)
      !

      do j = 1, jmax
        if ( y_Lat(j) < - PI / 3.0d0 ) then
          xy_SurfTemp(:,j) = 0.0d0
        else if ( y_Lat(j) < PI / 36.0d0 ) then
          xy_SurfTemp(:,j) = 27.0d0                                             &
            & * ( 1.0d0 - sin( 90.0d0/65.0d0 * ( y_Lat(j) - PI/36.0d0 ) )**2 )
        else if ( y_Lat(j) < PI / 3.0d0 ) then
          xy_SurfTemp(:,j) = 27.0d0                                             &
            & * ( 1.0d0 - sin( 90.0d0/55.0d0 * ( y_Lat(j) - PI/36.0d0 ) )**2 )
        else
          xy_SurfTemp(:,j) = 0.0d0
        end if
      end do
      xy_SurfTemp = xy_SurfTemp + Temp0

    else if ( SSTType == 'qobs' ) then
      ! Neale and Hoskins (2001)  Qobs experiment ˤѤ줿 SST
      ! SST used for Qobs experiment by Neale and Hoskins (2001)
      !

      call NH01SST( &
        & 'control',     & ! (in   )
        & xy_SurfTempTmp1  & ! (inout)
        & )
      call NH01SST( &
        & 'control',     & ! (in   )
        & xy_SurfTempTmp2  & ! (inout)
        & )
      xy_SurfTemp = ( xy_SurfTempTmp1 + xy_SurfTempTmp2 ) * 0.5d0

!!$    else if ( SSTType == '1keq' ) then
!!$      ! Neale and Hoskins (2001)  1KEQ experiment ˤѤ줿 SST
!!$      ! SST used for 1KEQ experiment by Neale and Hoskins (2001)
!!$      !
!!$
!!$      call NH01SST( &
!!$        & 'control',     & ! (in   )
!!$        & xy_SurfTemp  & ! (inout)
!!$        & )
!!$
!!$      do j = 1, jmax
!!$        do i = 1,
!!$          if ( ( abs( x_Lon(i) - PI ) < PI /  3.0d0 ) .and. &
!!$            &  ( abs( y_Lat(j)      ) < PI / 12.0d0 ) ) then
!!$            xy_SurfTemp(i,j) = xy_SurfTemp(i,j)                                 &
!!$              & + 1.0d0 * cos( PI/2.0d0 * ( x_Lon(i) - PI ) / ( PI ) )**2       &
!!$              &         * cos( PI/2.0d0 * y_Lat(j)          / ( PI ) )**2 )
!!$          end if
!!$        end do
!!$      end do

    else
      call MessageNotify( 'E', module_name, 'SSTType=<%c> is invalid.', &
        & c1 = trim(SSTType) )
    end if


  end subroutine NH01SST

  !-------------------------------------------------------------------

  subroutine SurfDataInit

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /surface_data_nml/ Pattern, &
      & SurfTemp, Albedo, HumidCoef, RoughLength, &
      & HeatCapacity, TempFlux, SurfCond, &
      & SeaIceConc
          !
          ! ǥեͤˤĤƤϽ³ "surface_data#SurfDataInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "surface_data#SurfDataInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement

    if ( surface_data_inited ) return
    call InitCheck

    ! ǥեͤ (ޤ Pattern Τ)
    ! Default values settings (At first, "Pattern" only)
    !
    Pattern      = 'Hosaka et al. (1998)'
    SurfTemp     = 273.15_DP
    Albedo       = 0.15_DP
    HumidCoef    = 1.0_DP
    RoughLength  = 1.0e-4_DP
    HeatCapacity = 0.0_DP
    TempFlux     = 0.0_DP
    SurfCond     = 0
    SeaIceConc   = 0.0_DP

    ! NAMELIST ɤ߹ (ޤ Pattern Τ)
    ! NAMELIST is input (At first, "Pattern" only)
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = surface_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = surface_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  Pattern = %c', c1 = trim(Pattern) )
    call MessageNotify( 'M', module_name, '  SurfTemp     = %f', d = (/ SurfTemp     /) )
    call MessageNotify( 'M', module_name, '  Albedo       = %f', d = (/ Albedo       /) )
    call MessageNotify( 'M', module_name, '  HumidCoef    = %f', d = (/ HumidCoef    /) )
    call MessageNotify( 'M', module_name, '  RoughLength  = %f', d = (/ RoughLength  /) )
    call MessageNotify( 'M', module_name, '  HeatCapacity = %f', d = (/ HeatCapacity /) )
    call MessageNotify( 'M', module_name, '  TempFlux     = %f', d = (/ TempFlux     /) )
    call MessageNotify( 'M', module_name, '  SurfCond     = %d', i = (/ SurfCond     /) )
    call MessageNotify( 'M', module_name, '  SeaIceConc   = %f', d = (/ SeaIceConc   /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    surface_data_inited = .true.
  end subroutine SurfDataInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited


    ! ¹ʸ ; Executable statement

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

  end subroutine InitCheck

end module surface_data
