program diffusion
  use analy
  use Algebra
  use Math_Const
  use dcl
  use Dcl_Automatic
  implicit none
  real, allocatable, dimension(:,:) :: dtemp, mat
  real, allocatable, dimension(:) :: temp, z, new_temp, laplace, top_bound, lambda, rhow, rhoi, a0, b0
  real :: dz, dt, zdepth, tmax, year, dr
  real :: kappaw, kappai
  real, parameter :: bottom_bound=0.0, cpw=4.2, cpi=2.1, t_const=280.0
  integer :: nz, nstep, dmp_time, method
  integer :: i, j, k
  character(4) :: dmp_timec

!-- read namelist
  namelist /input /zdepth, dt, nstep, nz, kappaw, kappai, method
  read(5,nml=input)

!-- tmax
  tmax=dt*nstep
  year=3.6e6*2.4*3.65

!-- allocate
  allocate(temp(nz))
  allocate(new_temp(nz))
  allocate(z(nz))
  allocate(laplace(nz))
  allocate(lambda(nz))
  allocate(rhoi(nz))
  allocate(rhow(nz))
  allocate(dtemp(nz,1))
  allocate(top_bound(nstep))
  allocate(mat(nz,nz))
  allocate(a0(nz))
  allocate(b0(nz))

!-- lambda calc
  do i=1,nz
     rhow(i)=1.0e6
     rhoi(i)=8.0e5
     lambda(i)=kappaw/(rhow(i)*cpw)
  end do

!-- top boundary
  do i=1,nstep
     top_bound(i)=t_const+10.0*sin(2.0*pi*dt*real(i-1)/year)
  end do

!-- initial condition
  dz=zdepth/(nz-1)
  z=(/((-dz*(i-1)),i=1,nz)/)
  dr=dt/(dz*dz)
  do i=1,nz
     temp(i)=t_const
     new_temp(i)=0.0
     dtemp(i,1)=temp(i)
  end do

  call DclOpenGraphics(4)

  do i=1,nstep
!-- lambda calc

     do j=1,nz
        if(temp(j)<273.15)then
           lambda(j)=kappai/(rhoi(j)*cpi)
        else
           lambda(j)=kappaw/(rhow(j)*cpw)
        end if
     end do

     if(method==1)then
!-- forward euler
        call laplacian_1d( z, temp, laplace )
        do j=2,nz-1
           new_temp(j)=temp(j)+dt*lambda(j)*laplace(j)
        end do
     else
!-- CN
        do j=2,nz-1
           do k=2,nz-1
              if(k==j)then
                 mat(k,j)=2.0+2.0*lambda(j)*dr
!-- lambda ϹѲ뤬, ԤˤĤƱͤȤƤФ褤.
!-- ѲΤ, Ѳ.
                 if(k==j.and.k==nz-1)then
                    mat(k,j)=2.0+lambda(j)*dr
                 end if
              else
                 if(k==j-1.or.k==j+1)then
                    mat(k,j)=-lambda(j)*dr
                 else
                    mat(k,j)=0.0
                 end if
              end if
           end do

           b0(j)=2.0*(1.0-lambda(j)*dr)*temp(j)  &
  &              +lambda(j)*dr*(temp(j-1)+temp(j+1))
           if(j==2)then
              b0(j)=b0(j)+lambda(j)*dr*top_bound(i)
           end if
        end do

        call gausss( mat(2:nz-1,2:nz-1), b0(2:nz-1), new_temp(2:nz-1) )

     end if

!-- boundary condition
     new_temp(1)=top_bound(i)
     new_temp(nz)=new_temp(nz-1)

     if(mod(int(dt)*(i-1),3600*24)==0)then
        dmp_time=int(dt)*(i-1)/(3600*24)
        write(dmp_timec,'(i4)') dmp_time
        call Dcl_PL( 'l', 't='//dmp_timec, dtemp, z, dtemp, z, 'temperature',  &
  &                  'depth', xmin=270.0, xmax=290.0, ymin=z(nz), ymax=z(1) )
     end if
!-- newer
     do j=1,nz
        temp(j)=new_temp(j)
        dtemp(j,1)=new_temp(j)
     end do

  end do

  call DclCloseGraphics

end program
