module complex_initialize
! 複素変数の初期化
! 複素数での微分も担当する

  use Derivation
  use val_define
  use read_namelist
  use val_alloc
  use val_coord

contains

subroutine complex_init( val )
  implicit none
  complex, intent(inout) :: val(:,:)
  integer :: nx, ny, i, j

  nx=size(val,1)
  ny=size(val,2)

  do j=1,ny
     do i=1,nx
        val(i,j)=(0.0,0.0)
     end do
  end do

end subroutine

subroutine complex_grad_1d( x, val, grad_val )
! 複素数の空間微分を行う.
  implicit none
  real, intent(in) :: x(:)
  complex, intent(in) :: val(size(x))
  complex, intent(inout) :: grad_val(size(x))
  real :: rval(size(x)), ival(size(x))
  real :: r_grad_val(size(x)), i_grad_val(size(x))
  integer :: i, nx

  nx=size(x)

  do i=1,nx
     rval(i)=real(val(i))
     ival(i)=aimag(val(i))
  end do

  call grad_1d( x, rval, r_grad_val )
  call grad_1d( x, ival, i_grad_val )

  do i=1,nx
     grad_val(i)=r_grad_val(i)+img*i_grad_val(i)
  end do

end subroutine

end module
