module ffts
! fft ϢΥ֥롼
  use Math_Const

contains

subroutine ffttp_1d( nx, a, b, csign, prim, prim_fact, omega_fix, omegan_fix )
!  Temperton's FFT
!
!  1d  fft  csign Ȥ, Ѵ, Ѵ롼
  use Math_Const
  implicit none
  integer, intent(in) :: nx  ! ǿ
  complex, intent(in), dimension(0:nx-1) :: a  ! 
  complex, intent(inout), dimension(0:nx-1) :: b  ! 
  character(1), intent(in) :: csign  ! ѴȽ [r=Ѵ, i=Ѵ]
  character(1), optional, intent(in) :: prim  ! ǰʬ򤹤뤫ɤ
  ! [o=ʬ򤹤, x=ʬ򤷤ʤ] default=ʬ򤷤ʤ. ξ, ̾ DFT.
  ! ǰʬ򤹤, nx=2^a*3^b*5^c*7^d ޤǤʬ򤷤ʤ褦ˤ.
  ! , 'x' ΤȤǤ, prim_fact ꤵƤ, Τ٤ FFT .
  integer, dimension(5), optional :: prim_fact  ! prim = x ΤȤꤹ
  ! Τ٤ FFT Ԥ. prim_fact=(/a,b,c,d,e/) : 2^a*3^b*5^c*7^d*e
  complex, dimension(0:nx-1,0:nx-1), intent(in), optional :: omega_fix
                       ! ;ǰбž
  complex, dimension(0:nx-1,0:nx-1), intent(in), optional :: omegan_fix  ! ž
  integer, allocatable, dimension(:) :: l, m, n  ! κ
  complex :: ctmp
  integer :: stat, counter, base
  integer :: i, j, k, id, jd, kd  ! do loop 
  integer, parameter, dimension(4) :: prim_dim=(/2, 3, 5, 7/)  ! ǰ
  integer, dimension(4) :: prim_num  ! ǰΤ٤
  complex, allocatable, dimension(:,:) :: omega
  complex, dimension(0:nx-1,0:nx-1) :: omegan
  complex, dimension(0:nx-1) :: c  ! tmp array
  complex, dimension(0:1,0:1) :: omega2  ! ȿ 2 βž
  complex, dimension(0:2,0:2) :: omega3  ! ȿ 3 βž
  complex, dimension(0:4,0:4) :: omega5  ! ȿ 5 βž
  complex, dimension(0:6,0:6) :: omega7  ! ȿ 7 βž


  base=nx
  prim_num=0
  counter=0

  do i=0,nx-1
     b(i)=a(i)
  end do

  if(real(romega2(1,1))/=-1.0.or.aimag(romega2(1,1))/=1.0.or.  &
  &  real(iomega2(1,1))/=-1.0.or.aimag(iomega2(1,1))/=1.0)then
     ! math_const  rotate_array 롼󤬷׻Ƥʤ, ư.
     call rotate_array()
  end if

!-- ǰʬ򤹤
  if(present(prim))then
     if(prim=='o')then
        if(present(prim_fact))then
           do i=1,4
!              if(prim_fact(i)==0)then
!                 prim_num(i)=1
!              else
                 prim_num(i)=prim_fact(i)
!              end if
              counter=counter+prim_fact(i)
           end do
           base=prim_fact(5)
        else
           call prim_calc( nx, prim_num, base )
           do i=1,4
              counter=counter+prim_num(i)
           end do
        end if
 
        if(base==1)then
           counter=counter-1
        end if
 
        if(counter/=0)then  ! prim=='o' ǤäƤ, ǰʬǤʤ DFT .
           allocate(l(counter+1))
           allocate(m(counter+1))
           allocate(n(counter+1))
           stat=0
           l=0
           m=0
           n=0
   
           do i=1,4
              if(prim_num(i)/=0)then
                 select case(prim_dim(i))
                 case(2)
                    n(stat+1:stat+prim_num(i))=2
                 case(3)
                    n(stat+1:stat+prim_num(i))=3
                 case(5)
                    n(stat+1:stat+prim_num(i))=5
                 case(7)
                    n(stat+1:stat+prim_num(i))=7
                 end select
                 stat=stat+prim_num(i)
              end if
           end do
           if(base/=1)then
              n(counter+1)=base
           end if
        end if
     end if
  end if

!-- ž

  if(counter/=0)then
     select case (csign)
     case ('r')
        do j=0,1
           do i=0,1
              omega2(i,j)=romega2(i,j)
           end do
        end do
        do j=0,2
           do i=0,2
              omega3(i,j)=romega3(i,j)
           end do
        end do
        do j=0,4
           do i=0,4
              omega5(i,j)=romega5(i,j)
           end do
        end do
        do j=0,6
           do i=0,6
              omega7(i,j)=romega7(i,j)
           end do
        end do
     case ('i')
        do j=0,1
           do i=0,1
              omega2(i,j)=iomega2(i,j)
           end do
        end do
        do j=0,2
           do i=0,2
              omega3(i,j)=iomega3(i,j)
           end do
        end do
        do j=0,4
           do i=0,4
              omega5(i,j)=iomega5(i,j)
           end do
        end do
        do j=0,6
           do i=0,6
              omega7(i,j)=iomega7(i,j)
           end do
        end do
     end select
  end if

  if(present(omegan_fix))then
     allocate(omega(0:base-1,0:base-1))
     do j=0,base-1
        do i=0,base-1
           omega(i,j)=omega_fix(i,j)
        end do
     end do
     do j=0,nx-1
        do i=0,nx-1
           omegan(i,j)=omegan_fix(i,j)
        end do
     end do
  else
     allocate(omega(0:base-1,0:base-1))
     call rotate_calc( nx, csign, (/prim_num(1), prim_num(2), prim_num(3),  &
  &                    prim_num(4), base/), omega, omegan )
  end if

!-- FFT 

  if(counter/=0)then
!-- 
     m(1)=1
     l(1)=nx/(n(1)*m(1))
     do i=2,counter+1
        m(i)=m(i-1)*n(i-1)
        l(i)=nx/(n(i)*m(i))
     end do

!-- Ѵ W 

     do kd=1,counter+1
        do jd=0,l(kd)-1
           do id=0,n(kd)-1
              do k=0,m(kd)-1
                 ctmp=b(jd*m(kd)+k)
                 do j=1,n(kd)-1
                    select case(n(kd))
                    case(2)
                       ctmp=ctmp+omega2(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case(3)
                       ctmp=ctmp+omega3(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case(5)
                       ctmp=ctmp+omega5(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case(7)
                       ctmp=ctmp+omega7(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case default
                       ctmp=ctmp+omega(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    end select
                 end do
                 c(jd*n(kd)*m(kd)+id*m(kd)+k)=ctmp*omegan(m(kd),(id*jd))
              end do
           end do
        end do
        do id=0,nx-1
           b(id)=c(id)
        end do
     end do

  else

     do j=0,nx-1
        b(j)=a(0)
        do i=1,nx-1
           b(j)=b(j)+a(i)*omegan(i,j)
        end do
     end do

  end if

  if(csign=='r')then
     do j=0,nx-1
        b(j)=b(j)/real(nx)
     end do
  end if

end subroutine

!-----------------------------------------------

subroutine ffttp_2d( nx, ny, a, b, csign, prim, prim_fact, omega_fix,  &
  &                  omegan_fix )
!  Temperton's FFT (2d ver)
!
!  2d  fft  csign Ȥ, Ѵ, Ѵ롼
  use Math_Const
  implicit none
  integer, intent(in) :: nx  ! ǿ 1
  integer, intent(in) :: ny  ! ǿ 2
  complex, intent(in), dimension(0:nx-1,0:ny-1) :: a  ! 
  complex, intent(inout), dimension(0:nx-1,0:ny-1) :: b  ! 
  character(1), intent(in) :: csign  ! ѴȽ [r=Ѵ, i=Ѵ]
  character(1), optional, intent(in) :: prim  ! ǰʬ򤹤뤫ɤ
  ! [o=ʬ򤹤, x=ʬ򤷤ʤ] default=ʬ򤷤ʤ. ξ, ̾ DFT.
  ! ǰʬ򤹤, nx=2^a*3^b*5^c*7^d ޤǤʬ򤷤ʤ褦ˤ.
  ! , 'x' ΤȤǤ, prim_fact ꤵƤ, Τ٤ FFT .
  integer, dimension(5), optional :: prim_fact  ! prim = x ΤȤꤹ
  ! Τ٤ FFT Ԥ. prim_fact=(/a,b,c,d/) : 2^a*3^b*5^c*7^d
  ! , prim_fact ꤹ٤ nx Τ٤Ǥ뤳Ȥ.
  complex, dimension(0:nx-1,0:nx-1), intent(in), optional :: omega_fix  ! ;ǰбž
  complex, dimension(0:nx-1,0:nx-1), intent(in), optional :: omegan_fix  ! ž
  integer :: i

  if(present(prim))then
     if(present(prim_fact))then
        if(present(omegan_fix))then
           do i=0,ny-1
              call ffttp_1d( nx, a(0:nx-1,i), b(0:nx-1,i), csign, prim,  &
  &                          prim_fact, omega_fix(0:nx-1,0:nx-1),  &
  &                          omegan_fix(0:nx-1,0:nx-1) )
           end do
        else
           do i=0,ny-1
              call ffttp_1d( nx, a(0:nx-1,i), b(0:nx-1,i), csign, prim, prim_fact )
           end do
        end if
     else
        do i=0,ny-1
           call ffttp_1d( nx, a(0:nx-1,i), b(0:nx-1,i), csign, prim )
        end do
     end if
  else
     do i=0,ny-1
        call ffttp_1d( nx, a(0:nx-1,i), b(0:nx-1,i), csign )
     end do
  end if

end subroutine

!-----------------------------------------------

subroutine r2c_ffttp_1d( nx, a, b, prim, prim_fact, omega_fix, omegan_fix )
! 1  FFT ׻롼
!
! ϼ¿ǹԤ, ʣǿ֤.
  use Math_Const
  implicit none
  integer, intent(in) :: nx  ! 1 ǡǿ
  real, intent(in), dimension(0:nx-1) :: a  ! ϼ¿ǡ
  complex, intent(inout), dimension(0:nx/2-1) :: b  ! ʣǿǡ
  character(1), optional, intent(in) :: prim  ! ǰʬ򤹤뤫ɤ
  ! [o=ʬ򤹤, x=ʬ򤷤ʤ] default=ʬ򤷤ʤ. ξ, ̾ DFT.
  ! ǰʬ򤹤, nx=2^a*3^b*5^c*7^d ޤǤʬ򤷤ʤ褦ˤ.
  ! ʤ,  FFT Ѵϸ, ǡǿѴԤʤ褦
  ! Ƥ뤳Ȥ (ǡѴ褦Ȥȥ顼֤).
  ! ޤ, inout °ΰ, ǡȾʬˤʤäƤ뤳Ȥ.
  ! ͤȤ, nx/2 ܤμ¿ǡ, n=0 ܤε˳Ǽ
  ! Ϥ뤳Ȥ.
  ! , 'x' ΤȤǤ, prim_fact ꤵƤ, Τ٤ FFT .
  integer, dimension(5), intent(in), optional :: prim_fact  ! prim = x ΤȤꤹ
  ! Τ٤ FFT Ԥ. prim_fact=(/a,b,c,d/) : 2^a*3^b*5^c*7^d
  ! Ϥ٤ nx Τ٤Ǥ.
  complex, dimension(0:nx/2-1,0:nx/2-1), intent(in), optional :: omega_fix  ! ;ǰбž
  complex, dimension(0:nx/2-1,0:nx/2-1), intent(in), optional :: omegan_fix  ! ž
  complex, dimension(0:nx/2-1) :: c, d
  integer :: i
  integer, dimension(5) :: prim_num

  if(mod(nx,2)/=0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "nx must be even number. Stop."
     stop
  end if

!-- nx Ĥμ¿ǡ nx/2 Ĥʣǿǡ֤.
  do i=0,nx/2-1
     c(i)=a(2*i)+img*a(2*i+1)
  end do

!-- FFT 

  if(present(prim))then
     if(present(prim_fact))then
        prim_num=prim_fact
        prim_num(1)=prim_num(1)-1  ! ǡǿȾʬˤʤäƤ뤿,
                                   ! 2 Τ٤ 1 ĸäƤ.
        if(present(omegan_fix))then
           call ffttp_1d( nx/2, c, d, 'r', prim, prim_num,  &
  &                       omega_fix(0:nx/2-1,0:nx/2-1),  &
  &                       omegan_fix(0:nx/2-1,0:nx/2-1) )
        else
           call ffttp_1d( nx/2, c, d, 'r', prim, prim_num )
        end if
     else
        call ffttp_1d( nx/2, c, d, 'r', prim )
     end if
  else
     call ffttp_1d( nx/2, c, d, 'r' )
  end if

!-- Ѵ
!-- b(N) μ b(0) εȤ߹ळȤˤ.
!-- b(k) η׻ 0.25 򤫤Τ,  fft  2/N ǵʲƤ,
!-- Ȥη׻Ǥ, 1/2N ǵʲʤФʤʤΤ,
!-- 1/4 򤫤뤳Ȥ, 2/N -> 1/2N ǵʲȤˤʤ.
!-- b(0) ˤäƤ뷸⤽.
  b(0)=0.5*((real(d(0))+aimag(d(0)))+img*(real(d(0))-aimag(d(0))))
  do i=1,nx/2-1
     b(i)=0.25*((conjg(d(nx/2-i))+d(i))  &
  &       -(sin(2.0*pi*real(i)/real(nx))+img*cos(2.0*pi*real(i)/real(nx)))  &
  &       *(d(i)-conjg(d(nx/2-i))))
  end do

end subroutine

!-----------------------------------------------

subroutine c2r_ffttp_1d( nx, a, b, prim, prim_fact, omega_fix, omegan_fix )
! 1  FFT Ѵ׻롼
!
! ʣǿǹԤ,¿֤.
  use Math_Const
  implicit none
  integer, intent(in) :: nx  ! 1 ǡǿ
  complex, intent(in), dimension(0:nx/2-1) :: a  ! ʣǿǡ
  real, intent(inout), dimension(0:nx-1) :: b  ! ϼ¿ǡ
  character(1), optional, intent(in) :: prim  ! ǰʬ򤹤뤫ɤ
  ! [o=ʬ򤹤, x=ʬ򤷤ʤ] default=ʬ򤷤ʤ. ξ, ̾ DFT.
  ! ǰʬ򤹤, nx=2^a*3^b*5^c*7^d ޤǤʬ򤷤ʤ褦ˤ.
  ! ʤ,  FFT Ѵϸ, ǡǿѴԤʤ褦
  ! Ƥ뤳Ȥ (ǡѴ褦Ȥȥ顼֤).
  ! ޤ, in °ΰ, ǡȾʬˤʤäƤ뤳Ȥ.
  ! ͤȤ, ϰ n=0  nx/2 ܤμ¿ǡäƤ褦
  ! ǡϤ.
  ! , 'x' ΤȤǤ, prim_fact ꤵƤ, Τ٤ FFT .
  integer, intent(in), optional, dimension(5) :: prim_fact  ! prim = x ΤȤꤹ
  ! Τ٤ FFT Ԥ. prim_fact=(/a,b,c,d/) : 2^a*3^b*5^c*7^d
  complex, dimension(0:nx/2-1,0:nx/2-1), intent(in), optional :: omega_fix  ! ;ǰбž
  complex, dimension(0:nx/2-1,0:nx/2-1), intent(in), optional :: omegan_fix  ! ž
  complex, dimension(0:nx/2-1) :: c, d
  integer :: i
  integer, dimension(5) :: prim_num

  if(mod(nx,2)/=0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "nx must be even number. Stop."
     stop
  end if

!-- nx/2 ĤʣǿǡΩʥաꥨˤƱʣǿǡ֤.
  c(0)=a(0)
  do i=1,nx/2-1
     c(i)=(a(i)+conjg(a(nx/2-i)))  &
  &       +(img*cos(2.0*pi*i/real(nx))-sin(2.0*pi*i/real(nx)))  &
  &       *(a(i)-conjg(a(nx/2-i)))
  end do

!-- FFT 

  if(present(prim))then
     if(present(prim_fact))then
        prim_num=prim_fact
        prim_num(1)=prim_num(1)-1    ! ǡǿȾʬˤʤäƤ뤿,
                                     ! 2 Τ٤ 1 ĸäƤ.
        if(present(omegan_fix))then
           call ffttp_1d( nx/2, c, d, 'i', prim, prim_num,  &
  &                       omega_fix(0:nx/2-1,0:nx/2-1),  &
  &                       omegan_fix(0:nx/2-1,0:nx/2-1) )
        else
           call ffttp_1d( nx/2, c, d, 'i', prim, prim_num )
        end if
     else
        call ffttp_1d( nx/2, c, d, 'i', prim )
     end if
  else
     call ffttp_1d( nx/2, c, d, 'i' )
  end if

!-- Ѵ
  do i=0,nx/2-1
     b(2*i)=real(d(i))
     b(2*i+1)=aimag(d(i))
  end do

end subroutine

!-----------------------------------------------

subroutine rotate_calc( nx, csign, prim_fact, omega, omegan )
!  FFT ˻Ѥž׻.
  use Math_Const
  implicit none
  integer, intent(in) :: nx  ! ǿ
  character(1), intent(in) :: csign  ! ѴȽ [r=Ѵ, i=Ѵ]
  integer, dimension(5) :: prim_fact  ! prim = x ΤȤꤹ
  ! Τ٤ FFT Ԥ. prim_fact=(/a,b,c,d,e/) : 2^a*3^b*5^c*7^d*e
  complex, dimension(0:prim_fact(5)-1,0:prim_fact(5)-1), intent(inout) :: omega
  ! ;бž
  complex, dimension(0:nx-1,0:nx-1), intent(inout) :: omegan ! ž
  integer :: counter, base
  integer :: i, j  ! do loop 

  base=prim_fact(5)

  counter=0
  do i=1,4
     counter=counter+prim_fact(i)
  end do

!-- ž

  select case(csign)
  case('r')
     if(counter/=0)then
        if(base/=1)then
           do j=0,base-1
              do i=0,base-1
                 omega(i,j)=cos(2.0*pi*i*j/real(base))-img*sin(2.0*pi*i*j/real(base))
              end do
           end do
        end if
        do j=0,nx-1
           do i=0,nx-1
              omegan(i,j)=cos(2.0*pi*i*j/real(nx))-img*sin(2.0*pi*i*j/real(nx))
           end do
        end do

     else
        do j=0,nx-1
           do i=0,nx-1
              omega(i,j)=cos(2.0*pi*i*j/real(nx))-img*sin(2.0*pi*i*j/real(nx))
              omegan(i,j)=omega(i,j)
           end do
        end do
     end if


  case('i')
     if(counter/=0)then
        if(base/=1)then
           do j=0,base-1
              do i=0,base-1
                 omega(i,j)=cos(2.0*pi*i*j/real(base))+img*sin(2.0*pi*i*j/real(base))
              end do
           end do
        end if
        do j=0,nx-1
           do i=0,nx-1
              omegan(i,j)=cos(2.0*pi*i*j/real(nx))+img*sin(2.0*pi*i*j/real(nx))
           end do
        end do
     else
        do j=0,nx-1
           do i=0,nx-1
              omega(i,j)=cos(2.0*pi*i*j/real(nx))+img*sin(2.0*pi*i*j/real(nx))
              omegan(i,j)=omega(i,j)
           end do
        end do
     end if

  case default
     write(*,*) "******** ERROR : csign is bad. **********"
     write(*,*) "Stop!"
     stop
  end select

end subroutine

!-----------------------------------------------

subroutine prim_calc( n, factor, resid )
  ! 2,3,5,7 ˤĤƤǰʬԤ.
  implicit none
  integer, intent(in) :: n  ! ʬ򤹤
  integer, intent(inout), dimension(4) :: factor  ! ʬ򤷤Ȥγǰ
  ! ΤȤ, factor(1:4)=(/a,b,c,d/) Ǥ, factor(5)=e Ȥ,
  ! n=2^a*3^b*5^c*7^d*e ȤˤʤäƤ.
  integer, intent(inout) :: resid  ! residual prim factor
  integer :: i, base
  integer, dimension(4) :: prim_dim

  prim_dim=(/2,3,5,7/)
  base=n
  factor=(/0,0,0,0/)
  do i=1,4
     do while(mod(base,prim_dim(i))==0)
        base=base/prim_dim(i)
        factor(i)=factor(i)+1
     end do
  end do

  resid=base

end subroutine

end module
