program make_stretch
!-- producing stretching coefficient data of zeta
!-- Version Rozoff et al. (2009).

  use gtool_history

  implicit none

  integer, parameter :: nc=10

!-- namelist variables

  integer :: nx, ny
  integer :: nnum
  real, allocatable, dimension(:) :: xr, yr
  double precision :: xmin, ymin, dx, dy, coe_cav
  double precision, dimension(nc) :: cr, rn, dn
  character(1000) :: fname, sig

  integer :: i, j, k
  double precision :: r
  double precision, dimension(nc) :: tcx, tcy
  double precision, allocatable, dimension(:) :: x, y
  double precision, allocatable, dimension(:,:) :: cav
  double precision :: makec

  namelist /initial /nx, ny, xmin, ymin, dx, dy, fname,  &
  &                  tcx, tcy
  namelist /vprof /cr, rn, dn, nnum, sig, coe_cav
  read(5,nml=initial)
  read(5,nml=vprof)

  if(nnum>nc)then
     write(*,*) "*** ERROR (main) *** : namelist variable 'nnum' is <=", nnum, '.'
     write(*,*) "STOP."
     stop
  end if

  allocate(x(nx))
  allocate(y(ny))
  allocate(xr(nx))
  allocate(yr(ny))
  allocate(cav(nx,ny))

  x=(/((xmin+dx*dble(i-1)),i=1,nx)/)
  y=(/((ymin+dy*dble(j-1)),j=1,ny)/)

  xr=(/((xmin+dx*real(i-1)),i=1,nx)/)
  yr=(/((ymin+dy*real(j-1)),j=1,ny)/)

  cav=0.0d0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,r)

  do j=1,ny
     do i=1,nx
        r=dsqrt((x(i)-tcx(1))**2+(y(j)-tcy(1))**2)
!        if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)>0.0d0)then
!           theta=datan((y(j)-tcy(1))/(x(i)-tcx(1)))
!        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)>0.0d0)then
!           theta=dabs(dacos(-1.0d0))-datan((y(j)-tcy(1))/dabs(x(i)-tcx(1)))
!        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)<0.0d0)then
!           theta=dabs(dacos(-1.0d0))+datan(dabs(y(j)-tcy(1))/dabs(x(i)-tcx(1)))
!        else if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)<0.0d0)then
!           theta=2.0d0*dabs(dacos(-1.0d0))-datan(dabs(y(j)-tcy(1))/(x(i)-tcx(1)))
!        else if(x(i)-tcx(1)==0.0d0.and.y(j)-tcy(1)<0.0d0)then
!           theta=1.5d0*dabs(dacos(-1.0d0))
!        else if(x(i)-tcx(1)==0.0d0.and.y(j)-tcy(1)>0.0d0)then
!           theta=0.5d0*dabs(dacos(-1.0d0))
!        else if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)==0.0d0)then
!           theta=0.0d0
!        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)==0.0d0)then
!           theta=dabs(dacos(-1.0d0))
!        end if
        cav(i,j)=makec( r, nnum, cr(1:nnum),  &
  &                     rn(1:nnum-1), dn(1:nnum-1), sig(1:nnum-1), coe_cav )
     end do
  end do

!$omp end do
!$omp end parallel

  call HistoryCreate( file=trim(adjustl(fname)), title='Stretching profile', &
  & source='test', institution='test', dims=(/'x', 'y'/),  &
  & dimsizes=(/ nx, ny /),  &
  & longnames=(/'X-coordinate','Y-coordinate'/),  &
  & units=(/'m', 'm'/) )

  call HistoryPut( 'x', xr )
  call HistoryPut( 'y', yr )

  call HistoryAddVariable( varname='cr', dims=(/'x','y'/), &
  &    longname='stretching coefficient', units='s-1', xtype='double' )

  call HistoryAddVariable( varname='xd', dims=(/'x'/), &
  &    longname='X-coord double', units='m', xtype='double' )

  call HistoryAddVariable( varname='yd', dims=(/'y'/), &
  &    longname='Y-coord double', units='m', xtype='double' )

  call HistoryPut( 'cr', cav )
  call HistoryPut( 'xd', x )
  call HistoryPut( 'yd', y )

  call HistoryClose()

end program

!contains

double precision function makec( radi, nnum, coef_sth, rn, dn, sig, ccav )

  use Math_Const

  implicit none

  double precision :: radi  ! radius [m]
  integer :: nnum
  double precision :: coef_sth(nnum)
  double precision :: rn(nnum-1)
  double precision :: dn(nnum-1)
  character(nnum) :: sig
  double precision :: ccav
  integer :: i, k
  double precision :: FS, val, coe, s, s1, s2

  FS(val)=1.0d0-3.0d0*(val**2)+2.0d0*(val**3)

  if(radi>=0.0d0.and.radi<rn(1)-dn(1))then
     makec=coef_sth(1)

  else if(radi>=rn(nnum-1)+dn(nnum-1))then
     makec=coef_sth(nnum)

  else if(radi>=rn(1)-dn(1).and.radi<rn(nnum-1)+dn(nnum-1))then
     do k=1,nnum-1
        if(radi>=rn(k)-dn(k).and.radi<rn(k)+dn(k))then  ! Hermite
           coe=0.5d0/dn(k)
           s1=coe*(radi-rn(k)+dn(k))
           s2=coe*(rn(k)+dn(k)-radi)
           s=0.0d0

           if(sig(k:k)=='+')then
              s=s2
           else if(sig(k:k)=='-')then
              s=s1
           end if

           makec=coef_sth(k)*FS(s1)+coef_sth(k+1)*FS(s2)

           exit

        else if(radi>=rn(k)+dn(k))then
           if(radi<rn(k+1)-dn(k+1))then  ! constant
        !-- k=nnum-1 の場合, rn(nnum) となるので, 配列の領域外参照が起こるが,
        !   その場合の条件, radi>=rn(nnum-1)+dn(nnum-1) はこの if 文の
        !   別エントリーにあるので, そもそも k=nnum-1 はこの else if に
        !   入ってこない.

              makec=coef_sth(k+1)

              exit

           end if
        end if
     end do

  end if

  makec=ccav*makec

  return

end function makec

!end program
