program sound_intrp
! sound_conv で出力されたテキストデータを, 等間隔のデータに内挿処理するプログラム.
! ゾンデデータのフォーマットはテキスト形式のみサポート
! リストファイルのフォーマット:
! 1 列目: 入力ファイル名, 2 列目: 出力ファイル名

  use file_operate
  use Statistics
  use Basis

  implicit none

!-- namelist variables
  integer :: nz  ! 高度方向の配列
  real :: zmin   ! 内挿する最下端高度 [m] or [hPa]
  real :: dz     ! 格子間隔 (高度座標なら正, 気圧座標なら負)
  real :: undef  ! 未定義値
  character(1) :: axopt  ! 高度座標の種類 'z': 高度座標, 'p': 気圧座標
  character(1000) :: list_name  ! データリストファイル名

  real, allocatable, dimension(:) :: temp    ! 温度
  real, allocatable, dimension(:) :: height  ! 高度
  real, allocatable, dimension(:) :: pres    ! 気圧
  real, allocatable, dimension(:) :: rh      ! 相対湿度
  real, allocatable, dimension(:) :: qv      ! 混合比
  real, allocatable, dimension(:) :: pt      ! 温位
  real, allocatable, dimension(:) :: ept     ! 相当温位
  real, allocatable, dimension(:) :: sept    ! 飽和相当温位
  real, allocatable, dimension(:) :: ew      ! 東西風
  real, allocatable, dimension(:) :: ww      ! 南北風
  real, allocatable, dimension(:) :: tmp     ! テンポラリ配列
  real, allocatable, dimension(:) :: zax     ! 計算用高度
  real, allocatable, dimension(:) :: temp_i  ! 温度
  real, allocatable, dimension(:) :: height_i! 高度
  real, allocatable, dimension(:) :: pres_i  ! 気圧
  real, allocatable, dimension(:) :: rh_i    ! 相対湿度
  real, allocatable, dimension(:) :: qv_i    ! 混合比
  real, allocatable, dimension(:) :: pt_i    ! 温位
  real, allocatable, dimension(:) :: ept_i   ! 相当温位
  real, allocatable, dimension(:) :: sept_i  ! 飽和相当温位
  real, allocatable, dimension(:) :: ew_i    ! 東西風
  real, allocatable, dimension(:) :: ww_i    ! 南北風

  integer :: i, j, k, l, m, n, iz
  integer :: nl  ! データがまともに使える領域における配列数
  integer :: nx  ! データカラムの数

  character(1000), allocatable, dimension(:,:) :: fname  ! データファイル名
  character(1000), allocatable, dimension(:,:) :: cval  ! データ読み込み用
  character(20) :: foma, fomb

  integer, parameter :: skip_num=2

!-- namelist file 読み込み部

  namelist /input /list_name, axopt, zmin, dz, nz, undef
  read(5,nml=input)

  foma='(6a15)'
  fomb='(6E15.6)'

  allocate(zax(nz))
  allocate(temp_i(nz))
  allocate(height_i(nz))
  allocate(pres_i(nz))
  allocate(rh_i(nz))
  allocate(qv_i(nz))
  allocate(pt_i(nz))
  allocate(ew_i(nz))
  allocate(ww_i(nz))

  zax=(/((zmin+dz*real(i-1)),i=1,nz)/)

!-- 読み込むデータファイル数
  nl=line_number_counter( trim(list_name) )

  allocate(fname(2,nl))

  call read_file_text( trim(list_name), 2, nl, fname )
  
  do i=1,nl

!-- テキストファイル読み込み部

     nx=line_number_counter( trim(fname(1,i)) )-skip_num  ! 各タイトルと単位の分差っ引く

!-- 配列割付部

     allocate(cval(6,nx))
     allocate(height(nx))
     allocate(temp(nx))
     allocate(pres(nx))
     allocate(qv(nx))
     allocate(ew(nx))
     allocate(ww(nx))
     allocate(tmp(nx))
     allocate(pt(nx))
!     allocate(ept(nx))
!     allocate(sept(nx))
!     allocate(p_height(nx))
!     allocate(temp_v(nx))

!-- ファイルからデータの読み込み
     call read_file_text( trim(fname(1,i)), 6, nx, cval, skip=skip_num )
     write(*,*) "reading file ", trim(fname(1,i))

!-- character -> real
     do j=1,nx
        height(j)=c2r_convert( cval(1,j) )
        pres(j)=c2r_convert( cval(2,j) )
        temp(j)=c2r_convert( cval(3,j) )
        qv(j)=c2r_convert( cval(4,j) )
        ew(j)=c2r_convert( cval(5,j) )
        ww(j)=c2r_convert( cval(6,j) )
     end do

     height_i=undef
     pres_i=undef
     temp_i=undef
     qv_i=undef
     ew_i=undef
     ww_i=undef

!-- 内挿処理
     select case (axopt(1:1))
     case ('p')  ! 気圧座標
        ! interpo させるための漸増配列化処理
        tmp=undef
        do j=1,nx
           if(pres(nx-j+1)/=undef)then
              tmp(j)=pres(nx-j+1)
           end if
        end do
        do j=1,nz
           if(zax(j)>=tmp(1).and.zax(j)<=tmp(nx))then
              call interpo_search_1d( tmp, zax(j), iz )
              if(height(nx-iz+1)/=undef.and.height(nx-iz)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/height(nx-iz+1),height(nx-iz)/),  &
  &                                     zax(j), height_i(j) )
              end if
              if(temp(nx-iz+1)/=undef.and.temp(nx-iz)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/temp(nx-iz+1),temp(nx-iz)/),  &
  &                                     zax(j), temp_i(j) )
              end if
              if(qv(nx-iz+1)/=undef.and.qv(nx-iz)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/qv(nx-iz+1),qv(nx-iz)/),  &
  &                                     zax(j), qv_i(j) )
              end if
              if(ew(nx-iz+1)/=undef.and.ew(nx-iz)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/ew(nx-iz+1),ew(nx-iz)/),  &
  &                                     zax(j), ew_i(j) )
              end if
              if(ww(nx-iz+1)/=undef.and.ww(nx-iz)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/ww(nx-iz+1),ww(nx-iz)/),  &
  &                                     zax(j), ww_i(j) )
              end if
           end if
        end do
        pres_i=zax

     case ('z')
        tmp=height
        do j=1,nz
           if(zax(j)>=tmp(1).and.zax(j)<=tmp(nx))then
              call interpo_search_1d( tmp, zax(j), iz )
              if(height(iz)/=undef.and.height(iz+1)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/height(iz),height(iz+1)/),  &
  &                                     zax(j), height_i(j) )
              end if
              if(temp(iz)/=undef.and.temp(iz+1)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/temp(iz),temp(iz+1)/),  &
  &                                     zax(j), temp_i(j) )
              end if
              if(qv(iz)/=undef.and.qv(iz+1)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/qv(iz),qv(iz+1)/),  &
  &                                     zax(j), qv_i(j) )
              end if
              if(ew(iz)/=undef.and.ew(iz+1)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/ew(iz),ew(iz+1)/),  &
  &                                     zax(j), ew_i(j) )
              end if
              if(ww(iz)/=undef.and.ww(iz+1)/=undef)then
                 call interpolation_1d( tmp(iz:iz+1), (/ww(iz),ww(iz+1)/),  &
  &                                     zax(j), ww_i(j) )
              end if
           end if
        end do
        height_i=zax
     end select

     open(unit=11+i,file=trim(fname(2,i)),status='unknown')
     write(11+i,trim(foma)) "'height'       ", "'pressure'     ", "'temperature'  ", "'vapor'        ", "'E-Wwind'      ", "'N-Swind'      "
     write(11+i,trim(foma)) "'m'            ", "'Pa'           ", "'K'            ", "'kg/kg'        ", "'m/s'          ", " m/s'          "
     do j=1,nz
        write(11+i,trim(fomb)) height_i(j), pres_i(j), temp_i(j), qv_i(j), ew_i(j), ww_i(j)
     end do
     close(unit=11+i)

     deallocate(cval)
     deallocate(height)
     deallocate(temp)
     deallocate(pres)
     deallocate(qv)
     deallocate(ew)
     deallocate(ww)
     deallocate(tmp)
     deallocate(pt)
!     deallocate(ept)
!     deallocate(sept)
!     deallocate(p_height)
!     deallocate(temp_v)

  end do

end program
