module sub_calc

! ֽ롼
  use Thermo_Function

contains

subroutine dmp_val( r_u, r_s, z_w, z_s,  &
  &                 u_i, v_i, w_i, p_i, pb_s, t_i, qv_i, qc_i, ql_i,  &
  &                 u_dmp, v_dmp, w_dmp, p_dmp, t_dmp, qv_dmp, qc_dmp, ql_dmp )
!-- ͽѿ򥹥顼˺.
  use Thermo_Const
  implicit none
  real, intent(in) :: r_u(:)
  real, intent(in) :: r_s(size(r_u))
  real, intent(in) :: z_w(:)
  real, intent(in) :: z_s(size(z_w))
  real, intent(in) :: u_i(size(r_u),size(z_w))
  real, intent(in) :: v_i(size(r_u),size(z_w))
  real, intent(in) :: w_i(size(r_u),size(z_w))
  real, intent(in) :: p_i(size(r_u),size(z_w))
  real, intent(in) :: pb_s(size(r_u),size(z_w))
  real, intent(in) :: t_i(size(r_u),size(z_w))
  real, intent(in) :: qv_i(size(r_u),size(z_w))
  real, intent(in) :: qc_i(size(r_u),size(z_w))
  real, intent(in) :: ql_i(size(r_u),size(z_w))
  real, intent(inout) :: u_dmp(size(r_u),size(z_w))
  real, intent(inout) :: v_dmp(size(r_u),size(z_w))
  real, intent(inout) :: w_dmp(size(r_u),size(z_w))
  real, intent(inout) :: p_dmp(size(r_u),size(z_w))
  real, intent(inout) :: t_dmp(size(r_u),size(z_w))
  real, intent(inout) :: qv_dmp(size(r_u),size(z_w))
  real, intent(inout) :: qc_dmp(size(r_u),size(z_w))
  real, intent(inout) :: ql_dmp(size(r_u),size(z_w))
  integer :: j, k, nr, nz

  nr=size(r_u)
  nz=size(z_w)

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(k)
  do k=1,nz
     call auto_interpolation_1d( r_u, r_s, u_i(:,k), u_dmp(:,k), stdopt=.true. )
  end do
!$omp end do

!$omp do schedule(dynamic) private(j)
  do j=1,nr
     call auto_interpolation_1d( z_w, z_s, w_i(j,:), w_dmp(j,:), stdopt=.true. )
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,k)
  do k=1,nz
     do j=1,nr
        v_dmp(j,k)=v_i(j,k)
        p_dmp(j,k)=p0*((p_i(j,k)+pb_s(j,k))**(Cpd/Rd))  ! p_dmp -> Pa
        t_dmp(j,k)=t_i(j,k)
        qv_dmp(j,k)=qv_i(j,k)
        qc_dmp(j,k)=qc_i(j,k)
        ql_dmp(j,k)=ql_i(j,k)
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine dmp_val


subroutine dmp_suf( z_s, u_i, v_i, w_i, p_i, t_i, qv_i, qc_i, ql_i, Tsurf,  &
  &                 u_dmp, v_dmp, w_dmp, p_dmp, t_dmp, qv_dmp, qc_dmp, ql_dmp )
!-- ͽѿ򥹥顼˺.
  use Thermo_Const
  implicit none
  real, intent(in) :: z_s
  real, intent(in) :: u_i(:)
  real, intent(in) :: v_i(size(u_i))
  real, intent(in) :: w_i(size(u_i))
  real, intent(in) :: p_i(size(u_i))
  real, intent(in) :: t_i(size(u_i))
  real, intent(in) :: qv_i(size(u_i))
  real, intent(in) :: qc_i(size(u_i))
  real, intent(in) :: ql_i(size(u_i))
  real, intent(in) :: Tsurf(size(u_i))
  real, intent(inout) :: u_dmp(size(u_i))
  real, intent(inout) :: v_dmp(size(u_i))
  real, intent(inout) :: w_dmp(size(u_i))
  real, intent(inout) :: p_dmp(size(u_i))
  real, intent(inout) :: t_dmp(size(u_i))
  real, intent(inout) :: qv_dmp(size(u_i))
  real, intent(inout) :: qc_dmp(size(u_i))
  real, intent(inout) :: ql_dmp(size(u_i))
  integer :: j, k, nr

  nr=size(u_i)

!!$omp parallel default(shared)
!!$omp do schedule(dynamic) private(k)
!  do k=1,nz
!     call auto_interpolation_1d( r_u, r_s, u_i(:,k), u_dmp(:,k), stdopt=.true. )
!  end do
!!$omp end do

!!$omp do schedule(dynamic) private(j)
!  do j=1,nr
!     call auto_interpolation_1d( z_w, z_s, w_i(j,:), w_dmp(j,:), stdopt=.true. )
!  end do
!!$omp end do
!!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(runtime) private(j)
  do j=1,nr
     p_dmp(j)=hypsometric_form( p_i(j), z_s, Tsurf(j), 0.0 )  ! p_i == Pa
     t_dmp(j)=theta_dry( Tsurf(j), p_dmp(j) )
     u_dmp(j)=0.0
     v_dmp(j)=0.0
     w_dmp(j)=0.0
     qv_dmp(j)=TP_2_qvs( Tsurf(j), p_dmp(j) )
     qc_dmp(j)=0.0
     ql_dmp(j)=0.0
  end do
!$omp end do
!$omp end parallel

end subroutine dmp_suf


subroutine bound_set( u_in, u_out, w_bot, w_top )
! ꤹ. Ǥ, u_out ɤ߹. ⤷ʤ.
  implicit none
  real, intent(inout) :: u_in(:)            ! r ¦ʿ® [m/s]
  real, intent(inout) :: u_out(size(u_in))  ! r ¦ʿ® [m/s]
  real, intent(inout) :: w_bot(:)            ! z üľ® [m/s]
  real, intent(inout) :: w_top(size(w_bot))  ! z üľ® [m/s]

  integer :: i, j, nw, nu

  nu=size(u_in)
  nw=size(w_bot)

  do i=1,nw  ! , rigid lid Τ
     w_bot(i)=0.0
     w_top(i)=0.0
  end do

  do i=1,nu  ! , ¦ rigid lid Τ
     u_in(i)=0.0
  end do

end subroutine bound_set


subroutine grad_back_1d( x, u, val )
! 1 Υ顼ѿθۤ򥹥åɳʻҤǷ׻.
!  xv(i) ˤѿ u θۤȤ,
! u  xu ȤɸƤ, ᤿ۤϤȾʻҤ줿 xv Ȥ
! ǵ᤿Ȥ.
! ΤȤ, xv(i) Ǥθۤ,
! (u(i)-u(i-1))/(xu(i)-xu(i-1)) Ƿ׻.
  implicit none
  real, intent(in) :: x(:)  ! u ɸ
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: scalex(size(x))

  nx=size(x)

  do i=2,nx
     val(i)=(u(i)-u(i-1))/(x(i)-x(i-1))
  end do

!-- ǡΤʤξüν ---
  val(1)=0.0

end subroutine grad_back_1d


subroutine grad_for_1d( x, u, val )
! 1 Υ顼ѿθۤ򥹥åɳʻҤǷ׻.
!  xv(i) ˤѿ u θۤȤ,
! u  xu ȤɸƤ, ᤿ۤϤȾʻҤ줿 xv Ȥ
! ǵ᤿Ȥ.
! ΤȤ, xv(i) Ǥθۤ,
! (u(i+1)-u(i))/(xu(i+1)-xu(i)) Ƿ׻.
  implicit none
  real, intent(in) :: x(:)  ! u ɸ
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: scalex(size(x))

  nx=size(x)

  do i=1,nx-1
     val(i)=(u(i+1)-u(i))/(x(i+1)-x(i))
  end do

!-- ǡΤʤξüν ---
  val(nx)=0.0

end subroutine grad_for_1d


real function hydro_calc( z1, t1, p1, z2, t2, p2, z0 )
! ϳʿդꤷȤ, ɽ̤ΰ [Pa]  2 ؤ
! ޷׻.
! ¤, z0 Ĵ᤹Ǥդι٤Ǥͤ׻ǽ.
! ׻ˤ, (p_2+p_0-2p_1)/2dz=-grho_1 ջ.
  use Phys_Const
  implicit none
  real, intent(in) :: z1   !  1 إ顼ιٺɸ
  real, intent(in) :: p1   !  1 إ顼ΰ [Pa]
  real, intent(in) :: t1   !  1 إ顼β [K]
  real, intent(in) :: z2   !  2 إ顼ιٺɸ
  real, intent(in) :: p2   !  2 إ顼ΰ [Pa]
  real, intent(in) :: t2   !  2 إ顼β [K]
  real, intent(in) :: z0   ! ɽ̤ιٺɸ
  real :: rho

  rho=TP_2_rho( t1, p1 )

  hydro_calc=2.0*g*rho*(z2-z0)+p2

  return

end function hydro_calc


subroutine val_check( val, thr )
  real, intent(in) :: val(:,:)
  real, intent(in) :: thr
  integer :: n1, n2, i, j

  n1=size(val,1)
  n2=size(val,2)

  do j=1,n2
     do i=1,n1
        if(val(i,j)<=thr)then
           write(*,*) "detect thres", val(i,j), i, j
        end if
     end do
  end do

end subroutine val_check


real function ext_1d( x1, x2, v1, v2, point )
! x1, x2  2 Ǥ v1, v2 ͤѤ, point Ǥͤޤ.
! x1, x2 а֤ưȽꤹΤ, point  x1, x2 Τɤ¦
! 뤫ϵˤʤƤ褤.
! , x1 < x2 ǤʤФʤʤ.

  implicit none

  real, intent(in) :: x1  !  1 
  real, intent(in) :: x2  !  2 
  real, intent(in) :: v1  !  1 Ǥ
  real, intent(in) :: v2  !  2 Ǥ
  real, intent(in) :: point  ! 
  real :: df, dx

  if(x1>=x2)then
     write(*,*) "*** ERROR (ext_1d) ***"
     write(*,*) "You must set x1 < x2. STOP."
     stop
  end if

  df=v2-v1
  dx=x2-x1

  if(point<x1)then
     ext_1d=v1+(df/dx)*(point-x1)
  else if(point>x2)then
     ext_1d=v2+(df/dx)*(point-x2)
  end if

end function ext_1d


subroutine set_zero( val )
! setting 0 in val.
  implicit none
  real, intent(inout) :: val(:,:)
  integer :: n1, n2, i, j

  n1=size(val,1)
  n2=size(val,2)

  do j=1,n2
     do i=1,n1
        if(val(i,j)<0.0)then
           val(i,j)=0.0
        end if
     end do
  end do

end subroutine set_zero

end module
