!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Thermo_Advanced_Function
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
  use Thermo_Function
  use stdio
  use Thermo_Const
  use Thermo_Routine
  use Math_Const
  use Phys_Const
  use Algebra
  use Statistics

contains

real function Rich( za, pta, ptg, va, qva, qvs, dl )
! Х륯㡼ɥ׻ؿ
  use Phys_Const
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in) :: pta  ! za Ǥβ [K]
  real, intent(in) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  integer, intent(in), optional :: dl  ! ǥХå٥
  real :: ptvg, ptva, dpt

  ptvg=ptg*((1.0+eps_rdrv*qvs)/(1.0+qvs))
  ptva=pta*((1.0+eps_rdrv*qva)/(1.0+qva))
  dpt=ptva-ptvg
  Rich=(g*za*dpt)/(ptva*(va**2))

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'Rich', Rich, '1' )
  end if

  return
end function

!--------------------------------------------------------

real function Louis( z, z0m, richard, dl )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Const
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in) :: richard  ! Х륯㡼ɥ
  integer, intent(in), optional :: dl  ! ǥХå٥
  real, parameter :: b=5.0, c=5.0
  real :: cm_tmp, zratio

  cm_tmp=(kalm/(log(z)-log(z0m)))**2
  zratio=z/z0m

  if(richard<0.0)then
     Louis=1.0-((2.0*b*richard)/(1.0+3.0*b*c*cm_tmp*sqrt(-richard*zratio)))
  else
     Louis=1.0/(1.0+2.0*b*richard*sqrt(1.0+c*richard))
  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'Louis', Louis, '1' )
  end if

  return
end function

!--------------------------------------------------------

real function cm( z, z0m, richard, dl )
! ư̤˴ؤХ륯׻ؿ
  use Thermo_Const
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ
  integer, intent(in), optional :: dl  ! ǥХå٥

  if(present(richard))then
     cm=(kalm/(log(z)-log(z0m)))**2
     cm=cm*Louis( z, z0m, richard )
  else
     cm=(kalm/(log(z)-log(z0m)))**2
  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'cm', cm, '1' )
  end if

  return
end function

!--------------------------------------------------------
!--------------------------------------------------------

real function cmdva_2_ust( cmd, va, dl )
! Х륯, ®٤໤® u_* ׻ؿ
  implicit none
  real, intent(in) :: cmd  !  za ǤΥХ륯
  real, intent(in) :: va  !  za Ǥοʿ [m/s]
  integer, intent(in), optional :: dl  ! ǥХå٥

  cmdva_2_ust=va*sqrt(cmd)

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'cmdva_2_ust', cmdva_2_ust, 'm s-1' )
  end if

end function

!--------------------------------------------------------
!--------------------------------------------------------

real function taurho_2_ust( tau, rho, dl )
! ϤΥǥȿʿ 2 ʬȤι٤Ǥ̩٤໤® u_* ׻ؿ
  implicit none
  real, intent(in) :: tau(2)  ! ٤ǤϤΥǥȿʿ 2 ʬ [N/m]
  real, intent(in) :: rho  ! ٤Ǥ̩ [kg/m^3]
  integer, intent(in), optional :: dl  ! ǥХå٥
  real :: taua

  taua=sqrt(tau(1)**2+tau(2)**2)
  taurho_2_ust=sqrt(taua/rho)

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'taurho_2_ust', taurho_2_ust, 'm s-1' )
  end if

end function

!--------------------------------------------------------
!--------------------------------------------------------

real function precip_water( p, qv, undef, dl )  ! Ĺ߿̤׻. ñ̤ [kg/m^2]
! ʬϰϤ p ǿξ岼üǼưŪ˻.
! ݤ狼ȼ, ٺɸʬΤǤϤʤ,
! ϳʿդ鵤ɸ֤ľʬ.
  use Phys_Const
  implicit none
  real, intent(in) :: p(:)  !  [Pa]
  real, intent(in) :: qv(size(p))  !  [kg/kg]
  real, intent(in), optional :: undef  ! undef
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: nx, i, ibot, itop
  real, dimension(size(p)) :: tmp_p, tmp_qv
  real :: precip

  nx=size(p)

!-- ʬΤ, ؤ
  do i=1,nx
     tmp_qv(i)=qv(nx-i+1)
     tmp_p(i)=p(nx-i+1)
  end do

  if(present(undef))then
     ibot=1
     itop=nx
     do i=1,nx
        if(tmp_p(i)/=undef)then
           ibot=i
           exit
        end if
     end do
     do i=nx,1,-1
        if(tmp_p(i)/=undef)then
           itop=i
           exit
        end if
     end do
     call rectangle_int( tmp_p(ibot:itop), tmp_qv(ibot:itop),  &
  &                      tmp_p(ibot), tmp_p(itop),  &
  &                      precip, undef )
  else
     call rectangle_int( tmp_p, tmp_qv, tmp_p(1), tmp_p(nx), precip )
  end if

  precip_water=precip/g

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'precip_water', precip_water, 'mm' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function SSIndex( tmp_p, tmp_z, tmp_qv, tmp_t, p_ref, p_com, undeff, dl )
! Showalter stability index ׻.
! 850 hPa ̹٤Υѡ 500 hPa ޤǻ夲Ȥβ (T500p) 
! 500 hPa ǤμϤβ (T500) κ (T500-T500p)
  use Thermo_Const
  implicit none
  real, intent(in) :: tmp_p(:)  !  [Pa]
  real, intent(in) :: tmp_z(size(tmp_p))  !  [m]
  real, intent(in) :: tmp_qv(size(tmp_p))  !  [kg/kg]
  real, intent(in) :: tmp_t(size(tmp_p))  !  [K]
  real, intent(in), optional :: undeff
  real, intent(in), optional :: p_ref    ! ѡ夲 [Pa]
                                         ! ǥեȤ 850 hPa
  real, intent(in), optional :: p_com    ! ٺ׻ [Pa]
                                         ! ǥեȤ 500 hPa
  integer, intent(in), optional :: dl    ! ǥХå٥
  integer :: nx, i, iz_LCL, iz_tmp, iundef
  real :: PLCL, TLCL
  real :: t_par, t_com, t_ref, qv_ref
  real :: inv_tmp(size(tmp_p)), inv_p(size(tmp_p)), inv_qv(size(tmp_p))
  real :: undef, p_reference, p_compare

  t_par=0.0
  iundef=0

  nx=size(tmp_p)

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

  if(present(p_ref))then
     p_reference=p_ref
  else
     p_reference=850.0e2
  end if

  if(present(p_com))then
     p_compare=p_com
  else
     p_compare=500.0e2
  end if

!-- interpo_search Τ, Ϥ岼ȿž
  do i=1,nx
     inv_tmp(i)=tmp_t(nx-i+1)
     inv_qv(i)=tmp_qv(nx-i+1)
     inv_p(i)=tmp_p(nx-i+1)
  end do

!-- p_reference, p_compare Ǥβ٤򸡺
  call interpo_search_1d( inv_p, p_reference, iz_tmp )
  if(iz_tmp>0.and.iz_tmp<nx)then
     call interpolation_1d( inv_p(iz_tmp:iz_tmp+1), inv_tmp(iz_tmp:iz_tmp+1),  &
  &                         p_reference, t_ref )
     call interpolation_1d( inv_p(iz_tmp:iz_tmp+1), inv_qv(iz_tmp:iz_tmp+1),  &
  &                         p_reference, qv_ref )

     call interpo_search_1d( inv_p, p_compare, iz_tmp )
     call interpolation_1d( inv_p(iz_tmp:iz_tmp+1), inv_tmp(iz_tmp:iz_tmp+1),  &
  &                         p_compare, t_com )

     TLCL=TqvP_2_TLCL( t_ref, qv_ref, p_reference )
     PLCL=p_LCL( p_reference, tmp_t, tmp_p, tmp_qv, undef )

     if(PLCL/=undef)then

        t_par=moist_laps_temp( PLCL, TLCL, p_compare )
        SSIndex=t_com-t_par

     else

        SSIndex=undef

     end if

  else

     SSIndex=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'SSIndex', SSIndex, 'K' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function CAPE( tmp_p, tmp_z, tmp_qv, tmp_t, z_ref, undeff, opt, copt, dl )
! ή֥ͭͥ륮 (Convective Available Potential Energy) ׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: tmp_p(:)  !  [Pa]
  real, intent(in) :: tmp_z(size(tmp_p))  !  [m]
  real, intent(in) :: tmp_qv(size(tmp_p))  !  [kg/kg]
  real, intent(in) :: tmp_t(size(tmp_p))  !  [K]
  real, intent(in) :: z_ref  ! ѡ夲 [m]
  real, intent(in), optional :: undeff
  integer, intent(in), optional :: opt   ! LNB ׻κݤΥץ (z_LNB )
  integer, intent(in), optional :: copt  ! LFC ͤ, LNB ͤΤʤ,
                                         ! CAPE ̤ͤˤ뤫ɤ.
                                         ! ǥե: 1 = ̤ˤ.
                                         ! 2 = LFC üޤѻ֤ͤ.
                                         ! , ǡξü LNB ʲ
                                         ! ǡ.
  integer, intent(in), optional :: dl    ! ǥХå٥
  integer :: nx, i, iz_LFC, iz_LNB, option, calc_opt, iundef
  real :: PLFC, TLFC, PLNB, ZLFC, ZLNB
  real :: tmp(size(tmp_p)), t_par(size(tmp_p))
  real :: inv_tmp(size(tmp_p)), inv_p(size(tmp_p))
  real :: undef

  t_par=0.0
  iundef=0

  nx=size(tmp_p)

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

  if(present(opt))then
     option=opt
  else
     option=1
  end if

  if(present(copt))then
     calc_opt=copt
  else
     calc_opt=1
  end if

!-- LFC, LNB Ǥι, , Ϥη׻

  TLFC=T_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  ZLFC=z_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv, undeff=undef )
  ZLNB=z_LNB( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv, opt=option, undeff=undef )

  if(ZLFC/=undef.and.ZLNB/=undef)then
     call interpo_search_1d( tmp_z, ZLFC, iz_LFC, iundef )
     call interpo_search_1d( tmp_z, ZLNB, iz_LNB, iundef )
     if(iz_LFC>=nx)then
        iz_LFC=iundef
     end if
     if(iz_LNB>=nx)then
        iz_LNB=iundef
     end if
  else
     if(ZLFC/=undef.and.calc_opt==2)then
        call interpo_search_1d( tmp_z, ZLFC, iz_LFC, iundef )
        if(iz_LFC>=nx)then
           iz_LFC=iundef
        end if
        iz_LNB=nx
     else
        iz_LFC=iundef
        iz_LNB=iundef
     end if
  end if

  if(iz_LFC/=iundef.and.iz_LNB/=iundef)then

     if(tmp_t(iz_LFC)/=undef.and.tmp_qv(iz_LFC)/=undef.and.  &
  &     tmp_p(iz_LFC)/=undef.and.tmp_t(iz_LFC+1)/=undef.and.  &
  &     tmp_qv(iz_LFC+1)/=undef.and.tmp_p(iz_LFC+1)/=undef.and.  &
  &     tmp_t(iz_LNB)/=undef.and.tmp_qv(iz_LNB)/=undef.and.  &
  &     tmp_p(iz_LNB)/=undef.and.tmp_t(iz_LNB+1)/=undef.and.  &
  &     tmp_qv(iz_LNB+1)/=undef.and.tmp_p(iz_LNB+1)/=undef)then

        call interpolation_1d( (/tmp_z(iz_LFC), tmp_z(iz_LFC+1)/),  &
  &          (/tmp_p(iz_LFC), tmp_p(iz_LFC+1)/), ZLFC, PLFC )
        call interpolation_1d( (/tmp_z(iz_LNB), tmp_z(iz_LNB+1)/),  &
  &          (/tmp_p(iz_LNB), tmp_p(iz_LNB+1)/), ZLNB, PLNB )

        tmp=undef
        do i=iz_LFC+1,iz_LNB+1
           if(undef/=tmp_t(i))then
              t_par(i)=moist_laps_temp( PLFC, TLFC, tmp_p(i) )
              tmp(i)=(t_par(i)-tmp_t(i))/tmp_p(i)
           end if
        end do

        if(PLFC==tmp_p(iz_LFC))then
           tmp(iz_LFC)=0.0
        end if

!-- ʬΤ, ؤ
        do i=1,nx
           inv_tmp(i)=tmp(nx-i+1)
           inv_p(i)=tmp_p(nx-i+1)
        end do

        call rectangle_int( inv_p, inv_tmp, PLNB, PLFC, CAPE, undef )

        CAPE=CAPE*Rd

     else

        CAPE=undef

     end if

  else

     CAPE=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'CAPE', CAPE, 'J kg-1' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------
! ʲ, ߺ.

!!real function DCAPE( tmp_p, tmp_z, tmp_qv, tmp_t, z_ref, undeff, dl )
! ή֥ͭͥ륮 (Downdraft Convective Available Potential Energy) ׻.
! ѡϴǮΨǸȲꤹ.
!!  use Thermo_Const
!!  use Thermo_Function
!!  use Algebra
!!  use Statistics
!!  implicit none
!!  real, intent(in) :: tmp_p(:)  !  [Pa]
!!  real, intent(in) :: tmp_z(size(tmp_p))  !  [m]
!!  real, intent(in) :: tmp_qv(size(tmp_p))  !  [kg/kg]
!!  real, intent(in) :: tmp_t(size(tmp_p))  !  [K]
!!  real, intent(in) :: z_ref  ! ѡ򲼤 [m]
!!  integer, intent(in), optional :: opt  ! DCAPE η׻ˡ
!!                      ! 1 = ߤȤǽ˥ѡ
!!                      !     Ķβ٤פޤǷ׻ (ǥե).
!!                      ! 2 = ǡüޤǥͥ륮ȤʤΰΤ߷׻.
!!  real, intent(in), optional :: undeff
!!  integer, intent(in), optional :: dl  ! ǥХå٥
!!  integer :: nx, i, iz_LFC, iz_LNB, option
!!  real :: PLFC, TLFC, PLNB, ZLFC, ZLNB
!!  real :: tmp(size(tmp_p)), t_par(size(tmp_p))
!!  real :: inv_tmp(size(tmp_p)), inv_p(size(tmp_p))
!!  real :: undef
!!
!!  t_par=0.0
!!
!!  nx=size(tmp_p)
!!
!!  if(present(undeff))then
!!     undef=undeff
!!  else
!!     undef=-999.0
!!  end if
!!
!!  if(present(opt))then
!!     option=opt
!!  else
!!     option=1
!!  end if
!!
!!  do i=1,nx
!!        if(undef==tmp_t(i))then
!!           tmp(i)=undef
!!        else
!!           t_par(i)=gamma_d()*()
!!           t_par(i)=moist_laps_temp( PLFC, TLFC, tmp_p(i) )
!!           tmp(i)=(t_par(i)-tmp_t(i))/tmp_p(i)
!!        end if
!!     else
!!        tmp(i)=undef
!!     end if
!!  end do
!!
!!!-- ʬΤ, ؤ
!!     do i=1,nx
!!        inv_tmp(i)=tmp(nx-i+1)
!!        inv_p(i)=tmp_p(nx-i+1)
!!     end do
!!
!!     call rectangle_int( inv_p, inv_tmp, PLNB, PLFC, CAPE, undef )
!!
!!     DCAPE=DCAPE*Rd
!!
!!  else
!!
!!     DCAPE=undef
!!
!!  end if
!!
!!  else
!!
!!     DCAPE=undef
!!
!!  end if
!!
!!  if(present(dl))then
!!     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'DCAPE', DCAPE, 'J kg-1' )
!!  end if
!!
!!  return
!!end function

!-----------------------------------------------------
!-----------------------------------------------------

real function CIN( tmp_p, tmp_z, tmp_qv, tmp_t, z_ref, undeff, dl )
! ήͥ륮 (Convective INhibitation energy) ׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: tmp_p(:)  !  [Pa]
  real, intent(in) :: tmp_z(size(tmp_p))  !  [m]
  real, intent(in) :: tmp_qv(size(tmp_p))  !  [kg/kg]
  real, intent(in) :: tmp_t(size(tmp_p))  !  [K]
  real, intent(in) :: z_ref  ! ѡ夲 [m]
  real, intent(in), optional :: undeff
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: nx, i, iz_LFC, iz_ref, iz_LCL, iundef
  real :: PLFC, TLFC, ZLFC, PLCL, ZLCL, TLCL, p_ref, T_ref, qv_ref
  real :: tmp(size(tmp_p)), t_par(size(tmp_p))
  real :: inv_tmp(size(tmp_p)), inv_p(size(tmp_p))
  real :: undef

  t_par=0.0
  iundef=0

  nx=size(tmp_p)

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

!-- z_ref Ȥ, LCL, LFC Ǥβ, , Ϥη׻

!-- LFC ٤ѿ׻
  TLFC=T_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  ZLFC=z_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )

  call interpo_search_1d( tmp_z, ZLFC, iz_LFC, iundef )
  call interpo_search_1d( tmp_z, z_ref, iz_ref, iundef )

  if(iz_LFC>=nx)then
     iz_LFC=iundef
  end if
  if(iz_ref>=nx)then
     iz_ref=iundef
  end if

  if(iz_LFC/=iundef.and.iz_ref/=iundef)then
  if(tmp_t(iz_LFC)/=undef.and.tmp_qv(iz_LFC)/=undef.and.tmp_p(iz_LFC)/=undef  &
  &  .and.tmp_t(iz_LFC+1)/=undef.and.tmp_qv(iz_LFC+1)/=undef.and.tmp_p(iz_LFC+1)/=undef  &
  &  .and.tmp_t(iz_ref)/=undef.and.tmp_qv(iz_ref)/=undef.and.tmp_p(iz_ref)/=undef  &
  &  .and.tmp_t(iz_ref+1)/=undef.and.tmp_qv(iz_ref+1)/=undef.and.tmp_p(iz_ref+1)/=undef)then

     call interpolation_1d( (/tmp_z(iz_LFC), tmp_z(iz_LFC+1)/),  &
     &    (/tmp_p(iz_LFC), tmp_p(iz_LFC+1)/), ZLFC, PLFC )
!-- reference ٤ѿ׻
     call interpolation_1d( (/tmp_z(iz_ref), tmp_z(iz_ref+1)/),  &
     &    (/tmp_p(iz_ref), tmp_p(iz_ref+1)/), z_ref, p_ref )
     call interpolation_1d( (/tmp_z(iz_ref), tmp_z(iz_ref+1)/),  &
     &    (/tmp_t(iz_ref), tmp_t(iz_ref+1)/), z_ref, T_ref )
     call interpolation_1d( (/tmp_z(iz_ref), tmp_z(iz_ref+1)/),  &
     &    (/tmp_qv(iz_ref), tmp_qv(iz_ref+1)/), z_ref, qv_ref )
!-- LCL ٤ѿ׻
     TLCL=TqvP_2_TLCL( t_ref, qv_ref, p_ref )
     ZLCL=z_LCL( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )

     call interpo_search_1d( tmp_z, ZLCL, iz_LCL, iundef )

     if(iz_LCL>=nx)then
        iz_LCL=iundef
     end if

     if(iz_LCL/=iundef)then
     if(tmp_t(iz_LCL)/=undef.and.tmp_qv(iz_LCL)/=undef.and.tmp_p(iz_LCL)/=undef  &
  &  .and.tmp_t(iz_LCL+1)/=undef.and.tmp_qv(iz_LCL+1)/=undef.and.tmp_p(iz_LCL+1)/=undef)then

        call interpolation_1d( (/tmp_z(iz_LCL), tmp_z(iz_LCL+1)/),  &
        &    (/tmp_p(iz_LCL), tmp_p(iz_LCL+1)/), ZLCL, PLCL )

! Ϥβ٤ T ƤΤ, ޤ LCL ׻, ι
! ޤǤǮ, ʹߤ򼾽Ǯǥѡ벹٤׻.

        do i=1,nx
           if(i>=iz_ref.and.i<=iz_LCL+1)then
              t_par(i)=T_ref-(g/Cpd)*(tmp_z(i)-z_ref)
           else
              if(i>iz_LCL+1.and.i<=iz_LFC+1)then
                 t_par(i)=moist_laps_temp( PLCL, TLCL, tmp_p(i) )
              else
                 t_par(i)=undef
              end if
           end if

           if(undef==tmp_t(i).or.t_par(i)==undef)then
              tmp(i)=undef
           else
              tmp(i)=(t_par(i)-tmp_t(i))/tmp_p(i)
           end if
        end do

!do i=1,nx
!   if(tmp_p(i)<p_ref.and.tmp_p(i)>PLFC)then
!      t_par(i)=t_bot-(g/CPD)*(height(i+1)-height(i))
!      if(PLCL>PLFC)then   ! žؤΤ
!         if(p(i)<=PLCL.and.p(i)>=PLFC)then
!            call moist_laps_calc( PLCL, TLCL, p(i), t_par(i) )
!         end if
!      end if
!   end if
!end do

!-- ʬΤ, ؤ
        do i=1,nx
           inv_tmp(i)=tmp(nx-i+1)
           inv_p(i)=tmp_p(nx-i+1)
        end do

        call rectangle_int( inv_p, inv_tmp, PLFC, p_ref, CIN, undef )

        CIN=CIN*Rd

     else

        CIN=undef

     end if

     else

        CIN=undef

     end if

  else

     CIN=undef

  end if

  else

     CIN=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'CIN', CIN, 'J kg-1' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function p_LCL( p_ref, temp, pres, qv, undeff, dl )  ! LCL ٤׻.
! ѡ뤬 p_ref ǮǾ徺, β٤ãȤι٤
! LCL ٤ȤʤΤ, p_ref 鴥ǮΨǰʲΤ褦˷׻.
! LCL ٤ p_LCL Ȥ, ѡδ٤ p_ref Ȥ,
! LCL ãޤǤϴǮΨ \Gamma _d ѲΤ,
! ̤¸
! $p_LCL=p_ref*(T_LCL/T_ref)**(Cpd/Rd)$
! ȤΩ. 
  use Thermo_Const
  use Phys_Const
  implicit none
  real, intent(in) :: p_ref  !  [Pa]
  real, intent(in) :: temp(:)  !  [K]
  real, intent(in) :: pres(size(temp))  !  [Pa]
  real, intent(in) :: qv(size(temp))  !  [kg/kg]
  real ,intent(in), optional :: undeff
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: i, ip_ref, iundef, nx
  real, dimension(size(temp)) :: inv_p, inv_tmp, inv_qv
  real :: TLCL, T_ref, qv_ref
  real :: undef

  iundef=0

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

  nx=size(temp)

!-- interpo_search Τ, Ϥ岼ȿž
  do i=1,nx
     inv_tmp(i)=temp(nx-i+1)
     inv_qv(i)=qv(nx-i+1)
     inv_p(i)=pres(nx-i+1)
  end do

  call interpo_search_1d( inv_p, p_ref, ip_ref )

  if(ip_ref>=size(temp).or.ip_ref==0)then
     ip_ref=iundef
     p_LCL=undef
     return
  end if

  if(ip_ref/=iundef)then
  if(inv_tmp(ip_ref)/=undef.and.inv_qv(ip_ref)/=undef.and.inv_p(ip_ref)/=undef  &
  &  .and.inv_tmp(ip_ref+1)/=undef.and.inv_qv(ip_ref+1)/=undef.and.inv_p(ip_ref+1)/=undef)then
     call interpolation_1d( inv_p(ip_ref:ip_ref+1),  &
     &    inv_tmp(ip_ref:ip_ref+1), p_ref, T_ref )
     call interpolation_1d( inv_p(ip_ref:ip_ref+1),  &
     &    inv_qv(ip_ref:ip_ref+1), p_ref, qv_ref )

     TLCL=TqvP_2_TLCL( T_ref, qv_ref, P_ref )  ! z_ref Υѡ LCL Ǥβ.
     p_LCL=p_ref*(TLCL/T_ref)**(Cpd/Rd)

  else

     p_LCL=undef

  end if

  else

     p_LCL=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'p_LCL', p_LCL, 'Pa' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function z_LCL( z_ref, z, temp, pres, qv, undeff, dl )  ! LCL ٤׻.
! ѡ뤬 z_ref ǮǾ徺, β٤ãȤι٤
! LCL ٤ȤʤΤ, z_ref 鴥ǮΨǰʲΤ褦˷׻.
! LCL ٤ z_LCL Ȥ, ѡδ٤ z_ref Ȥ,
! LCL ãޤǤϴǮΨ \Gamma _d ѲΤ,
! $\Gamma _d=\frac{g}{C_p} =-\frac{T_LCL-T_ref}{z_LCL-z_ref} $
! ȤΩ. , z_LCL ˤĤƲ򤯤,
! $z_LCL=z_ref+\frac{C_p}{g} (T_ref-T_LCL)$
! Ȥʤ.
  use Thermo_Const
  use Phys_Const
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  real ,intent(in), optional :: undeff
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: iz_ref, iundef
  real :: TLCL
  real :: T_ref, P_ref, qv_ref
  real :: undef

  iundef=0

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

  call interpo_search_1d( z, z_ref, iz_ref, iundef )

  if(iz_ref>=size(z))then
     iz_ref=iundef
  end if

  if(iz_ref/=iundef)then
  if(temp(iz_ref)/=undef.and.qv(iz_ref)/=undef.and.pres(iz_ref)/=undef  &
  &  .and.temp(iz_ref+1)/=undef.and.qv(iz_ref+1)/=undef.and.pres(iz_ref+1)/=undef)then
     call interpolation_1d( (/z(iz_ref), z(iz_ref+1)/),  &
     &    (/temp(iz_ref), temp(iz_ref+1)/), z_ref, T_ref )
     call interpolation_1d( (/z(iz_ref), z(iz_ref+1)/),  &
     &    (/pres(iz_ref), pres(iz_ref+1)/), z_ref, P_ref )
     call interpolation_1d( (/z(iz_ref), z(iz_ref+1)/),  &
     &    (/qv(iz_ref), qv(iz_ref+1)/), z_ref, qv_ref )

     TLCL=TqvP_2_TLCL( T_ref, qv_ref, P_ref )  ! z_ref Υѡ LCL Ǥβ.
     z_LCL=z_ref+(Cpd/g)*(T_ref-TLCL)

  else

     z_LCL=undef

  end if

  else

     z_LCL=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'z_LCL', z_LCL, 'm' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function z_LFC( z_ref, z, temp, pres, qv, undeff, dl )  ! LFC ٤׻.
! ٤Ǥ̤徺Ȥ, Ϥ˰̤Ȱפ٤
! LFC Ǥ. 
! Ǥ, Ϥ˰̤ȸ򺹤 2 , 
! ޤ뤳Ȥǹ٤ꤹ.
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  real, intent(in), optional :: undeff
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: i, nz, iz, iept, iundef
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol
  real :: undef

  nz=size(z)
  iept=0
  iundef=0

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz, iundef )

  if(iz>=nz)then
     iz=iundef
  end if

  if(iz/=iundef)then
  if(temp(iz)/=undef.and.qv(iz)/=undef.and.pres(iz)/=undef  &
  &  .and.temp(iz+1)/=undef.and.qv(iz+1)/=undef.and.pres(iz+1)/=undef)then
!-- iz  iz+1 Ǥ̤׻.
     eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
     eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
     call interpolation_1d( (/z(iz), z(iz+1)/), (/eptiz, eptiz1/), z_ref, ept_ref )
!-- z_ref ι٤ ept_ref ˰̤δط׻.
     do i=iz+1,nz-1
        if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
           iept=i
           exit
        end if
     end do
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
     if(iept>0.and.iept<nz)then
        call interpolation_1d( (/sept(iept), sept(iept+1)/),  &
  &                            (/z(iept), z(iept+1)/), ept_ref, z_sol )

        z_LFC=z_sol
     else
        z_LFC=undef
     end if

  else

     z_LFC=undef

  end if

  else

     z_LFC=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'z_LFC', z_LFC, 'm' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function z_LNB( z_ref, z, temp, pres, qv, opt, undeff, dl )  ! LNB ٤׻.
! LFC ٰʾǺƤӴĶ˰̤ȸ٤ LNB Ǥ.
! , ºݤ¬ǡǤ, ¬ưˤ, LFC ľ LNB 
! ã礬.
! , opt Ȥ, LFC Ƥ LNB ׻ˡ
! 鲼˲ƺǽ˸򺹤٤ LNB ˡ
! 2 ѥѰդ뤳Ȥˤ.
! opt = 1, LFC . opt = 2 ľ夫׻.
! ǥեȤǤ opt = 1 ׻.
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  integer, intent(in), optional :: opt  ! ׻ˡΥץ
  real, intent(in), optional :: undeff
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: i, nz, iz, iept, counter, iundef
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol
  real :: undef

  nz=size(z)
  iept=0
  iundef=0

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz, iundef )

  if(iz>=nz)then
     iz=iundef
  end if

  if(iz/=iundef)then
  if(temp(iz)/=undef.and.qv(iz)/=undef.and.pres(iz)/=undef  &
  &  .and.temp(iz+1)/=undef.and.qv(iz+1)/=undef.and.pres(iz+1)/=undef)then
!-- iz  iz+1 Ǥ̤׻.
     eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
     eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
     call interpolation_1d( (/z(iz), z(iz+1)/), (/eptiz, eptiz1/), z_ref, ept_ref )

     counter=0

     if(present(opt))then
        if(opt==2)then
           do i=nz,iz+1,-1  ! 夫鲼˲.
              if((sept(i)-ept_ref)*(sept(i-1)-ept_ref)<0.0)then
                 iept=i-1  ! 夫鲼˲ƤΤ, 1 ǲΥǡ iept.
                 exit
              end if
           end do
        else
!-- z_ref ι٤ ept_ref ˰̤δط׻.
           do i=iz+1,nz-1
              if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
                 counter=counter+1
                 if(counter==2)then
                    iept=i
                    exit
                 end if
              end if
           end do
        end if
     else
        do i=iz+1,nz-1
           if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
              counter=counter+1
              if(counter==2)then
                 iept=i
                 exit
              end if
           end if
        end do
     end if
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
     if(iept>0.and.iept<nz)then
        call interpolation_1d( (/sept(iept), sept(iept+1)/),  &
  &                            (/z(iept), z(iept+1)/), ept_ref, z_sol )

        z_LNB=z_sol
     else
        z_LNB=undef
     end if

  else

     z_LNB=undef

  end if

  else

     z_LNB=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'z_LNB', z_LNB, 'm' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function T_LFC( z_ref, z, temp, pres, qv, undeff, dl )  ! LFC ٤Ǥβ٤׻.
! ٤Ǥ̤徺Ȥ, Ϥ˰̤Ȱפ٤
! LFC Ǥ. 
! Ǥ, Ϥ˰̤ȸ򺹤 2 , 
! ޤ뤳Ȥǹ٤ꤹ.
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  real, intent(in), optional :: undeff
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: i, nz, iz, iept, iundef
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol
  real :: undef

  nz=size(z)
  iept=0
  iundef=0

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz, iundef )
  if(iz>=nz)then
     iz=iundef
  end if

!-- iz  iz+1 Ǥ̤׻.
  if(iz/=iundef)then
  if(temp(iz)/=undef.and.qv(iz)/=undef.and.pres(iz)/=undef  &
  &  .and.temp(iz+1)/=undef.and.qv(iz+1)/=undef.and.pres(iz+1)/=undef)then
     eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
     eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
     call interpolation_1d( (/z(iz), z(iz+1)/), (/eptiz, eptiz1/), z_ref, ept_ref )
!-- z_ref ι٤ ept_ref ˰̤δط׻.
     do i=iz+1,nz-1
        if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
           iept=i
           exit
        end if
     end do
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
     if(iept>0.and.iept<nz)then
        call interpolation_1d( (/sept(iept), sept(iept+1)/),  &
     &                         (/temp(iept), temp(iept+1)/), ept_ref, z_sol )

        T_LFC=z_sol
     else
        T_LFC=undef
     end if

  else

     T_LFC=undef

  end if

  else

     T_LFC=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'T_LFC', T_LFC, 'K' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function T_LNB( z_ref, z, temp, pres, qv, opt, undeff, dl )  ! LNB ٤Ǥβ٤׻.
! LFC ٰʾǺƤӴĶ˰̤ȸ٤ LNB Ǥ.
! , ºݤ¬ǡǤ, ¬ưˤ, LFC ľ LNB 
! ã礬.
! , opt Ȥ, LFC Ƥ LNB ׻ˡ
! 鲼˲ƺǽ˸򺹤٤ LNB ˡ
! 2 ѥѰդ뤳Ȥˤ.
! opt = 1, LFC . opt = 2 ľ夫׻.
! ǥեȤǤ opt = 1 ׻.
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  integer, intent(in), optional :: opt  ! ׻ˡΥץ
  real, intent(in), optional :: undeff
  integer, intent(in), optional :: dl  ! ǥХå٥
  integer :: i, nz, iz, iept, counter, iundef
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol
  real :: undef

  nz=size(z)
  iept=0
  iundef=0

  if(present(undeff))then
     undef=undeff
  else
     undef=-999.0
  end if

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz, iundef )
  if(iz>=nz)then
     iz=iundef
  end if

!-- iz  iz+1 Ǥ̤׻.
  if(iz/=iundef)then
  if(temp(iz)/=undef.and.qv(iz)/=undef.and.pres(iz)/=undef  &
  &  .and.temp(iz+1)/=undef.and.qv(iz+1)/=undef.and.pres(iz+1)/=undef)then
     eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
     eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
     call interpolation_1d( (/z(iz), z(iz+1)/), (/eptiz, eptiz1/), z_ref, ept_ref )

     counter=0

     if(present(opt))then
        if(opt==2)then
           do i=nz,iz+1,-1  ! 夫鲼˲.
              if((sept(i)-ept_ref)*(sept(i-1)-ept_ref)<0.0)then
                 iept=i-1  ! 夫鲼˲ƤΤ, 1 ǲΥǡ iept.
                 exit
              end if
           end do
        else
!-- z_ref ι٤ ept_ref ˰̤δط׻.
           do i=iz+1,nz-1
              if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
                 counter=counter+1
                 if(counter==2)then
                    iept=i
                    exit
                 end if
              end if
           end do
        end if
     else
        do i=iz+1,nz-1
           if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
              counter=counter+1
              if(counter==2)then
                 iept=i
                 exit
              end if
           end if
        end do
     end if
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
     if(iept>0.and.iept<nz)then
        call interpolation_1d( (/sept(iept), sept(iept+1)/),  &
     &                         (/temp(iept), temp(iept+1)/), ept_ref, z_sol )

        T_LNB=z_sol
     else
        T_LNB=undef
     end if

  else

     T_LNB=undef

  end if

  else

     T_LNB=undef

  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'T_LNB', T_LNB, 'K' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function qrsg_2_dbz( rho, qr, qs, qg, ns, ng, dl )
! 庮椫鵼Ūʥ졼ȿͶ٤Ѵؿ.
! 졼ȿͶ dbz ϥ졼ȿͰ Z Ѥ,
! $$ dbz = 10 \log{Z} $$
! . , ȿͰ Z 
! $$Z=\sum_{D^6} =int^{\infty}_{0}{N(D)D^6dD} $$
! Ȥ. , D Ͽʪľ, N Ͽ̩٤Ǥ.
! Ǥϵݥ졼ꤷƤΤ, ߿γҤΥƥ
! , ,  ΤߤȤ.
! warm rain ξǤ, Ǥκ򥼥ǰ뤳ȤǷ׻ǽ.
! γʬۤϻؿؿʬۤꤷƷ׻. ξ, ƥƥγҤγʬۤ
! γҤľ¤ D_x Ȥ, 
! $$n_x(D_x)=n_{x0}\exp{(-\lambda _xD_x)} $$
! Ȥɽ. , $\lambda _x$γʬۤηǤ.
! ѴȤƤ, Murakami (1990)  (54) ѤƷ׻Ԥ.
! ޤ, ǻ٤ꤵ, 2 ⡼ȥХ륯ˡꤷƷ׻Ԥ.
  use Math_Const
  use Cloud_Const
  implicit none
  real, intent(in) :: rho  ! 絤̩ [kg/m^3]
  real, intent(in) :: qr  ! κ [kg/kg]
  real, intent(in), optional :: qs  ! κ [kg/kg]
  real, intent(in), optional :: qg  ! Ǥκ [kg/kg]
  real, intent(in), optional :: ns  ! οǻ [1/m3]
  real, intent(in), optional :: ng  ! Ǥοǻ [1/m3]
  integer, intent(in), optional :: dl  ! ǥХå٥
  double precision :: coef
  double precision :: z_tmp

  z_tmp=0.0d0
  coef=0.197d0/0.93d0
!  coef=kaijo(6.0)*(((epi-1.0)/(epi+2.0))/((epw-1.0)/(epw+2.0))**2)

  if(present(qs))then
     if(present(ns))then   ! For 2-moment
        if(dble(ns)>0.0d0.and.dble(qs)>0.0d0)then
           z_tmp=z_tmp  &
!  &             +coef*((rho*qs/(pi*rhow))**2)/ns  !*1.0e18
  &             +coef*((dble(rho)/pi_dp)**2)  &
  &                  *dexp(2.0d0*(dlog(dble(qs))-dlog(dble(rhow)))-dlog(dble(ns)))
        end if
     else   ! For 1-moment
        if(dble(qs)>0.0d0)then
           z_tmp=z_tmp  &
!  &             +coef*((rhos/rhow)**2)*ns0*((rho*qs/(pi*rhos*ns0))**1.75)!*1.0e18
  &             +coef*((dble(rhos)/dble(rhow))**2)*((dble(rho)/pi_dp)**1.75d0)  &
  &                  *dexp(-0.75d0*dlog(dble(ns0))+1.75d0*(dlog(dble(qs))-dlog(dble(rhos))))
        end if
     end if
  end if

  if(present(qg))then
     if(present(ng))then   ! For 2-moment
        if(dble(ng)>0.0d0.and.dble(qg)>0.0d0)then
           z_tmp=z_tmp  &
!  &             +coef*((rho*qg/(pi*rhow))**2)/ng  !*1.0e18
  &             +coef*((dble(rho)/pi_dp)**2)  &
  &                  *dexp(2.0d0*(dlog(dble(qg))-dlog(dble(rhow)))-dlog(dble(ng)))
        end if
     else   ! For 1-moment
        if(dble(qg)>0.0d0)then
           z_tmp=z_tmp  &
!  &             +coef*((rhog/rhow)**2)*ng0*((rho*qg/(pi*rhog*ng0))**1.75)!*1.0e18
  &             +coef*((dble(rhog)/dble(rhow))**2)*((dble(rho)/pi_dp)**1.75d0)  &
  &                  *dexp(-0.75d0*dlog(dble(ng0))+1.75d0*(dlog(dble(qg))-dlog(dble(rhog))))
        end if
     end if
  end if

  if(dble(qr)>0.0d0)then
!     z_tmp=z_tmp+nr0*((rho*qr/(pi*rhow*nr0))**1.75)!*1.0e18
     z_tmp=z_tmp+((dble(rho)/pi_dp)**1.75d0)  &
  &              *dexp(-0.75d0*dlog(dble(nr0))+1.75d0*(dlog(dble(qr))-dlog(dble(rhow))))
  end if

  if(z_tmp>0.0)then
     qrsg_2_dbz=180.0+10.0*log10(720.0)+10.0*real(dlog10(z_tmp))
  else
     qrsg_2_dbz=0.0
  end if

  if(present(dl))then
     call debug_flag_r( dl, 'Thermo_Advanced_Function', 'qrsg_2_dbz', qrsg_2_dbz, 'dBZ' )
  end if

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

!real function




!  return
!end function

!-----------------------------------------------------
!-----------------------------------------------------





end module
