module time_scheme
! ֥ऴȤ˷׻Ԥ⥸塼
! force_solv Ƿ׻ͤ򥹥˹碌Ƴ꿶,
! ֥ƥåפȯŸ.
  use Derivation
  use Ellip_Slv
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use real_initialize
  use sub_calc
  use force_solv

contains

subroutine time_schematic( step )

  implicit none
  integer, intent(in) :: step  ! ॹƥåֹ
  integer :: ct, i, j

!-- ڥȥѿʬ

  select case (time_flag(1:1))
  case ('1')  ! RK4 

  !-- ѿι
     do j=1,ny
        do i=1,nx
           omega_tmp(i,j)=omega_new(i,j)
           omega_old(i,j)=omega_new(i,j)
           buoy_tmp(i,j)=buoy_new(i,j)
           buoy_old(i,j)=buoy_new(i,j)
           psi_old(i,j)=psi_new(i,j)
        end do
     end do

  !-- RK4 ΤȤΤѤѿν force_solv ȤΩ RK4 ΤȤΤư.

     call real_init( forcea_omega )
     call real_init( forcea_buoy )

     do ct=1,4  ! RK4 η򤽤줾׻

     !-- ׻.

        call force()

!--  ʬ (RK4 ˡ)
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 select case (ct)
                 case (1)
                    forcea_omega(i,j)=forcea_omega(i,j)+force_omega(i,j)
                    omega_old(i,j)=omega_tmp(i,j)+(0.5*dt)*force_omega(i,j)
                    forcea_buoy(i,j)=forcea_buoy(i,j)+force_buoy(i,j)
                    buoy_old(i,j)=buoy_tmp(i,j)+(0.5*dt)*force_buoy(i,j)
                 case (2)                         
                    forcea_omega(i,j)=forcea_omega(i,j)+2.0*force_omega(i,j)
                    omega_old(i,j)=omega_tmp(i,j)+(0.5*dt)*force_omega(i,j)
                    forcea_buoy(i,j)=forcea_buoy(i,j)+2.0*force_buoy(i,j)
                    buoy_old(i,j)=buoy_tmp(i,j)+(0.5*dt)*force_buoy(i,j)
                 case (3)                         
                    forcea_omega(i,j)=forcea_omega(i,j)+2.0*force_omega(i,j)
                    omega_old(i,j)=omega_tmp(i,j)+(dt)*force_omega(i,j)
                    forcea_buoy(i,j)=forcea_buoy(i,j)+2.0*force_buoy(i,j)
                    buoy_old(i,j)=buoy_tmp(i,j)+(dt)*force_buoy(i,j)
                 case (4)                         
                    forcea_omega(i,j)=forcea_omega(i,j)+force_omega(i,j)
                    omega_new(i,j)=omega_tmp(i,j)+(dt/6.0)*forcea_omega(i,j)
                    forcea_buoy(i,j)=forcea_buoy(i,j)+force_buoy(i,j)
                    buoy_new(i,j)=buoy_tmp(i,j)+(dt/6.0)*forcea_buoy(i,j)
                 end select
              end if
           end do
        end do
!$omp end do
!$omp end parallel

!-- ΰαپ줫ήؿջ

        pois_force=0.0

        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..false.)then
                 omega_new(i,j)=undef
                 buoy_new(i,j)=undef
                 pois_force(i,j)=undef
              else
                 select case (ct)
                 case (1,2,3)
                    pois_force(i,j)=omega_old(i,j)
                 case (4)
                    pois_force(i,j)=omega_new(i,j)
                 end select
              end if
           end do
        end do

        select case (ct)
        case (1,2,3)
           call Ellip_Jacobi_2d( x, y, pois_force, eps, boundary, psi_old,  &
  &                             bound_opt=bndp, undef=undef, inner_bound=ibp,  &
  &                             init_flag=.false. )

           call set_omega_inner( x, y, psi_old, ibo, bndo )
           call bound_set( x, y, omega_old, ibo, bndo, undef )
           call bound_set( x, y, buoy_old, ibb, bndo, undef )

        case (4)
           call Ellip_Jacobi_2d( x, y, pois_force, eps, boundary, psi_new,  &
  &                             bound_opt=bndp, undef=undef, inner_bound=ibp,  &
  &                             init_flag=.false. )

        end select

     end do

!-- 
!-- ήή -> ή® => psi : ή˿ľѲ, omega : 0
!-- ήήи -> ˿ľήϤʤ => psi, omega : Υޥեå
!-- ¦ -> ͳ٤ -> psi ήƱͤǰ, omega : 0
!--  -> ٤ʤ -> psi : 0, omega : ¦ psi ư.

     call set_omega_inner( x, y, psi_new, ibo, bndo )
     call bound_set( x, y, omega_new, ibo, bndo, undef )
     call bound_set( x, y, buoy_new, ibb, bndo, undef )

  case ('2')  ! Leap Frog 

     if(step==1)then
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_tmp(i,j)=omega_new(i,j)  ! old ()  tmp (1 ƥå) .
                 omega_old(i,j)=omega_new(i,j)  ! new (1 ƥå)  old () .
                 buoy_tmp(i,j)=buoy_new(i,j)  ! old ()  tmp (1 ƥå) .
                 buoy_old(i,j)=buoy_new(i,j)  ! new (1 ƥå)  old () .
              end if
           end do
        end do
     else
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_tmp(i,j)=omega_old(i,j)  ! old ()  tmp (1 ƥå) .
                 omega_old(i,j)=omega_new(i,j)  ! new (1 ƥå)  old () .
                 buoy_tmp(i,j)=buoy_old(i,j)  ! old ()  tmp (1 ƥå) .
                 buoy_old(i,j)=buoy_new(i,j)  ! new (1 ƥå)  old () .
              end if
           end do
        end do
     end if

  !-- ׻.

     call force()

     if(step==1)then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_new(i,j)=omega_old(i,j)+dt*force_omega(i,j)
                 buoy_new(i,j)=buoy_old(i,j)+dt*force_buoy(i,j)
              end if
           end do
        end do
!$omp end do
!$omp end parallel

     else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_new(i,j)=omega_tmp(i,j)+2.0*dt*force_omega(i,j)
                 buoy_new(i,j)=buoy_tmp(i,j)+2.0*dt*force_buoy(i,j)
              end if
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!-- ΰαپ줫ήؿջ

     do j=1,ny
        do i=1,nx
           if(calc_flag(i,j).eqv..false.)then
              omega_new(i,j)=undef
              buoy_new(i,j)=undef
              pois_force(i,j)=undef
           else
              pois_force(i,j)=omega_new(i,j)
           end if
        end do
     end do

     call Ellip_Jacobi_2d( x, y, pois_force, eps, boundary, psi_new,  &
  &                       bound_opt=bndp, undef=undef, inner_bound=ibp,  &
  &                       init_flag=.false. )

!-- 
!-- ήή -> ή® => psi : ή˿ľѲ, omega : 0
!-- ήήи -> ˿ľήϤʤ => psi, omega : Υޥեå
!-- ¦ -> ͳ٤ -> psi ήƱͤǰ, omega : 0
!--  -> ٤ʤ -> psi : 0, omega : ¦ psi ư.

     call set_omega_inner( x, y, psi_new, ibo, bndo )
     call bound_set( x, y, omega_new, ibo, bndo, undef )
     call bound_set( x, y, buoy_new, ibb, bndo, undef )

  end select



end subroutine

end module
