!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module stdio
! ɸѥ⥸塼
! Ū¾⥸塼ΥǥХåѤˤΤ߻Ѥ,
! 桼ܥ⥸塼ռɬפϤʤ.

contains

subroutine stdio_integer( cmod, cpro, ival, unity )
! ֤³ˤĤ, ͤȼ³֤̾.
  implicit none
  character(*), intent(in) :: cmod             ! ⥸塼̾
  character(*), intent(in) :: cpro             ! ³̾
  integer, intent(in) :: ival                  ! ³֤
  character(*), intent(in), optional :: unity  ! ñ
  character(100) :: formal                     ! ϥեޥå
  character(20) :: unitc
  integer :: lengc(3)

  lengc(1)=len_trim(adjustl(cmod))
  lengc(2)=len_trim(adjustl(cpro))

  if(present(unity))then

     lengc(3)=len_trim(adjustl(unity))

     write(formal,*) lengc(1)+lengc(2)+lengc(3)+15
     write(unitc,*) lengc(3)+3

     formal='(a'//trim(adjustl(formal))//',I8.8,a'//trim(adjustl(unitc))//')'

     write(*,trim(formal)) "DEBUG : "//trim(adjustl(cpro))//' in '  &
  &                        //trim(adjustl(cmod))//' : ', ival,  &
  &                        ' ['//trim(adjustl(unity))//']'

  else

     write(formal,*) lengc(1)+lengc(2)+15

     formal='(a'//trim(adjustl(formal))//',I8.8)'

     write(*,trim(formal)) "DEBUG : "//trim(adjustl(cpro))//' in '  &
  &                        //trim(adjustl(cmod))//' : ', ival

  end if

end subroutine stdio_integer


subroutine stdio_real( cmod, cpro, rval, unity )
! ¿֤³ˤĤ, ͤȼ³֤̾.
  implicit none
  character(*), intent(in) :: cmod             ! ⥸塼̾
  character(*), intent(in) :: cpro             ! ³̾
  real, intent(in) :: rval                     ! ³֤
  character(*), intent(in), optional :: unity  ! ñ
  character(100) :: formal                     ! ϥեޥå
  character(20) :: unitc
  integer :: lengc(3)

  lengc(1)=len_trim(adjustl(cmod))
  lengc(2)=len_trim(adjustl(cpro))

  if(present(unity))then

     lengc(3)=len_trim(adjustl(unity))

     write(formal,*) lengc(1)+lengc(2)+15
     write(unitc,*) lengc(3)+3

     formal='(a'//trim(adjustl(formal))//',1P,E14.5,a'//trim(adjustl(unitc))//')'

     write(*,trim(adjustl(formal))) "DEBUG : "//trim(adjustl(cpro))//' in '  &
  &                        //trim(adjustl(cmod))//' : ', rval,  &
  &                        ' ['//trim(adjustl(unity))//']'

  else

     write(formal,*) lengc(1)+lengc(2)+15

     formal='(a'//trim(adjustl(formal))//',1P,E14.5)'

     write(*,trim(formal)) "DEBUG : "//trim(adjustl(cpro))//' in '  &
  &                        //trim(adjustl(cmod))//' : ', rval

  end if

end subroutine stdio_real


subroutine stdio_char( cval, cflag, cmod, cpro )
! ³̾ȥ⥸塼̾յʤ, ʸϤԤ.
  implicit none
  character(*), intent(in) :: cval             ! Ϥå
  character(1), intent(in) :: cflag            ! åμ.
                           ! 'E' = 顼, 'W' = ٹ, 'M' = ñʤå.
  character(*), intent(in), optional :: cmod   ! ⥸塼̾
  character(*), intent(in), optional :: cpro   ! ³̾
  character(100) :: formal                     ! ϥեޥå
  character(15) :: tmpc
  integer :: lengc(4)

  if(present(cmod))then
     lengc(1)=len_trim(adjustl(cmod))
     lengc(4)=23
  else
     lengc(1)=0
     lengc(4)=16
  end if

  if(present(cpro))then
     lengc(2)=len_trim(adjustl(cpro))
  else
     lengc(2)=0
  end if

  lengc(3)=len_trim(adjustl(cval))

  select case (cflag(1:1))
  case ('E')
     tmpc='**** ERROR **** '
  case ('W')
     tmpc='*** WARNING *** '
  case ('M')
     tmpc='*** MESSAGE *** '
  end select

  write(formal,*) lengc(1)+lengc(2)+lengc(3)+lengc(4)

  formal='(a'//trim(adjustl(formal))//')'

  if(present(cmod))then
     write(*,formal) trim(adjustl(tmpc))//trim(adjustl(cpro))//' in '  &
  &                  //trim(adjustl(cmod))//' : ', trim(adjustl(cval))
  else
     write(*,formal) trim(adjustl(tmpc))//trim(adjustl(cval))
  end if

end subroutine stdio_char


subroutine stdio_array( cval, array_num )
! ֹϤ.
  implicit none
  character(*), intent(in) :: cval     ! ̾
  integer, intent(in) :: array_num(:)  ! Ƽֹ
  integer :: i, ni, nc
  character(20) :: formal
  character(1000) :: output_char
  character(6) :: i2c, tmpc

  ni=size(array_num)
  nc=len_trim(cval)+ni*7+2

  write(i2c,*) nc
  formal='(a'//trim(adjustl(i2c))//')'

  output_char=trim(cval)//'('

  do i=1,ni
     write(tmpc,'(I6)') array_num(i)
     output_char=trim(adjustl(output_char))//tmpc(1:6)//','
  end do

  output_char(len_trim(output_char):len_trim(output_char))=')'

  write(*,trim(formal)) trim(adjustl(output_char))

end subroutine stdio_array


subroutine nan_check_s( cmod, cpro, rval )
! ¿֤³ˤĤ, ͤ nan ǤФλݷٹ𤹤.
  implicit none
  character(*), intent(in) :: cmod   ! ⥸塼̾
  character(*), intent(in) :: cpro   ! ³̾
  real, intent(in) :: rval           ! ³֤

!!  if(isnan(rval))then
  if(rval/=rval)then   ! isnan ؿʤȤθ.
     call stdio_char( 'Detected NaN value.', 'E',  &
  &                   cmod=trim(cmod), cpro=trim(cpro) )
  end if

end subroutine nan_check_s


subroutine nan_check_a( cmod, cpro, nx, ny, nz, val )
  ! ¿ val  nan ͤ¸ߤȥ顼Ϥ.
  !  3 Ǥ뤬, ǿ 1 ʤɤꤹ뤳Ȥ,
  ! 1, 2 ФƤѴǽ.
  implicit none
  character(*), intent(in) :: cmod    ! ⥸塼̾
  character(*), intent(in) :: cpro    ! ³̾
  integer, intent(in) :: nx           !  1 Ǥǿ
  integer, intent(in) :: ny           !  2 Ǥǿ
  integer, intent(in) :: nz           !  3 Ǥǿ
  real, intent(in) :: val(nx,ny,nz)   ! Ѵ
  integer :: i, j, k, counter  ! 

  counter=0

  do k=1,nz
     do j=1,ny
        do i=1,nx
!!           if(isnan(val(i,j,k)))then
           if(val(i,j,k)/=val(i,j,k))then   ! isnan ؿʤȤθ.
              if(counter==0)then
                 counter=1
                 call stdio_char( 'Detected NaN value.', 'E',  &
  &                               cmod=trim(cmod), cpro=trim(cpro) )
                 call stdio_array( 'VAL', (/i, j, k/) )
              else
                 call stdio_array( 'VAL', (/i, j, k/) )
              end if
           end if
        end do
     end do
  end do

end subroutine nan_check_a


subroutine debug_flag_i( dl, cmod, cpro, ival, unity )
! 顼ѿ֤³ˤĤ, debug level Ȥ˽.
  implicit none
  integer, intent(in) :: dl                    ! debug level
  ! 0 = ⤷ʤ, 1 = NaN ͤäƤȷٹ, 2 = ͤɸ
  character(*), intent(in) :: cmod             ! ⥸塼̾
  character(*), intent(in) :: cpro             ! ³̾
  integer, intent(in) :: ival                  ! ³֤
  character(*), intent(in), optional :: unity  ! ñ

  select case (dl)
!  case (1)
!     call nan_check_s( trim(cmod), trim(cpro), rval )
  case (2)
     if(present(unity))then
        call stdio_integer( trim(cmod), trim(cpro), ival, trim(unity) )
     else
        call stdio_integer( trim(cmod), trim(cpro), ival )
     end if
  end select

end subroutine debug_flag_i


subroutine debug_flag_r( dl, cmod, cpro, rval, unity )
! ¿顼ѿ֤³ˤĤ, debug level Ȥ˽.
  implicit none
  integer, intent(in) :: dl                    ! debug level
  ! 0 = ⤷ʤ, 1 = NaN ͤäƤȷٹ, 2 = ͤɸ
  character(*), intent(in) :: cmod             ! ⥸塼̾
  character(*), intent(in) :: cpro             ! ³̾
  real, intent(in) :: rval                     ! ³֤
  character(*), intent(in), optional :: unity  ! ñ

  select case (dl)
  case (1)
     call nan_check_s( trim(cmod), trim(cpro), rval )
  case (2)
     if(present(unity))then
        call stdio_real( trim(cmod), trim(cpro), rval, trim(unity) )
     else
        call stdio_real( trim(cmod), trim(cpro), rval )
     end if
  end select

end subroutine debug_flag_r


subroutine debug_flag_a( dl, cmod, cpro, nx, ny, nz, aval )
! ¿ѿ֤³ˤĤ, debug level Ȥ˽.
  implicit none
  integer, intent(in) :: dl                    ! debug level
  ! 0 = ⤷ʤ, 1 = NaN ͤäƤȷٹ
  character(*), intent(in) :: cmod      ! ⥸塼̾
  character(*), intent(in) :: cpro      ! ³̾
  integer, intent(in) :: nx             !  1 Ǥǿ
  integer, intent(in) :: ny             !  2 Ǥǿ
  integer, intent(in) :: nz             !  3 Ǥǿ
  real, intent(in) :: aval(nx,ny,nz)    ! ³֤

  select case (dl)
  case (1)
     call nan_check_a( trim(cmod), trim(cpro), nx, ny, nz, aval )
!  case (2)
!     if(present(unity))then
!        call stdio_real( trim(cmod), trim(cpro), rval, trim(unity) )
!     else
!        call stdio_real( trim(cmod), trim(cpro), rval )
!     end if
  end select

end subroutine debug_flag_a




end module stdio
