module comm_mpi
  use mpi
  use val_define
  use val_alloc

contains

subroutine auto_comm_mpi_real()
  implicit none
  real, dimension(2,3) :: send, recv

  send(1,1:3)=(/ub(2),vb(2),hb(2)/)           ! -> recv1 , ΰκٱü
  send(2,1:3)=(/ub(nr-1),vb(nr-1),hb(nr-1)/)  ! -> recv2 , ΰαٺü

  call communicating_mpi_real( send, recv )

  if(MY_RANK/=0)then
     ub(nr)=recv(2,1)
     vb(nr)=recv(2,2)
     hb(nr)=recv(2,3)
  end if

  if(MY_RANK/=petot-1)then
     ub(1)=recv(1,1)
     vb(1)=recv(1,2)
     hb(1)=recv(1,3)
  end if

end subroutine auto_comm_mpi_real

subroutine auto_comm_mpi_complex()
  implicit none
  integer :: i, j, k
  complex, dimension(2,ntheta) :: send1, recv1
  complex, dimension(2,jnt) :: send2, recv2

  do j=1,3
     select case (j)
     case (1)
        do i=1,ntheta
           send1(1,i)=ucp_old(2,i)
           send1(2,i)=ucp_old(nr-1,i)
        end do
        do i=1,jnt
           send2(1,i)=frup(2,i)
           send2(2,i)=frup(nr-1,i)
        end do
     case (2)
        do i=1,ntheta
           send1(1,i)=vcp_old(2,i)
           send1(2,i)=vcp_old(nr-1,i)
        end do
        do i=1,jnt
           send2(1,i)=frvp(2,i)
           send2(2,i)=frvp(nr-1,i)
        end do
     case (3)
        do i=1,ntheta
           send1(1,i)=hcp_old(2,i)
           send1(2,i)=hcp_old(nr-1,i)
        end do
        do i=1,jnt
           send2(1,i)=frhp(2,i)
           send2(2,i)=frhp(nr-1,i)
        end do
     end select

     call communicating_mpi_complex( send1, recv1 )
     call communicating_mpi_complex( send2, recv2 )

     if(MY_RANK/=0)then
        select case (j)
        case (1)
           do i=1,ntheta
              ucp_old(1,i)=recv1(1,i)
           end do
           do i=1,jnt
              frup(1,i)=recv2(1,i)
           end do
        case (2)
           do i=1,ntheta
              vcp_old(1,i)=recv1(1,i)
           end do
           do i=1,jnt
              frvp(1,i)=recv2(1,i)
           end do
        case (3)
           do i=1,ntheta
              hcp_old(1,i)=recv1(1,i)
           end do
           do i=1,jnt
              frhp(1,i)=recv2(1,i)
           end do
        end select
     end if

     if(MY_RANK/=petot-1)then
        select case (j)
        case (1)
           do i=1,ntheta
              ucp_old(nr,i)=recv1(2,i)
           end do
           do i=1,jnt
              frup(nr,i)=recv2(2,i)
           end do
        case (2)
           do i=1,ntheta
              vcp_old(nr,i)=recv1(2,i)
           end do
           do i=1,jnt
              frvp(nr,i)=recv2(2,i)
           end do
        case (3)
           do i=1,ntheta
              hcp_old(nr,i)=recv1(2,i)
           end do
           do i=1,jnt
              frhp(nr,i)=recv2(2,i)
           end do
        end select
     end if
  end do

end subroutine auto_comm_mpi_complex

subroutine communicating_mpi_real( send, recv )
  implicit none
  real, intent(in) :: send(:,:)
  real, intent(inout) :: recv(size(send,1),size(send,2))
  real :: sendr(size(send,2)), recvr(size(send,2))
  integer :: i, j, k, n1, n2
  integer :: tmprank, sendarr, recvarr

  n1=size(send,1)
  n2=size(send,2)

  recv=0.0

  if(petot>1)then               ! total pe must be greater than 1.
     if(mod(MY_RANK,2)==0)then  ! odd num is right side
        tmprank=MY_RANK+1
        sendarr=2
        recvarr=2
     else                       ! even num is left side
        tmprank=MY_RANK-1
        sendarr=1
        recvarr=1
     end if

     do i=1,n2
        sendr(i)=send(sendarr,i)
     end do

     if(tmprank<petot)then      ! petot ξ, tmprank κǹ petot-1 ̿ꤢ. petot ξ, tmprank κǹ petot Ȥʤ. petot ΤȤϰֳ¦꤬̿ʤ,  if ʸǤޤƤ.
        call MPI_Isend( sendr(1), n2, MPI_REAL, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_send, IERROR )
        call MPI_Irecv( recvr(1), n2, MPI_REAL, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_recv, IERROR )
        call MPI_WAITALL( isend, request_recv, stat_recv, IERROR )
        call MPI_WAITALL( isend, request_send, stat_send, IERROR )

        do i=1,n2
           recv(recvarr,i)=recvr(i)
        end do

     end if

!-- ⤷, δ֤ barrier ɬפ뤫.
  
     if(mod(MY_RANK,2)/=0)then  ! odd num is right side
        tmprank=MY_RANK+1
        sendarr=2
        recvarr=2
     else                       ! even num is left side
        tmprank=MY_RANK-1
        sendarr=1
        recvarr=1
     end if

     do i=1,n2
        sendr(i)=send(sendarr,i)
     end do

     if(tmprank>0.and.tmprank<petot)then          ! ޤ, tmprank κ -1 ʤΤ, ʸǺüδ̿ѤߤƤ (ǰΤ 0 ʾƤƤ뤬). petot ξ, tmprank κǹ petot ꤬̿ʤ. petot ξ, tmprank κǹ petot-2 ꤬̿Τ,  if ʸƤ.
        call MPI_Isend( sendr(1), n2, MPI_REAL, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_send, IERROR )
        call MPI_Irecv( recvr(1), n2, MPI_REAL, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_recv, IERROR )
        call MPI_WAITALL( isend, request_recv, stat_recv, IERROR )
        call MPI_WAITALL( isend, request_send, stat_send, IERROR )

        do i=1,n2
           recv(recvarr,i)=recvr(i)
        end do

     end if

  end if

end subroutine communicating_mpi_real

subroutine communicating_mpi_complex( send, recv )
  implicit none
  complex, intent(in) :: send(:,:)
  complex, intent(inout) :: recv(size(send,1),size(send,2))
  complex :: sendr(size(send,2)), recvr(size(send,2))
  integer :: i, j, k, n1, n2
  integer :: tmprank, sendarr, recvarr

  n1=size(send,1)
  n2=size(send,2)

  recv=0.0

  if(petot>1)then               ! total pe must be greater than 1.
     if(mod(MY_RANK,2)==0)then  ! odd num is right side
        tmprank=MY_RANK+1
        sendarr=2
        recvarr=2
     else                       ! even num is left side
        tmprank=MY_RANK-1
        sendarr=1
        recvarr=1
     end if

     do i=1,n2
        sendr(i)=send(sendarr,i)
     end do

     if(tmprank<petot)then      ! petot ξ, tmprank κǹ petot-1 ̿ꤢ. petot ξ, tmprank κǹ petot Ȥʤ. petot ΤȤϰֳ¦꤬̿ʤ,  if ʸǤޤƤ.
        call MPI_Isend( sendr(1), n2, MPI_COMPLEX, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_send, IERROR )
        call MPI_Irecv( recvr(1), n2, MPI_COMPLEX, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_recv, IERROR )
        call MPI_WAITALL( isend, request_recv, stat_recv, IERROR )
        call MPI_WAITALL( isend, request_send, stat_send, IERROR )

        do i=1,n2
           recv(recvarr,i)=recvr(i)
        end do

     end if

!-- ⤷, δ֤ barrier ɬפ뤫.
  
     if(mod(MY_RANK,2)/=0)then  ! odd num is right side
        tmprank=MY_RANK+1
        sendarr=2
        recvarr=2
     else                       ! even num is left side
        tmprank=MY_RANK-1
        sendarr=1
        recvarr=1
     end if

     do i=1,n2
        sendr(i)=send(sendarr,i)
     end do

     if(tmprank>0.and.tmprank<petot)then          ! ޤ, tmprank κ -1 ʤΤ, ʸǺüδ̿ѤߤƤ (ǰΤ 0 ʾƤƤ뤬). petot ξ, tmprank κǹ petot ꤬̿ʤ. petot ξ, tmprank κǹ petot-2 ꤬̿Τ,  if ʸƤ.
        call MPI_Isend( sendr(1), n2, MPI_COMPLEX, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_send, IERROR )
        call MPI_Irecv( recvr(1), n2, MPI_COMPLEX, tmprank, 0,  &
        &               MPI_COMM_WORLD, request_recv, IERROR )
        call MPI_WAITALL( isend, request_recv, stat_recv, IERROR )
        call MPI_WAITALL( isend, request_send, stat_send, IERROR )

        do i=1,n2
           recv(recvarr,i)=recvr(i)
        end do

     end if

  end if

end subroutine communicating_mpi_complex

end module comm_mpi
