program so
  use Alge_Solv
  use dcl
  use Dcl_Automatic

  integer :: nx, ny
  real :: dx, dy
  real, allocatable :: x(:), y(:)
  real, allocatable :: rho(:,:)
  real, allocatable :: psi(:,:)
  integer :: tp, method
  integer :: IWS
  real :: cmin, cmax, contmin, contmax
  character(6) :: form_types, form_typec

 namelist /input /nx,ny,tp,cmin,cmax,contmin,contmax,IWS,form_types,form_typec,method
 read(5,input)

  allocate(x(nx))
  allocate(y(ny))
  allocate(psi(nx,ny))
  allocate(rho(nx,ny))

  dx=1.0/real(nx-1)
  dy=1.0/real(ny-1)

  x=(/(dx*(i-1),i=1,nx)/)
  y=(/(dy*(i-1),i=1,ny)/)

  rho=0.0
! do i=1,nx
! do j=1,ny
! rho(i,j)=exp(-10.0*((x(i)-0.5)**2+(y(j)-0.5)**2))
! end do
! end do
  do i=1,nx
     do j=1,ny

        if((((i-50)**2+(j-50)**2)*dx*dy)<0.05*0.05)then

           rho(i,j)=-1.0e4/8.85

        end if

     end do
  end do
 
  select case (method)
  case(1)
     call Poisson_GauSei(nx,ny,dx,dy,rho,1.0e-6,tp,psi)
  case(2)
     call Poisson_Jacobi(nx,ny,dx,dy,rho,1.0e-6,tp,psi)
  end select

  call color_setting( 10, cmin, cmax )

  call DclOpenGraphics(IWS)

  call Dcl_2D_cont_shade( 'solution', x, y, psi, psi, contmin, contmax,  &
  &    cmin, cmax, 'x-axis', 'y-axis', form_typec, form_types, color_num=10 )

  call DclCloseGraphics

end program
