!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!  
!  
program wa_test1

  use wa_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=2  ! ʻ(, , ľ)
  integer,parameter  :: nm=10               ! ȿ(ʿ)

  real(8), dimension(im,jm,km)       :: xyz_Data_in
  real(8), dimension(im,jm,km)       :: xyz_Data_out
  real(8), dimension(im,jm,km)       :: xyz_Data_exact

  real(8), dimension(im,jm)          :: xy_Mu

  real(8), parameter :: eps=1D-10

  integer :: i,j,k

  write( 6,* ) 'Test for '

  call wa_Initial(nm,im,jm,km)
  xy_Mu = sin(xy_Lat)

  xyz_Data_in(:,:,1) = xy_Mu * (1-xy_Mu**2)
  xyz_Data_in(:,:,2) = xy_Mu**2 * (1-xy_Mu**2)
  xyz_Data_exact(:,:,1) = 1.00 - 3*xy_Mu**2
  xyz_Data_exact(:,:,2) = 2*xy_Mu - 4*xy_Mu**3
  xyz_Data_out = xya_wa(wa_DivMu_xya(xyz_Data_in))
  write( 6,* ) 
  write( 6,* ) 'Checking wa_DivMu_xya...'
  call check_results

  xyz_Data_in(:,:,1) = cos(xy_Lat)**3 * sin(xy_Lon)
  xyz_Data_in(:,:,2) = xy_Mu*cos(xy_Lat)**3 * cos(xy_Lon)
  xyz_Data_exact(:,:,1) = cos(xy_Lat) * cos(xy_Lon)
  xyz_Data_exact(:,:,2) = -xy_Mu* cos(xy_Lat)* sin(xy_Lon)
  xyz_Data_out = xya_wa(wa_DivLambda_xya(xyz_Data_in))
  write( 6,* ) 
  write( 6,* ) 'Checking wa_DivLambda_xya...'
  call check_results

  xyz_Data_in(:,:,1) = xy_Mu
  xyz_Data_in(:,:,2) = xy_Mu**2
  xyz_Data_exact(:,:,1) = 1.0 - xy_Mu**2
  xyz_Data_exact(:,:,2) = 2*xy_Mu*(1.0 - xy_Mu**2)
  xyz_Data_out = xya_GradMu_wa(wa_xya(xyz_Data_in))
  write( 6,* ) 
  write( 6,* ) 'Checking xya_GradMu_wa...'
  call check_results

  xyz_Data_in(:,:,1) = sqrt(1-xy_Mu**2) * sin(xy_Lon) 
  xyz_Data_in(:,:,2) = sqrt(1-xy_Mu**2) * xy_Mu * cos(xy_Lon)
  xyz_Data_exact(:,:,1) = sqrt(1-xy_Mu**2) * cos(xy_Lon)
  xyz_Data_exact(:,:,2) = -xy_Mu * sqrt(1-xy_Mu**2) * sin(xy_Lon)
  xyz_Data_out = xya_GradLambda_wa(wa_xya(xyz_Data_in))
  write( 6,* ) 
  write( 6,* ) 'Checking wa_GradLambda_xya...'
  call check_results


contains
  subroutine check_results
    write( 6,* ) '  Non-zero component of wt_Data(i,j,k)'
    write( 6,* ) '  i,j,k Data'
    do k=1,km
       do j=1,jm
          do i=1,im
             if ( abs(xyz_Data_out(i,j,k)-xyz_Data_exact(i,j,k)) .gt. eps ) then
                write (6,*) i,j,k, xyz_Data_out(i,j,k),xyz_Data_exact(i,j,k)
             endif
          enddo
       enddo
    enddo

    return
  end subroutine check_results

end program wa_test1

