!----------------------------------------------------------------------
!     Copyright 2001--2005 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ee_module
!
!  2001/10/07  ݹ
!      2001/12/25  ݹ  ؿ, ѿ̿̾ˡѹ
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/08/19  ݹ  ʻҥǡź gg -> xy ѹ
!      2002/08/20  ݹ  ʬʿѴؿɲ
!      2005/03/15  ݹ  xy -> yx ƬҤѹ
!
module ee_module
  implicit none

  private
  public ee_initial                                       ! 롼
  public yx_ee, ee_yx                                     ! Ѵ
  public ee_Lapla_ee, ee_LaplaInv_ee, ee_Dx_ee, ee_Dy_ee  ! ʬ
  public ee_JacobianZ_ee, ee_Jacobian_ee_ee               ! ׻
  public IntYX_yx, y_IntX_yx, x_IntY_yx, IntX_x, IntY_y   ! ʬ
  public AvrYX_yx, y_AvrX_yx, x_AvrY_yx, AvrX_x, AvrY_y   ! ʿ
  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y     ! ɸѿ

  integer   :: im=32, jm=32                      ! ʻ(X,Y)
  integer   :: km=10, lm=10                      ! ȿ(X,Y)
  real(8)   :: xl=1.0, yl=1.0                    ! ΰ礭

  integer,dimension(5)              :: itj
  real(8),dimension(:),allocatable  :: tj
  integer,dimension(5)              :: iti
  real(8),dimension(:),allocatable  :: ti

  real(8), dimension(:), allocatable    :: x_X, x_X_Weight  ! ɸѿ(1 )
  real(8), dimension(:), allocatable    :: y_Y, y_Y_Weight  ! ɸѿ(1 )
  real(8), dimension(:,:), allocatable  :: yx_X, yx_Y       ! ɸѿ(2 )


  real(8), dimension(:),  allocatable  :: yx_work, ee_work, yx_work3
  real(8), dimension(:,:),allocatable  :: yx_tmp, yx_tmp1, ee_tmp
  real(8), parameter  :: pi=3.1415926535897932385D0

  save im, jm, km, lm, itj, tj, iti, ti, xl, yl
  save x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y

  contains
  !---------------  -----------------
    subroutine ee_initial(i,j,k,l,xmin,xmax,ymin,ymax)

      integer,intent(in) :: i, j           ! ʻ(X,Y)
      integer,intent(in) :: k, l           ! ȿ(X,Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      integer :: ii, jj

      im = i         ; jm = j
      km = k         ; lm = l
      xl = xmax-xmin ; yl = ymax-ymin

      allocate(tj(jm*2),ti(im*2))
      allocate(yx_work(jm*im),ee_work((2*km+1)*(2*lm+1)),yx_work3(jm*im*3))
      allocate(yx_tmp(0:jm-1,0:im-1),yx_tmp1(0:jm-1,0:im-1))
      allocate(ee_tmp(-lm:lm,-km:km))

      call n2init(jm,im,itj,tj,iti,ti)

      allocate(x_X(0:im-1), x_X_Weight(0:im-1))
      allocate(y_Y(0:jm-1), y_Y_Weight(0:jm-1))
      allocate(yx_X(0:jm-1,0:im-1), yx_Y(0:jm-1,0:im-1))

      do ii=0,im-1
         x_X(ii) = xmin + xl/im*ii
      enddo
      x_X_Weight = xl/im

      do jj=0,jm-1
         y_Y(jj) = ymin + yl/jm*jj
      enddo
      y_Y_Weight = yl/jm

      yx_X = spread(x_X,1,jm)
      yx_Y = spread(y_Y,2,im)

    end subroutine ee_initial

  !--------------- Ѵ -----------------
    function yx_ee(ee) ! ڥȥ -> ʻ
      real(8), dimension(0:jm-1,0:im-1)             :: yx_ee
      real(8), dimension(-lm:lm,-km:km), intent(in) :: ee

      call n2s2ga(lm,km,jm,im,ee,yx_ee,yx_work,itj,tj,iti,ti)
    end function yx_ee

    function ee_yx(yx)  ! ʻ -> ڥȥ
      real(8), dimension(-lm:lm,-km:km)              :: ee_yx
      real(8), dimension(0:jm-1,0:im-1), intent(in)  :: yx

      yx_tmp = yx
      call n2g2sa(lm,km,jm,im,yx_tmp,ee_yx,yx_work,itj,tj,iti,ti)
    end function ee_yx

  !--------------- ʬ׻ -----------------
    function ee_Lapla_ee(ee)   ! ڥȥ˺Ѥ Laplacian 黻
      real(8), dimension(-lm:lm,-km:km)              :: ee_Lapla_ee
      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee
      integer k,l

      do k=-km,km
         do l=-lm,lm
            ee_Lapla_ee(l,k) = -((2*pi*k/xl)**2+(2*pi*l/yl)**2)*ee(l,k)
         enddo
      enddo
    end function ee_Lapla_ee

    function ee_LaplaInv_ee(ee)   ! ڥȥ SINY ˺Ѥ \nabla 黻
      real(8), dimension(-lm:lm,-km:km)             :: ee_LaplaInv_ee
      real(8), dimension(-lm:lm,-km:km), intent(in) :: ee
      integer k,l

      do k=-km,km
         do l=-lm,lm
            if ( k.ne.0 .or. l.ne.0 ) then
               ee_LaplaInv_ee(l,k) = -ee(l,k)/((2*pi*k/xl)**2+(2*pi*l/yl)**2)
            else
               ee_LaplaInv_ee(l,k) = 0.0
            endif
         enddo
      enddo
    end function ee_LaplaInv_ee

    function ee_Dx_ee(ee)   ! ڥȥ˺Ѥ x ʬ黻
      real(8), dimension(-lm:lm,-km:km)              :: ee_Dx_ee
      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee
      integer k,l

      do k=-km,km
         do l=-lm,lm
            ee_Dx_ee(l,k) = -(2*pi*k/xl)*ee(-l,-k)
         enddo
      enddo
    end function ee_Dx_ee

    function ee_Dy_ee(ee)   ! ڥȥ˺Ѥ y ʬ黻
      real(8), dimension(-lm:lm,-km:km)              :: ee_Dy_ee
      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee
      integer k,l

      do k=-km,km
         do l=-lm,lm
            ee_Dy_ee(l,k) = -(2*pi*l/yl)*ee(-l,-k)
         enddo
      enddo

    end function ee_Dy_ee

    function ee_Jacobian_ee_ee(ee_a,ee_b)  ! ڥȥ˺Ѥ䥳ӥ J(sa,sb)
      real(8), dimension(-lm:lm,-km:km)              :: ee_Jacobian_ee_ee
      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee_a
      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee_b
      !integer k,l

      !ee_Jacobian_ee_ee =   ee_yx(  yx_ee(ee_Dx_ee(sa))*yx_ee(ee_Dy_ee(sb)) &
      !                 - yx_ee(ee_Dy_ee(sa))*yx_ee(ee_Dx_ee(sb)))

      yx_tmp1=yx_ee(ee_a)
      ee_Jacobian_ee_ee =   ee_dx_ee(ee_yx(yx_tmp1*yx_ee(ee_Dy_ee(ee_b)))) &
                 - ee_dy_ee(ee_yx(yx_tmp1*yx_ee(ee_Dx_ee(ee_b))))

    end function ee_Jacobian_ee_ee

    function ee_JacobianZ_ee(ee_zeta) ! ڥȥ˺Ѥ䥳ӥ J(psi,zeta)
      real(8), dimension(-lm:lm,-km:km)              :: ee_JacobianZ_ee
      real(8), dimension(-lm:lm,-km:km), intent(in)  :: ee_Zeta

      integer k,l

      call n2ajbs(lm,km,jm,im,ee_Zeta,ee_tmp,ee_work,yx_work3,itj,tj,iti,ti)
     
      do k=-km,km
         do l=-lm,lm
            ee_JacobianZ_ee(l,k) &
                 = (2*pi/xl)*(2*pi/yl)/((2*pi/xl)**2+(2*pi/yl)**2) &
                   * ee_tmp(l,k)
         enddo
      enddo

!!$      ee_tmp=ee_lapla_inv(zeta)
!!$      gv=yx_ee(ee_dx_ee(ee_tmp)) ; gu=yx_ee(ee_dy_ee(ee_tmp))
!!$      suv=ee_yx(gu*gv) ; suuvv=ee_yx(gv**2-gu**2)
!!$      ee_jacz_ee = ee_dx_ee(ee_dx_ee(suv)) - ee_dy_ee(ee_dy_ee(suv)) &
!!$                - ee_dx_ee(ee_dy_ee(suuvv))
    end function ee_JacobianZ_ee

  !--------------- ʬ׻ -----------------
    function IntYX_yx(yx)   ! ΰʬ
      real(8), dimension(0:jm-1,0:im-1)   :: yx          ! 2 ʻ
      real(8)                             :: IntYX_yx    ! ʬ
      integer :: i, j

      IntYX_yx = 0.0d0
      do i=0,im-1
         do j=0,jm-1
            IntYX_yx = IntYX_yx + yx(j,i) * y_Y_Weight(j) * x_X_Weight(i)
         enddo
      enddo
    end function IntYX_yx

    function y_IntX_yx(yx)  ! X ʬ
      real(8), dimension(0:jm-1,0:im-1)   :: yx          ! 2 ʻ
      real(8), dimension(0:jm-1)          :: y_IntX_yx   ! 1 (Y)ʻ
      integer :: i

      y_IntX_yx = 0.0d0
      do i=0,im-1
         y_IntX_yx(:) = y_IntX_yx(:) + yx(:,i) * x_X_Weight(i)
      enddo
    end function y_IntX_yx

    function x_IntY_yx(yx)  ! Y ʬ
      real(8), dimension(0:jm-1,0:im-1)   :: yx          ! 2 ʻ
      real(8), dimension(0:im-1)        :: x_IntY_yx   ! 1 (X)ʻ
      integer :: j

      x_IntY_yx = 0.0d0
      do j=0,jm-1
         x_IntY_yx(:) = x_IntY_yx(:) + yx(j,:) * y_Y_Weight(j)
      enddo
    end function x_IntY_yx

    function IntX_x(x)      ! X ʬ
      real(8), dimension(0:im-1)   :: x          ! 1 ʻ
      real(8)                      :: IntX_x     ! ʬ

      IntX_x = sum(x*x_X_Weight)
    end function IntX_x

    function IntY_y(y)      ! Y ʬ
      real(8), dimension(0:jm-1)   :: y        ! 1 ʻ
      real(8)                    :: IntY_y     ! ʬ

      IntY_y = sum(y*y_Y_Weight)
    end function IntY_y

  !--------------- ʿѷ׻ -----------------
    function AvrYX_yx(yx)    ! ΰʿ
      real(8), dimension(0:jm-1,0:im-1)   :: yx          ! 2 ʻ
      real(8)                             :: AvrYX_yx    ! ʿ

      AvrYX_yx = IntYX_yx(yx)/(sum(x_X_weight)*sum(y_Y_weight))
    end function AvrYX_yx

    function y_AvrX_yx(yx)   ! X ʿ
      real(8), dimension(0:jm-1,0:im-1)   :: yx          ! 2 ʻ
      real(8), dimension(0:jm-1)          :: y_AvrX_yx   ! 1 (Y)ʻ

      y_AvrX_yx = y_IntX_yx(yx)/sum(x_X_weight)
    end function y_AvrX_yx

    function x_AvrY_yx(yx)   ! Y ʿ
      real(8), dimension(0:jm-1,0:im-1)   :: yx          ! 2 ʻ
      real(8), dimension(0:im-1)          :: x_AvrY_yx   ! 1 (X)ʻ

      x_AvrY_yx = x_IntY_yx(yx)/sum(y_Y_weight)
    end function x_AvrY_yx

    function AvrX_x(x)       ! X ʿ
      real(8), dimension(0:im-1)   :: x          ! 2 ʻ
      real(8)                      :: AvrX_x     ! ʬ

      AvrX_x = IntX_x(x)/sum(x_X_weight)
    end function AvrX_x

    function AvrY_y(y)       ! Y ʿ
      real(8), dimension(0:jm-1) :: y          ! 2 ʻ
      real(8)                    :: AvrY_y     ! ʬ

      AvrY_y = IntY_y(y)/sum(y_Y_weight)
    end function AvrY_y

  end module ee_module
