#!/bin/sh
#
# Copyright (C) GFD Dennou Club, 2002-2005.  All rights reserved.
#
fc="`which ${FC:?}`"
fflags="-I${MODINSTDIR:?} $SYSFFLAGS $FFLAGS"
ldflags="$SYSLDFLAGS -L$LIBINSTDIR $LDFLAGS"
ldlibs="-l$LIBNAME $SYSLDLIBS $LDLIBS"
out=${1:-spmconfig}

if [ $F90MODTYPE = intel.d ]; then
	ldlibs=`echo $ldlibs | sed s/-lm//`
fi

cat > $out <<END_OF_SCRIPT
#!/bin/sh

fc="$fc"
fflags="$fflags"
ldflags="$ldflags"
ldlibs="$ldlibs"

usage() {
	cat <<EOF
usage: gt4config [OPTIONS]
options: one of --fc --fflags --ldflags --ldlibs
EOF
	exit 1
}

if test \$# -eq 0; then
	usage
fi

while test \$# -gt 0; do
    case \$1 in
	--fc)		echo \$fc ;;
	--fflags)	echo \$fflags ;;
	--ldflags)	echo \$ldflags ;;
	--ldlibs)	echo \$ldlibs ;;
	*)		usage ;;
    esac
    shift
done

END_OF_SCRIPT
