!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!      ݥݥƥ󥷥ζ
!
!  2008/04/04  ݹ
!      2008/07/05  ʿ  ѹ
!
program wq_test_polvelbc_tau

  use dc_message, only : MessageNotify
  use wq_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=8   ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=0.5               ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)     :: xyr_Poloidal
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_Poloidal0
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_LaplaPol
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_True
  real(8), dimension((nm+1)**2,0:lm) :: wq_Poloidal
  real(8), dimension((nm+1)**2,0:lm) :: wq_LaplaPol
  real(8), dimension((nm+1)**2,0:lm) :: wq_LaplaPol0
  real(8), dimension((nm+1)**2,0:lm) :: wq_True
  character(len=1), dimension(2), parameter :: BCond=(/'R','F'/)

  real(8), parameter  :: pi=3.1415926535897932385D0
  real(8), parameter  :: eps=1D-10

  integer :: l, i, j, n, ll

  call MessageNotify('M','wq_test_polvelbc', &
       'wq_module  wq_LaplaPol2polGrid_wq function tests')

  write( 6,* ) 
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

  call wq_initial(im,jm,km,nm,lm,ra)

  do l=1,2

     ! P_10
     xyr_Poloidal = sin(xyr_Lat) * xyr_Rad * ((xyr_Rad-ra)*(xyr_Rad+ra))**3
     xyr_LaplaPol = xyr_wq(wq_Lapla_wq(wq_xyr(xyr_Poloidal)))

     xyr_Poloidal0 = xyr_Poloidal
     wq_LaplaPol = wq_xyr(xyr_LaplaPol)
     wq_LaplaPol0 = wq_LaplaPol
     wq_Poloidal = wq_LaplaPol2Pol_wq(wq_LaplaPol,BCond(l),new=.true.)
     xyr_Poloidal = xyr_wq(wq_Poloidal)
     wq_LaplaPol = wq_Lapla_wq(wq_Poloidal)

     !---------------- å -----------------------
     wq_True = wq_LaplaPol - wq_LaplaPol0

     do n=1,(nm+1)**2
        do ll=0,lm-3
           if ( abs(wq_True(n,ll)) > eps ) then
              write(6,*) 'internal value. : ', n,ll,wq_True(n,ll)
              call MessageNotify('E','wq_test_polvelbc_tau',&
                   'internal value error too large')
           endif
        enddo
     enddo

     call MessageNotify('M','wq_test_polvelbc', &
                        'internal value test succeeded!')

     !--------- üå ----------

     !----- =0 at the top ---------
     do j=1,jm
        do i=0,im-1
           if ( abs(xyr_Poloidal(i,j,km)) > eps ) then
              write(6,*) 'Top B.C. : ', i,j,xyr_Poloidal(i,j,km)
              call MessageNotify('E','wq_test_polvelbc',&
                              '=0 Top B.C. error too large')
           endif
        enddo
     enddo

     !----- d/dr=0, d^2/dr^2 at the top ---------
     if( BCond(l)(1:1) == 'F' ) then
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_RadDRad_wq(wq_Poloidal))&
                                       -wq_RadDRad_wq(wq_Poloidal))/xyr_Rad**2
     else
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_Poloidal))/xyr_Rad
     endif
     do j=1,jm
        do i=0,im-1
           if ( abs(xyr_True(i,j,km)) > eps ) then
              write(6,*) 'Top B.C. : ', i,j,xyr_True(i,j,km)
              call MessageNotify('E','wq_test_polvelbc',&
                              BCond(l)//'-Top B.C. error too large')
           endif
        enddo
     enddo

     call MessageNotify('M','wq_test_polvelbc', &
                        BCond(l)//'-Top B.C. test succeeded!')
  end do

  write( 6,* ) 
  call MessageNotify('M','wq_test_polvelbc_tau', &
       'wq_module  wq_LaplaPol2polGrid_wq function tests succeeded!')


end program wq_test_polvelbc_tau
