!----------------------------------------------------------------------
!     Copyright (c) 2007 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wa_spectrum_module ƥȥץ :: ִؿΥƥ
!
!  2007/11/04  ݹ
!      2008/06/28  ʿ  ѹ
!
program wa_test_spectrum

  use dc_message, only : MessageNotify
  use wa_module
  implicit none

  integer, parameter :: im=16, jm=8, nm=10, km=2

  real(8), dimension((nm+1)**2,km)   ::  wa_data
  real(8), dimension(0:im-1,1:jm,km) ::  xya_data

  real(8), dimension(0:nm,-nm:nm,km) ::  nma_data
  real(8), dimension(0:nm,km)        ::  na_data
  real(8), dimension(km)             ::  a_data

  real(8), parameter            ::  eps = 1.0D-10

  real(8) :: error
  integer :: n,m

  call wa_Initial( nm, im, jm, km )

  call MessageNotify('M','wa_test_spectrum','wa_spectrum_module tests') 

  ! 2Y_1^0+3Y_2^1
  xya_data(:,:,1) = 2*sqrt(3.0D0)*sin(xy_Lat) &
                + 3*sqrt(2*5.0D0/6)*3.0*sin(xy_Lat)*cos(xy_Lat) * cos(xy_Lon)! 
  ! 3*Y_1^0 + 2Y_1^1 + 2Y_2^0 +Y_2^-2
  xya_data(:,:,2) = 3*sqrt(3.0D0)*sin(xy_Lat) & 
                + 2* sqrt(2*3.0D0/2)*cos(xy_Lat)*cos(xy_Lon) &
                + 2*sqrt(5.0D0)*(3.0/2*sin(xy_Lat)**2-1/2.0) &
                - sqrt(2*5.0D0/24)*3.0*cos(xy_Lat)**2*sin(2*xy_Lon)

  wa_data = wa_xya(xya_data)

  !--------- Energy spectrum ---------
  nma_data=wa_spectrum_VMiss

  do n=0,nm
     do m=-n,n
        nma_data(n,m,:) = 0.0D0
     enddo
  enddo

  nma_data(1,0,1) = 4.0D0 ;   nma_data(2,1,1) = 27.0D0
  nma_data(1,0,2) = 9.0D0  ; nma_data(1,1,2)  = 4.0D0
  nma_data(2,0,2) = 12.0D0 ; nma_data(2,-2,2) = 3.0D0

  error = maxval(abs(nma_EnergyFromStreamfunc_wa(wa_data)-nma_data))

  if ( error > eps ) then
     call MessageNotify('E','Test of nma_EnergyFromStreamFunc',&
                        'Energy error too large') 
  endif
  call MessageNotify('M','Test of nma_EnergyFromStreamFunc','Test succeeded!') 

  na_data = 0.0D0
  na_data(:,1) = 0.0D0
  na_data(1,1) = 4.0D0 ;   na_data(2,1) = 27.0D0
  na_data(1,2) = 13.0D0 ;   na_data(2,2) = 15.0D0

  error = maxval(abs(na_EnergyFromStreamfunc_wa(wa_data)-na_data))

  if ( error > eps ) then
     call MessageNotify('E','Test of na_EnergyFromStreamFunc',&
                        'Energy error too large') 
  endif
  call MessageNotify('M','Test of na_EnergyFromStreamFunc','Test succeeded!') 

  a_data = a_AvrLonLat_xya( 0.5*(xya_GradLon_wa(wa_data)**2+xya_GradLat_wa(wa_data)**2) )
  error = maxval(abs(sum(na_EnergyFromStreamfunc_wa(wa_data),1)-a_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of total energy',&
                        'total energy error too large') 
  endif
  call MessageNotify('M','Test of total energy','Test succeeded!') 

  !--------- Enstrophy spectrum ---------
  nma_data=wa_spectrum_VMiss
  do n=0,nm
     do m=-n,n
        nma_data(n,m,:) = 0.0
     enddo
  enddo

  nma_data(1,0,1) = 8.0D0 ;   nma_data(2,1,1) = 162.0D0

  nma_data(1,0,2) = 18.0D0 ; nma_data(1,1,2)  = 8.0D0
  nma_data(2,0,2) = 72.0D0 ; nma_data(2,-2,2) = 18.0D0

  error = maxval(abs(nma_EnstrophyFromStreamfunc_wa(wa_data)-nma_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of nma_EnstrophyFromStreamFunc',&
                        '2Y_1^0+3Y_2^1 Enstrophy error too large') 
  endif
  call MessageNotify('M','Test of nma_EnstrophyFromStreamFunc', &
       'Test of 2Y_1^0+3Y_2^1 succeeded!') 

  na_data = 0.0
  na_data(1,1) = 8.0D0  ;   na_data(2,1) = 162.0D0
  na_data(1,2) = 26.0D0 ;   na_data(2,2) = 90.0D0

  error = maxval(abs(na_EnstrophyFromStreamfunc_wa(wa_data)-na_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of na_EnstrophyFromStreamFunc',&
                        'Enstrophy error too large') 
  endif
  call MessageNotify('M','Test of na_EnstrophyFromStreamFunc','Test succeeded!') 

  a_data = a_AvrLonLat_xya( 0.5*(xya_wa(wa_Lapla_wa(wa_data))**2))
  error = maxval(abs(sum(na_EnstrophyFromStreamfunc_wa(wa_data),1)-a_data))
  if ( error > eps ) then
     call MessageNotify('E','Test of total enstrophy',&
                        'total enstrophy error too large') 
  endif
  call MessageNotify('M','Test of total enstrophy', 'Test succeeded!') 

  call MessageNotify('M','wa_test_spectrum', &
                     'wa_spectrum_module tests succeeded!') 

end program wa_test_spectrum
