!----------------------------------------------------------------------
!     Copyright (c) 2007 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  w_integrale_module ƥȥץ :: ʬʿѴؿΥƥ
!
!  2007/10/29  ݹ
!      2008/06/28  ʿ  ѹ
!
program w_test_integral

  use dc_message, only : MessageNotify
  use w_module
  implicit none

  integer, parameter :: im=128, jm=64, nm=42

  real(8), dimension(0:im-1,1:jm) ::  xy_data            ! δؿ
  real(8), dimension(0:im-1)      ::  x_idata            ! ʬʿѤ
  real(8), dimension(1:jm)        ::  y_idata            ! ʬʿѤ
  real(8)                         ::  idata              ! ʬʿѤ
  real(8), parameter              ::  eps = 1.0D-10
  real(8) :: pi

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','w_test_integral', &
                         'w_integral_module function tests') 

  call w_Initial( nm, im, jm )

  !---- ʬΥƥ ----
  xy_data = sin(xy_Lat)**2*(1-cos(xy_Lon)**2)

  idata = 2*pi/3       ! IntLonLat_xy
  if ( abs(IntLonLat_xy(xy_data)-idata) > eps ) then
     call MessageNotify('E','Test of IntLonLat_xy','Error too large') 
  endif
  call MessageNotify('M','Test of IntLonLat_xy', 'Test succeeded!') 

  y_idata = pi*sin(y_Lat)**2       ! y_IntLon_xy
  if ( maxval(abs(y_IntLon_xy(xy_data)-y_idata)) > eps ) then
     call MessageNotify('E','Test of y_IntLon_xy','Error too large') 
  endif
  call MessageNotify('M','Test of y_IntLon_xy','Test succeeded!') 

  if ( abs(IntLat_y(y_idata)-idata) > eps ) then
     call MessageNotify('E','Test of IntLat_y','Error too large') 
  endif
  call MessageNotify('M','Test of IntLat_y','Test succeeded!') 

  x_idata = 2.0D0/3*(1-cos(x_Lon)**2)       ! x_IntLat_xy
  if ( maxval(abs(x_IntLat_xy(xy_data)-x_idata)) > eps ) then
     call MessageNotify('E','Test of x_IntLat_xy','Error too large') 
  endif
  call MessageNotify('M','Test of x_Intat_xy','Test succeeded!') 

  if ( abs(IntLon_x(x_idata)-idata) > eps ) then
     call MessageNotify('E','Test of IntLon_x','Error too large') 
  endif
  call MessageNotify('M','Test of IntLon_x','Test succeeded!') 

  !---- ʿѤΥƥ ----
  xy_data = sin(xy_Lat)**2*(1-cos(xy_Lon)**2)

  idata = 1.0D0/6       ! AvrLonLat_xy
  if ( abs(AvrLonLat_xy(xy_data)-idata) > eps ) then
     call MessageNotify('E','Test of AvrLonLat_xy','Error too large') 
  endif
  call MessageNotify('M','Test of AvrLonLat_xy', 'Test succeeded!') 

  y_idata = 0.5*sin(y_Lat)**2       ! y_AvrLon_xy
  if ( maxval(abs(y_AvrLon_xy(xy_data)-y_idata)) > eps ) then
     call MessageNotify('E','Test of y_AvrLon_xy','Error too large') 
  endif
  call MessageNotify('M','Test of y_AvrLon_xy','Test succeeded!') 

  if ( abs(AvrLat_y(y_idata)-idata) > eps ) then
     call MessageNotify('E','Test of AvrLat_y','Error too large') 
  endif
  call MessageNotify('M','Test of AvrLat_y','Test succeeded!') 

  x_idata = 1.0D0/3*(1-cos(x_Lon)**2)       ! x_AvrLat_xy
  if ( maxval(abs(x_AvrLat_xy(xy_data)-x_idata)) > eps ) then
     call MessageNotify('E','Test of x_AvrLat_xy','Error too large') 
  endif
  call MessageNotify('M','Test of x_Avrat_xy','Test succeeded!') 

  if ( abs(AvrLon_x(x_idata)-idata) > eps ) then
     call MessageNotify('E','Test of AvrLon_x','Error too large') 
  endif
  call MessageNotify('M','Test of AvrLon_x','Test succeeded!') 


  call MessageNotify('M','w_test_integral', &
                         'w_integral_module function tests succeded!') 

end program w_test_integral
