!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  la_module ƥȥץ :: ѴؿΥƥ
!
!  2008/12/25  ݹ
!
program la_test_base

  use dc_message, only : MessageNotify
  use la_module
  implicit none

  integer, parameter :: jm=16, nm=10, km=3

  real(8), dimension(0:nm,km)  ::  la_data
  real(8), dimension(1:jm,km)  ::  ya_data
  real(8), parameter           ::  eps = 1.0D-10

  call MessageNotify('M','la_test_base', &
                         'la_module basic functions tests') 

  call la_Initial( nm, jm )

  !---- P_* Υƥ ----
  la_data= 0.0D0 
  ya_data(:,1) = sqrt(3.0D0)*sin(y_Lat)                   ! P_1
  la_data(1,1)=1.0D0
  ya_data(:,2) = sqrt(5.0D0)*(3.0/2*sin(y_Lat)**2-1/2.0)  ! P_2
  la_data(2,2)=1.0D0
  ya_data(:,3) = sqrt(7.0D0)*(5.0/2*sin(y_Lat)**3-3/2.0*sin(y_Lat))  ! P_3
  la_data(3,3)=1.0D0

  if ( maxval(abs(la_ya(ya_data)-la_data)) > eps ) then
     call MessageNotify('E','Test of P_*','Spectral transform error too large') 
  endif
  if ( maxval(abs(ya_la(la_ya(ya_data))-ya_data)) > eps ) then
     call MessageNotify('E','Test of P_*',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of P_*','Test of P_* succeeded!') 

  !---- ŪؿΥƥ ----
  ya_data(:,1) = (sin(y_Lat)-1)**2*(sin(y_Lat)-0.5)*(sin(y_Lat)+1)
  ya_data(:,2) = (sin(y_Lat)-1)**2*(sin(y_Lat)+1)**2
  ya_data(:,3) = (sin(y_Lat)-1)*(sin(y_Lat)-0.5)**2*(sin(y_Lat)+1)

  if ( maxval(abs(ya_la(la_ya(ya_data))-ya_data)) > eps ) then
     write(6,*) maxval(abs(ya_la(la_ya(ya_data))-ya_data))
     call MessageNotify('E','Test of general function',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of genral function', &
       'Test of general function succeeded!') 

  call MessageNotify('M','la_test_base', &
                         'la_module basic functions tests succeeded!') 

end program la_test_base
