!--
!----------------------------------------------------------------------
!     Copyright (c) 2001-2009 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ae_module
!
!      spml/ae_module ⥸塼 1 βǤήαư
!      ¥աꥨѴˤ륹ڥȥˡǿͷ׻뤿 Fortran90 ؿ
!      󶡤.
!
!      2 ǡ 1 ˴ؤƱ˥ڥȥ׻¹Ԥ뤿
!      ؿ󶡤Ƥ, 2, 3 ΰǤη׻Υ١󶡤.
!
!      Υ⥸塼 ISPACK/FTPACK  Fortran77 ֥롼
!      ƤǤ.
!
!      ڥȥǡγǼˡˤĤƤ ISPACK/FTPACK ȰۤʤäƤ
!      ΤǰʲΥȤդ줿. 
!
!
!  2002/01/25  ݹ  ISPACK/ftrpack  Fortran 90 
!      2002/02/06  ݹ  ŤƳ. ̥󥿡եʤ.
!                            η˱󥿡ե̾
!      2002/03/25  ݹ  ⥸塼̾ѹ
!      2002/08/20  ݹ  ʬʿѴؿɲ
!      2005/01/09  ݹ  msgdmp -> MessageNotify ѹ
!      2005/01/10  ݹ  顼å
!      2006/03/04  ݹ  Ȥ RDoc Ѥ˽
!      2006/03/19  ݹ  ѿ³򥳥Ȥɲ
!      2007/10/09  ʿ ae_Initial  g_X(ii)ϰϤ
!      2009/01/07  ݹ  佼
!      2009/01/09  ݹ  ae_Initial åդɲ
!      2009/01/23  ʿ rdoc Ѥ˥ɥȤ
!
!++
module ae_module
  !
  != ae_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: ae_module.f90,v 1.16 2009-02-28 21:33:45 uwabami Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/ae_module ⥸塼 1 βǤήαư
  ! աꥨѴˤ륹ڥȥˡǿͷ׻뤿 Fortran90 ؿ
  ! 󶡤.
  !
  ! 2 ǡ 1 ˴ؤƱ˥ڥȥ׻¹Ԥ뤿
  ! ؿ󶡤Ƥ, 2, 3 ΰǤη׻Υ١󶡤.
  !
  ! Υ⥸塼 ISPACK/FTPACK  Fortran77 ֥롼
  ! Ǥ. ڥȥǡγǼˡˤĤƤ ISPACK/FTPACK Ȱۤʤ
  ! ƤΤǰʲΥȤդ줿.
  !
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (e_, g_, ae_, ag_) , ֤ͤη򼨤Ƥ.
  !   e_  :: ڥȥǡ,
  !   g_  :: 1 ʻǡ,
  !   ae_ :: 1 ڥȥǡʣ¤ 2 ǡ,
  !   ag_ :: 1 ʻǡʣ¤ 2 ǡ.
  !
  ! * ؿ̾δ֤ʸ(Dx), δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_e, _ae, _g, _ag) , ѿηڥȥǡ
  !   ʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _e  :: ڥȥǡ
  !   _g  :: 1 ʻǡ
  !   _ae :: 1 ڥȥǡʣ¤ 2 ǡ
  !   _ag :: 1 ʻǡʣ¤ 2 ǡ
  !
  !=== ƥǡμ
  !
  ! * g : 1 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:im-1).
  !   * im  X ɸγʻǤ, ֥롼 ae_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * e : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-km:km).
  !   * km  X κȿǤ, ֥롼 ae_Initial ˤ
  !     餫ꤷƤ. 
  !   * ڥȥǡγǼΤ 0:km ޤǤ cos(kx) η, 
  !     -km:-1  sin(kx) ηȤʤäƤ.
  !
  ! * ag : 1 (X)ʻǡ¤ 2 ǡ.
  !   * ѿμȼ real(8), dimension(:,0:im-1).
  !      2  X ɽ.
  !
  ! * ae : 1 ڥȥǡ¤ 2 ǡ.
  !   * ѿμȼ real(8), dimension(:,-km:km).
  !      2 ڥȥɽ.
  !
  ! * g_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * e_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * ag_ ǻϤޤؿ֤ͤ 1 ʻǡ¤
  !   2 ǡƱ.
  !
  ! * ae_ ǻϤޤؿ֤ͤ 1 ڥȥǡ¤
  !   2 ǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤΤȤǤ.
  !
  !== ѿ³
  !
  !==== 
  !
  ! ae_Initial       :: ڥȥѴγʻ, ȿ, ΰ礭
  !
  !==== ɸѿ
  !
  ! g_X              :: ʻɸ(X)Ǽ 1 
  ! g_X_Weight       :: ŤߺɸǼ 1 
  !
  !==== Ѵ
  !
  ! g_e, ag_ae       :: ڥȥǡʻҥǡؤѴ
  ! e_g, ae_ag       :: ʻҥǡ饹ڥȥǡؤѴ
  !
  !==== ʬ
  !
  ! e_Dx_e, ae_Dx_ae :: ڥȥǡ X ʬѤ
  !
  !==== ʬʿ
  !
  ! a_Int_ag, a_Avr_ag :: 1 ʻǡ¤ 2 ʬʿ
  ! Int_g, Avr_g       :: 1 ʻǡʬʿ
  !
  !
  use dc_message
  implicit none

  private
  public ae_Initial                       ! 롼
  public ag_ae, ae_ag, g_e, e_g           ! Ѵ
  public ae_Dx_ae, e_Dx_e                 ! ʬ
  public a_Int_ag, Int_g, a_Avr_ag, Avr_g ! ʬʿ
  public g_X, g_X_Weight                  ! ɸѿ

  integer            :: im=32             ! ʻο
  integer            :: km=10             ! ȿ
  double precision   :: xl=1.0            ! ΰ礭

  integer, dimension(5)              :: iti
  real(8), dimension(:),allocatable  :: ti
  real(8), parameter                 :: pi=3.1415926535897932385D0

  real(8), allocatable :: g_x(:)         ! ʻɸ(X)Ǽ 1 .
  real(8), allocatable :: g_x_weight(:)  ! ŤߺɸǼ 1 .
                                         ! X γʻδֳ֤ǼƤ.

  save im, km, iti, ti, xl, g_X, g_X_Weight

  contains
  !---------------  -----------------
    subroutine ae_Initial(i,k,xmin,xmax)
      !
      ! ڥȥѴγʻ, ȿ, ΰ礭ꤹ.
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      integer,intent(in) :: i              ! ʻο
      integer,intent(in) :: k              ! ȿ
      real(8),intent(in) :: xmin, xmax     ! X ɸϰ

      integer :: ii

      im = i
      km = k
      xl = xmax-xmin

      if ( im <= 0 .or. km <= 0 ) then
         call MessageNotify('E','ae_Initial', &
              'Number of grid points and waves should be positive')
      elseif ( mod(im,2) /= 0 ) then
         call MessageNotify('E','ae_Initial', &
              'Number of grid points should be even')
      elseif ( km >= im/2 ) then
         call MessageNotify('E','ae_Initial', &
              'KM shoud be less than IM/2')
      endif

      allocate(ti(im*2))

      call fttrui(im,iti,ti)

      allocate(g_x(0:im-1))
      do ii=0,im-1
         g_X(ii) = xmin + xl/im*ii
      enddo

      allocate(g_x_weight(0:im-1))
      g_X_Weight = xl/im

      call MessageNotify(&
        'M','ae_initial','ae_module (2009/01/09) is initialized')

    end subroutine ae_Initial

  !--------------- Ѵ -----------------

    function ag_ae(ae)
      !
      ! ڥȥǡʻǡѴ(2 ǡ)
      !
      real(8), dimension(:,-km:), intent(in)  :: ae     !(in)  ڥȥǡ
      real(8), dimension(size(ae,1),0:im-1)   :: ag_ae  !(out) ʻǡ

      real(8), dimension(size(ae,1)*im)       :: y
      integer :: m, k

      m=size(ae,1)
      if ( size(ae,2) < 2*km+1 ) then
         call MessageNotify('E','ag_ae', &
              'The Fourier dimension of input data too small.')
      elseif ( size(ae,2) > 2*km+1 ) then
         call MessageNotify('W','ag_ae', &
              'The Fourier dimension of input data too large.')
      endif

      ag_ae = 0.0D0
      ag_ae(:,0)=ae(:,0)
      ag_ae(:,1)=0
      do k=1,km
         ag_ae(:,2*k)=ae(:,k)
         ag_ae(:,2*k+1)=ae(:,-k)
      enddo
      ag_ae(:,2*km+2:im-1)=0

      call fttrub(m,im,ag_ae,y,iti,ti)
    end function ag_ae

    function g_e(e)
      !
      ! ڥȥǡʻǡѴ(1 ǡ)
      !
      real(8), dimension(0:im-1)             :: g_e  !(out) ʻǡ
      real(8), dimension(-km:km), intent(in) :: e    !(in)  ڥȥǡ

      real(8), dimension(1,size(e))  :: ae_work
      real(8), dimension(1,0:im-1)   :: ag_work

      ae_work(1,:) = e
      ag_work = ag_ae(ae_work)
      g_e = ag_work(1,:)

    end function g_e

    function ae_ag(ag)
      !
      ! ʻǡ饹ڥȥǡѴ(2 ǡ)
      !
      real(8), dimension(:,:), intent(in)     :: ag     !(in)  ʻǡ
      real(8), dimension(size(ag,1),-km:km)   :: ae_ag  !(out) ڥȥǡ

      real(8), dimension(size(ag,1)*im)     :: y
      real(8), dimension(size(ag,1),0:im-1) :: ag_work
      integer :: m, k

      m = size(ag,1)
      if ( size(ag,2) < im ) then
         call MessageNotify('E','ae_ag', &
              'The Grid points of input data too small.')
      elseif ( size(ag,2) > im ) then
         call MessageNotify('W','ae_ag', &
              'The Grid points of input data too large.')
      endif
      ag_work = ag

      call fttruf(m,im,ag_work,y,iti,ti)

      do k=1,km
         ae_ag(:,k) = ag_work(:,2*k)
         ae_ag(:,-k) = ag_work(:,2*k+1)
      enddo
      ae_ag(:,0) = ag_work(:,0)

    end function ae_ag

    function e_g(g)
      !
      ! ʻǡ饹ڥȥǡѴ(1 ǡ)
      !
      real(8), dimension(-km:km)              :: e_g   !(out) ڥȥǡ
      real(8), dimension(0:im-1), intent(in)  :: g     !(in)  ʻǡ

      real(8), dimension(1,size(g))        :: ag_work
      real(8), dimension(1,-km:km)         :: ae_work

      ag_work(1,:) = g
      ae_work = ae_ag(ag_work)
      e_g = ae_work(1,:)

    end function e_g

  !--------------- ʬ׻ -----------------
    function ae_Dx_ae(ae)
      !
      ! ϥڥȥǡ X ʬѤ(2 ǡ).
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      !
      real(8), dimension(:,-km:), intent(in)  :: ae
                                         !(in)  ϥڥȥǡ
      real(8), dimension(size(ae,1),-km:km)   :: ae_dx_ae
                                         !(out) ϥڥȥǡ X ʬ

      integer k

      if ( size(ae,2) < 2*km+1 ) then
         call MessageNotify('W','ae_Dx_ae', &
              'The Fourier dimension of input data too small.')
      elseif ( size(ae,2) > 2*km+1 ) then
         call MessageNotify('W','ae_Dx_ae', &
              'The Fourier dimension of input data too large.')
      endif

      do k=-km,km
         ae_Dx_ae(:,k) = -(2*pi*k/xl)*ae(:,-k)
      enddo
    end function ae_dx_ae

    function e_Dx_e(e)
      !
      ! ϥڥȥǡ X ʬѤ(1 ǡ).
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      !
      real(8), dimension(-km:km), intent(in)     :: e
                                         !(in)  ϥڥȥǡ
      real(8), dimension(-km:km)                 :: e_Dx_e
                                         !(out) ϥڥȥǡ X ʬ

      real(8), dimension(1,-km:km)               :: ae_work

      ae_work(1,:) = e
      ae_work = ae_Dx_ae(ae_work)
      e_Dx_e = ae_work(1,:)

    end function e_Dx_e

  !--------------- ʬ׻ -----------------
    function a_Int_ag(ag)
      !
      ! 1 ʻǡ¤ 2 ʬ
      !
      real(8), dimension(:,0:), intent(in)     :: ag        !(in) ʻǡ
      real(8), dimension(size(ag,1))           :: a_Int_ag  !(out) ʬ
      integer :: i

      if ( size(ag,2) < im ) then
         call MessageNotify('E','ae_Int_ag', &
              'The Grid points of input data too small.')
      elseif ( size(ag,2) > im ) then
         call MessageNotify('W','ae_Int_ag', &
              'The Grid points of input data too large.')
      endif

      a_Int_ag = 0.0d0
      do i=0,im-1
         a_Int_ag(:) = a_Int_ag(:) + ag(:,i)*g_X_Weight(i)
      enddo
    end function a_Int_ag

    function Int_g(g)
      !
      ! 1 ʻǡʬ
      !
      real(8), dimension(0:im-1), intent(in)   :: g      !(in) ʻǡ
      real(8)                                  :: Int_g  !(out) ʬ

      Int_g = sum(g*g_X_Weight)

    end function Int_g

    function a_Avr_ag(ag)
      !
      ! 1 ʻǡ¤ 2 ʿ
      !
      real(8), dimension(:,0:), intent(in)     :: ag        !(in) ʻǡ
      real(8), dimension(size(ag,1))           :: a_Avr_ag  !(out) ʿѷ

      a_Avr_ag = a_Int_ag(ag)/sum(g_X_Weight)

    end function a_Avr_ag

    function Avr_g(g)
      !
      ! 1 ʻǡʿ
      !
      real(8), dimension(0:im-1), intent(in)   :: g
      real(8)                                  :: Avr_g

      Avr_g = Int_g(g)/sum(g_X_Weight)

    end function Avr_g

  end module ae_module
