!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!  wq_RadRot_xyz_xyz, wq_RadRotRot_xyz_xyz_xyz  Υƥ
!    r(xv), r(xxv)
!
!  2008/01/02  ݹ
!      2008/07/05  ʿ  ѹ
!  
program wq_test_derivative5

  use dc_message, only : MessageNotify
  use wq_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=8   ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.5               ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)     :: xyr_VLon
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_VLat
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_VRad
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_Data
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RadRot
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_RadRotRot
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_Torvel
  real(8), dimension(0:im-1,1:jm,km)     :: xyr_Polvel

  real(8), parameter :: eps = 1D-8

  integer :: i,j,k

  call MessageNotify('M','wq_test_derivative5', &
       'wq_module derivative function test #5')

  write( 6,* ) 'Test for wr_RadRot_xyr_xyr, wr_RadRotRot_xyr_xyr_xyr'
  write( 6,* ) 'Output is displayed if computational error is larger than',eps

  call wq_initial(im,jm,km,nm,lm,ra)

  xyr_VLon = 0.0D0 ; xyr_VLat = 0.0D0 ; xyr_VRad = xyr_Rad
  xyr_RadRot = 0.0D0 ; xyr_RadRotRot = 0.0D0
  write(6,*)
  write(6,*)'Simple example (v_r=r)'
  call checkresult

! βž(ή)

  xyr_VLon = 0.0D0
  xyr_VLat = xyr_Rad*sin(xyr_Lat)*cos(xyr_Lat)
  xyr_VRad = -xyr_Rad*cos(xyr_Lat)**2
  xyr_RadRot = 0.0D0 ; xyr_RadRotRot = 0.0D0
  write(6,*)
  write(6,*)'Rigid Rotation '
  call checkresult

! βž(ή)
  xyr_VLon = xyr_Rad*cos(xyr_Lat)*sin(xyr_Lon)*cos(xyr_Lon)
  xyr_VLat = -xyr_Rad*sin(xyr_Lat)*cos(xyr_Lat)*sin(xyr_Lon)**2
  xyr_VRad = -xyr_Rad*(sin(xyr_Lat)**2*sin(xyr_Lon)**2 + cos(xyr_Lon)**2)
  xyr_RadRot = 0.0D0 ; xyr_RadRotRot = 0.0D0

  write(6,*)
  write(6,*)'Rigid Rotation'
  call checkresult

! ľ٤ȼ٥ȥ
  xyr_Polvel = xyr_Rad**2 * cos(xyr_Lat)*sin(xyr_Lon)   ! r**2 P_1^1
  !xyr_Psi = xyr_Rad**3 * cos(xyr_Lat)*sin(xyr_Lat)*sin(xyr_Lon)   ! r**3 P_2^1

  xyr_VLon =   xyr_GradLat_wq(wq_xyr(xyr_Polvel*xyr_Rad))
  xyr_VLat = - xyr_GradLon_wq(wq_xyr(xyr_Polvel*xyr_Rad))
  xyr_VRad = 0.0D0
  xyr_RadRot = 2 * xyr_Polvel                       ! rߢ(r) = L_2
  !xyr_RadRot = 6 * xyr_Polvel                      ! rߢ(r) = L_2
  xyr_RadRotRot = 0.0D0

  write(6,*)
  write(6,*)'Vortical field'
  call checkresult

! ľ®٤ȼ٥ȥ
  xyr_Torvel = 0.0D0
  xyr_Polvel = xyr_Rad**3 * cos(xyr_Lat)*sin(xyr_Lon)   ! r**2 P_1^1
  call wq_Potential2Vector(&
         xyr_VLon,xyr_VLat,xyr_VRad, wq_xyr(xyr_Torvel),wq_xyr(xyr_Polvel) )

!!$  xyr_VRad = xyr_wq(wq_L2_wq(wq_xyr(xyr_Psi/xyr_Rad)))
!!$  xyr_VLat = xyr_GradLat_wq(wq_wr(wr_DRad_wq(wq_xyr(xyr_Psi*xyr_Rad))))
!!$  xyr_VLon = xyr_GradLon_wq(wq_wr(wr_DRad_wq(wq_xyr(xyr_Psi*xyr_Rad))))

  xyr_RadRot = 0.0D0
  xyr_RadRotRot = -xyr_wq(wq_L2_wq(wq_Lapla_wq(wq_xyr(xyr_Polvel))))
                 ! rߢߢߢ(r) = -L_2^2
!!$  xyr_RadRotRot = -8 * cos(xyr_Lat)*sin(xyr_Lon)

  write(6,*)
  write(6,*)'Non-Vortical field'
  call checkresult

  call MessageNotify('M','wq_test_derivative5', &
       'wq_module derivative function test #5 succeeded!')

  stop
contains

  subroutine checkresult
    write(6,*)'Checking r Rot v...'

    xyr_Data = xyr_wr(wr_RadRot_xyr_xyr(xyr_VLon,xyr_VLat))

    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_Data(i,j,k)-xyr_RadRot(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_Data(i,j,k), xyr_RadRot(i,j,k)
                call MessageNotify('E','wq_test_derivative5', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do

    xyr_Data = xyr_wr(wr_RadRotRot_xyr_xyr_xyr(xyr_VLon,xyr_VLat,xyr_VRad))

    write(6,*)'Checking r Rot Rot v...'
    do k=1,km
       do j=1,jm
          do i=0,im-1
             if ( abs(xyr_Data(i,j,k)-xyr_RadRotRot(i,j,k)) > eps ) then
                write(6,*) i,j,k, xyr_Data(i,j,k), xyr_RadRotRot(i,j,k)
                call MessageNotify('E','wq_test_derivative5', &
                     'Derivative error too large.')
             endif
          end do
       end do
    end do
  end subroutine checkresult

end program wq_test_derivative5
