!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_module ƥȥץ
!
!  2002/08/20  ݹ
!      2007/10/24  ݹ  顼åɲ
!
program at_intavr

  use dc_message, only : MessageNotify
  use at_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32            ! ʻ
  integer, parameter :: km=32,lm=2        ! ȿ

 !---- ѿ ----
  real(8)            :: g_Data(0:im)     ! ʻҥǡ
  real(8)            :: ag_Data(lm,0:im)    ! ʻҥǡ

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  real(8), parameter :: eps = 1.0d-8            ! Ƚ
  integer :: i

 !---------------- ɸͤ ---------------------

do i=1,2
  call at_Initial(im,km/i,xmin,xmax)               ! ڥȥ

 !-------------------  ----------------------
  write(6,*)'+++++ Test of Int_g, Avr_g +++++'

  g_Data = 1 - sin(2*pi*g_X)
  write(6,*) 'f = 1-sin(2*pi*X)'

    call check0d(Int_g(g_Data) - 2.0d0, eps, 'Int_g')
    call check0d(Avr_g(g_Data) - 1.0d0, eps, 'Avr_g')

  call MessageNotify('M','Test of Int_g, Avr_g', &
       'Test of Int_g, Avr_g suceeded!')

  write(6,*)
  write(6,*)'+++++ Test of a_Int_ag, a_Avr_ag +++++'
  ag_Data(1,:) = cos(pi*g_X)**2
  ag_Data(2,:) = sin(pi*g_X)**2
  write(6,*) 'f = cos(pi*X)**2, sin(pi*X)**2'

    call check1d(a_Int_ag(ag_Data) - (/1.0,1.0/), eps, 'a_Int_ag')
    call check1d(a_Avr_ag(ag_Data) - (/0.5,0.5/), eps, 'a_Avr_ag')

  call MessageNotify('M','Test of a_Int_ag, a_Avr_ag', &
       'Test of a_Int_ag, a_Avr_ag suceeded!')

end do
stop
contains

  subroutine check1d(var,eps,funcname) ! ͤ eps ʾ var Ǥ
    real(8) :: var(:)                  ! Ƚꤹ
    real(8) :: eps                     ! 
    character(len=*), optional :: funcname
    integer i

    if ( present(funcname) )then
       write(6,*) '  Checking ', funcname, '...'
    endif

    do i=1,size(var)
       if (abs(var(i)) .gt. eps ) then
          write(6,*) '    Value larger than EPS : i= ', i, var(i)
          call MessageNotify('E','Test of'//funcname, 'Error too large.')
       endif
    enddo
  end subroutine check1d

  subroutine check0d(var,eps,funcname)   ! var ͤ eps ʾȽ
    real(8) :: var                       ! Ƚꤹ
    real(8) :: eps                       ! 
    real(8) :: vartmp(1)                 ! 
    character(len=*), optional :: funcname

    vartmp(1) = var
    if ( present(funcname) ) then
       call check1d(vartmp,eps,funcname)
    else
       call check1d(vartmp,eps)
    endif
  end subroutine check0d

end program at_intavr
