!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  au_module ƥȥץ
!
!  2008/04/01  ݹ
!      2008/07/07  ʿ ϰϤ
!      2008/08/13  ݹ aq_r2_aq ƥɲ
!      
!
program aq_test_base2d

  use dc_message, only : MessageNotify
  use aq_module
  implicit none

  integer, parameter :: im=16, km=31         ! ʻ, ȿ
  real(8), parameter :: ra=2                 ! ΰ礭

  real(8), parameter :: alpha=1.0D0        ! Ÿ¿༰ѥ᥿  0 <  <= 1
  real(8), parameter :: beta= 1.0D0        ! Ÿ¿༰ѥ᥿  0 < 
  integer :: md(2)=(/2,3/)   

  real(8), parameter :: eps=5.0D-8

  real(8), dimension(2,im) :: ag_data
  real(8), dimension(2,im) :: ag_data_orig
  real(8), dimension(2,im) :: ag_data_deriv
  real(8), dimension(2,im) :: ag_data_r2
  real(8), dimension(2,im) :: ag_data_r2Inv

  integer :: i, m

  write(6,*)'++++++ Testing basic functions aq_ag, ag_aq, aq_rDr_aq, aq_r2_aq, aq_r2Inv_aq +++++'

  call aq_Initial(im,km,ra,alpha,beta,md)

  ag_data(1,:) = g_R**6
  ag_data(2,:) = g_R**5

  ag_data_deriv(1,:) = 6*g_R**6
  ag_data_deriv(2,:) = 5*g_R**5

  ag_data_r2(1,:) = g_R**8
  ag_data_r2(2,:) = g_R**7

  ag_data_r2Inv(1,:) = g_R**4
  ag_data_r2Inv(2,:) = g_R**3

  ag_data_orig = ag_data
  ag_data = ag_aq(aq_ag(ag_data))

  write(6,*) 'Test of aq_ag, ag_aq'
  write(6,*) 'wrong values are displayed below...'
  do m=1,2
     do i=1,im
        if ( abs(ag_data(m,i)-ag_data_orig(m,i)) .gt. eps ) then
           write(6,*) m,i, ag_data(m,i), ag_data_orig(m,i), &
                ag_data(m,i)-ag_data_orig(m,i)
           call MessageNotify('E','aq_test_base2d', &
                'Transformation error too large.')
        endif
     enddo
  enddo
  
  write(6,*) 'Test of aq_rDr_aq'
  ag_data = ag_aq(aq_rDr_aq(aq_ag(ag_data_orig)))
  write(6,*) 'wrong values are displayed below...'
  do m=1,2
     do i=1,im
        if ( abs(ag_data(m,i)-ag_data_deriv(m,i)) .gt. eps ) then
           write(6,*) m,i, ag_data(m,i), ag_data_deriv(m,i), &
                ag_data(m,i)-ag_data_deriv(m,i)
           call MessageNotify('E','aq_test_base2d', &
                'Differentiation error ag_Dr_au too large.')
        endif
     enddo
  enddo

  write(6,*) 'Test of aq_r2_aq'
  ag_data = ag_aq(aq_r2_aq(aq_ag(ag_data_orig)))
  write(6,*) 'wrong values are displayed below...'
  do m=1,2
     do i=1,im
        if ( abs(ag_data(m,i)-ag_data_r2(m,i)) .gt. eps ) then
           write(6,*) m,i, ag_data(m,i), ag_data_r2(m,i), &
                ag_data(m,i)-ag_data_r2(m,i)
           call MessageNotify('E','aq_test_base2d', &
                'Differentiation error ag_r2_au too large.')
        endif
     enddo
  enddo

  write(6,*) 'Test of aq_r2Inv_aq'
  ag_data = ag_aq(aq_r2Inv_aq(aq_ag(ag_data_orig)))
  write(6,*) 'wrong values are displayed below...'
  do m=1,2
     do i=1,im
        if ( abs(ag_data(m,i)-ag_data_r2Inv(m,i)) .gt. eps ) then
           write(6,*) m,i, ag_data(m,i), ag_data_r2Inv(m,i), &
                ag_data(m,i)-ag_data_r2Inv(m,i)
           call MessageNotify('E','aq_test_base2d', &
                'Differentiation error ag_r2Inv_au too large.')
        endif
     enddo
  enddo

  call MessageNotify('M','aq_test_base2d', &
       'Tests of basic functions ag_aq, aq_ag, aq_rDr_aq suceeded!')

end program aq_test_base2d

