!-----------------------------------------------------------------------
!   Laplace's equation: Successive overrelaxation(SOR) method
!         Johnson and Riess, 1982: "Numerical Analysis(2nd edition)",
!                     Addison-Wesley Publishing Company, p.472
!
!   coded by Shigeo Yoden on Sept. 13, 2000
!-----------------------------------------------------------------------
program laplace_sor

  use dcl        ! DCL Fortran90 (dcl-5.1/dcl-f90)

  integer, parameter :: imax=20
  real,    parameter :: pi=3.141593, dx=pi/imax
  real, dimension(0:imax,0:imax) :: vold, vnew, van
  character :: ct*30, cl*30, csgi*1

!--  &  ----
    do i=0, imax
      vold(i,imax) = sin(i*dx)
    end do
    do j=0, imax-1
      vold(:,j) = j*dx*vold(:,imax)
    end do
    vold(imax,:) = 0

    vnew = vold
   
!!!    write(*,*) 'epsilon=?'
!!!    read (*,*)  epsilon
    epsilon  = 0.001
    test = 2*epsilon
    lmn  = 0

!-- SOR ----
    omega = 2/(1 + sin(dx))

! execute SOR iteration and calculate TEST where
! TEST is the maximum component of (vnew - vold)
    do while(test > epsilon)      ! convergence check
       test = 0.
       do j=1, imax-1
         do i=1, imax-1
           vnew(i,j) = vold(i,j) + omega*(vnew(i-1,j) + vnew(i,j-1)  &
                          + vold(i+1,j) + vold(i,j+1) -4*vold(i,j))/4
           diff = abs(vnew(i,j)-vold(i,j))
           if(diff > test) test = diff
         end do
       end do
       vold = vnew
       lmn = lmn + 1
    end do

    write(*,*) 'iteration # = ', lmn, '  DIFmax = ', test

!-- ϲ ----
    do j=0, imax
      do i=0, imax
           van(i,j) = sinh(j*dx)*sin(i*dx) /sinh(pi)
      end do
    end do
    van(imax,:) = 0

!-- ղ ----
    call DclOpenGraphics()
    call DclNewFrame

    call DclSetWindow  (0.0, 1.0, 0.0, 1.0)
    call DclSetViewPort(0.2, 0.8, 0.2, 0.8)
    call DclSetTransFunction

    call DclSetTitle('x', 'y', csgi(194)//' '//csgi(167),  &
                               csgi(194)//' '//csgi(167))
    call DclDrawScaledAxis

    call DclSetParm('ENABLE_CONTOUR_MESSAGE', .false.)
    call DclSetParm('ENABLE_NEGATIVE_CONTOUR', .false.)
    call DclDrawContour(van)           ! ϲ()
    call DclSetParm('POSITIVE_CONTOUR_TYPE', 3)
    call DclDrawContour(vnew)          ! Ͳ()

      ct = 'iteration # =?????'
      write(ct(14:18),'(i5)') lmn
    call DclDrawTitle('t', ct, position=-1.)
      cl = '=??.??E???s'
      write(cl(2:10),'(e9.2)') epsilon
      ct = csgi(156) // cl  
    call DclDrawTitle('t', ct, position=-0.8)
    call DclDrawTitle('t', ' SOR method', position=-1.)
    call DclDrawTitle('t', 'Laplace'//csgi(178)//'s Equation:',  &
                                          position=-1.)
    call DclCloseGraphics
end program laplace_sor
