!----------------------------------------------------------------------
!   4-th Order Runge-Kutta method: Satellite Orbit
!
!   coded by Shigeo Yoden on Sept. 12, 2000
!----------------------------------------------------------------------
program rk02

  use dcl        ! DCL Fortran90 (dcl-5.1/dcl-f90)

  integer, parameter :: mmax=2000
  real, parameter :: tmax=16.
  real, dimension(0:mmax) :: t, x, y, u, v 
  real, dimension(4) :: z, dz1, dz2, dz3, dz4
  character :: ct*30

!!!    write(*,*) 'dt=?'
!!!    read (*,*)  dt
    dt = 0.05

    nmax = tmax/dt
    if(nmax > mmax) stop 'error: dt must have a larger value'

!--  ----
    t(0)=0
    x(0)=3  ;  z(1)=x(0)
    y(0)=0  ;  z(2)=y(0)
    u(0)=0.3;  z(3)=u(0)
    v(0)=0.2;  z(4)=v(0)

!-- ʬ ----
    do n=0, nmax-1
      call drv(z      , dz1)
      call drv(z+dz1/2, dz2)
      call drv(z+dz2/2, dz3)
      call drv(z+dz3  , dz4)
      z = z + (dz1 + 2*(dz2 + dz3) + dz4) / 6
      t(n+1) = t(n) + dt
      x(n+1) = z(1);  y(n+1) = z(2)
      u(n+1) = z(3);  v(n+1) = z(4)
    end do

!-- ղ ----
    call DclOpenGraphics()
    call graph
    call DclCloseGraphics

!-- ³ ----
  contains
    subroutine drv(z, dz)         ! ʬ׻֥롼
      real, dimension(4) :: z, dz

      fxy = z(1)**2 + z(2)**2
      fxy = sqrt( fxy**3 )
      dz(1) = z(3)       *dt
      dz(2) = z(4)       *dt
      dz(3) = - z(1)/fxy *dt
      dz(4) = - z(2)/fxy *dt
    end subroutine drv

    subroutine graph              ! դ֥롼
      call DclNewFrame
      
      call DclSetTitle('x', 'y')
      call DclScalingPoint   (y(0:nmax), x(0:nmax)) ! ļȲϰϤƱ
      call DclDrawScaledGraph(x(0:nmax), y(0:nmax))
      call DclDrawMarker(x(0:0), y(0:0), type=230)

        ct = 'dt=xx.xxExxx'
        write(ct(4:12),'(e9.2)') dt
      call DclDrawTitle('T', ct, position=-0.8)
      call DclDrawTitle('T', 'Satellite Orbit(RK-4)', position=-1.)
    end subroutine graph
end program rk02
