********************************************************************************
* ɽ ϵήϳ ׻¸
*
*      ǥǥ (Lorenz, 1993; the sled model)
*     
*
*  99/06/17 ߷ 
*      99/06/19 ; 
********************************************************************************
      program lski2

      parameter(xmin=0.0,xmax=40.,ymin=-20.,ymax=20.)
      parameter(nmax=50,mmax=20)
      parameter(ntimax=100,ntjmax=100)
      parameter(dt=0.2,istep=1)

      real x(0:nmax,mmax),y(0:nmax,mmax),z(0:nmax,mmax)
      real u(0:nmax,mmax),v(0:nmax,mmax),w(0:nmax,mmax)
      real tz(ntimax,ntjmax)
      real xx(6),work(6,3)
      integer icolor(mmax)
      character ctime*10,cdammy*60

      common /const/g,a,b,rk,rl
      external fcn,odrkg
*-----+--1---------2---------3---------4---------5---------6---------7-+
*- ѥ᡼
      g  = 9.8
      pi = atan(1.)*4

      a = 0.25
      b = 0.5
      rk = pi*0.2   ! parameter p in Lorenz(1993)
      rl = pi*0.5

      itopo =  0
      mnum  = 20
      y0min = 0.
      dy    = 0.01
      u0    = 4.
      v0    = 2.

      if(mnum .gt. mmax) stop 'mnum must be less than mmax(20)'

*- 
      do m=1,mnum
        x(0,m) = 0.0
        y(0,m) = y0min + (m-1)*dy
        z(0,m) = - a*x(0,m) - b*cos(x(0,m)*rk) *cos(y(0,m)*rl)
        u(0,m) = u0
        v(0,m) = v0
        w(0,m) = u(0,m)*(-a + b*sin(x(0,m)*rk) *cos(y(0,m)*rl) )
     &         + v(0,m)*(   + b*cos(x(0,m)*rk) *sin(y(0,m)*rl) )
        icolor(m) = 19 + m*(89-19)/mnum
      end do

*- Ϸ
      do i=1,ntimax
          ty = ymin + i*(ymax-ymin)/ntimax
        do j=1,ntjmax
          tx = xmin + j*(xmax-xmin)/ntjmax
          tz(i,j) = - b*cos(tx*rk)*cos(ty*rl)
        end do
      end do

*- ʬ
      do n=1,nmax
        tend = n*dt
        do m=1,mnum
          t = (n-1)*dt
          xx(1)=x(n-1,m)
          xx(2)=y(n-1,m)
          xx(3)=z(n-1,m)
          xx(4)=u(n-1,m)
          xx(5)=v(n-1,m)
          xx(6)=w(n-1,m)
          call odrkdu(6, odrkg, fcn, t, tend, istep, xx, work)
          x(n,m)=xx(1)
          y(n,m)=xx(2)
          z(n,m)=xx(3)
          u(n,m)=xx(4)
          v(n,m)=xx(5)
          w(n,m)=xx(6)
        end do
      end do

*- ե
      call gropn(2)
      call uestlv(-9999.,0.,203)

*- window ؤ (mmaxγҤʿѰ֤)
      iimax = int(u0*nmax*dt/xmax)
      jjmax1 = int(abs(rmax(y,(nmax+1)*mnum,1)/(ymax-ymin)))
      jjmax2 = int(abs(rmin(y,(nmax+1)*mnum,1)/(ymax-ymin)))
      ijmax = max(iimax, jjmax1, jjmax2)

      do n=nmax,nmax
        call grfrm
        xxma = xmax
        xxmi = xmin
        yyma = ymax
        yymi = ymin
        xave = rave(x(n,1), mnum, nmax+1)
        yave = rave(y(n,1), mnum, nmax+1)
        do ijk=1,ijmax
          if(xave .gt. ijk*xmax) then
            xxma = xmax + ijk*xmax
            xxmi = xmin + ijk*xmax
          end if 
          if(yave .gt. ymax+(ijk-1)*(ymax-ymin)) then
            yyma = ymax + ijk*(ymax-ymin)
            yymi = ymin + ijk*(ymax-ymin)
          end if 
          if(yave .lt. ymin-(ijk-1)*(ymax-ymin)) then
            yyma = ymax - ijk*(ymax-ymin)
            yymi = ymin - ijk*(ymax-ymin)
          end if 
        end do

        call grswnd(yymi, yyma, xxma, xxmi)
        call grsvpt(0.14, 0.94, 0.12, 0.92)
        call grstrn(1)
        call grstrf

        call uyaxdv('r', 5., 10.)
        call uyaxdv('l', 5., 10.)
        call uysttl('l', 'DOWN-SLOPE DISTANCE [m]', 0.0) 
        call uxaxdv('b', 5., 10.)
        call uxaxdv('t', 5., 10.) 
        call uxsttl('b', 'CROSS-SLOPE DISTANCE [m]', 0.0)
        ctime = 'T=???.? s'
        write(ctime(3:7),'(f5.1)') n*dt
        call uxsttl('t', ctime, -0.8)
        
        if(itopo .ne. 0) call uetone(tz, ntimax, ntimax, ntjmax)

        do m=1,mnum
          if(n .ne. 0) then
c            call sgspli(icolor(m)*10+2)
            call sgplu(n+1, y(0,m), x(0,m))
          end if
c          call sgspmi(icolor(m)*10+2)
          call sgspmt(14)
          call sgpmu(1, y(n,m), x(n,m))
        end do
      end do

      call grcls
      end
********************************************************************************
      subroutine fcn(i,t,x,dx)

      real x(i),dx(i)

      common /const/ g,a,b,rk,rl
*-----+--1---------2---------3---------4---------5---------6---------7-+
      pi=atan(1.)*4

      dx(1)=x(4)
      dx(2)=x(5)
      dx(3)=x(6)
      
      sinx = sin(x(1)*rk)
      cosx = cos(x(1)*rk)
      siny = sin(x(2)*rl)
      cosy = cos(x(2)*rl)

      dhdx    = -a + b * rk      * sinx * cosy
      dhdy    =    + b * rl      * cosx * siny
      d2hdx   =    + b * rk**2   * cosx * cosy
      d2hdy   =    + b * rl**2   * cosx * cosy
      d2hdxdy =    - b * rk * rl * sinx * siny

      f = ( g + d2hdx*x(4)**2 + 2.*d2hdxdy*x(4)*x(5) + d2hdy*x(5)**2 )
     &   /( 1 + dhdx**2 + dhdy**2 )

      c = - f*dhdx/x(4)                        ! U = constant
                                               ! is assumed
      dx(4) = 0.                               ! in the sled model
      dx(5) = - f*dhdy - c*x(5)
      dx(6) =   f      - c*x(6) - g

      return
      end
********************************************************************************
