#!/usr/bin/env ruby
# -*- mode: ruby; coding: utf-8; indent-tabs-mode: nil -*-
#
# Copyright(C) Youhei SASAKI <uwabami@gfd-dennou.org> All rights reserved.
# $Lastupdate: 2017-10-05 10:01:34$
# License: BSD-2-Clause
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# .
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE HOLDERS OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Code:
@hold = nil
@fname = nil
@line = nil
@ch = nil
while input = ARGF.gets
  @input = input
  if @input =~ /^ / || @input =~/^\s*$/ || @input =~/^\s*1\s*$/
    @hold = @input
  elsif @input =~ /^(Warning|Error):/ && ( @fname && @line && @ch)
    puts "#{@fname}:#{@line}: #{@input.chomp} (ch.#{@ch})"
  elsif @input =~ /^(.+?):(\d+?)\.(\d+):(\s*)/
    @fname,@line,@ch = $1, $2, $3
    @hold = @input
  else
    @hold = @input
    puts @hold
    @hold = nil
    @fname = nil
    @line = nil
    @ch = nil
  end
end
