!= gtool_history_nmlinfo ǻѤ, ѿ, ³
!= Internal constants, variables, procedures used in "gtool_history_nmlinfo"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: gtool_history_nmlinfo_internal.f90,v 1.1 2009-05-11 15:15:15 morikawa Exp $
! Tag Name::  $Name: gtool5-20090729 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gtool_history_nmlinfo_internal
  !
  != gtool_history_nmlinfo ǻѤ, ѿ, ³
  !
  != Internal constants, variables, procedures used in "gtool_history_nmlinfo"
  !

  use dc_hash, only: HASH
  implicit none
  private
  public:: ListNext, ListLast, ListSearch

  character(1), parameter, public:: name_delimiter = ','
                              ! ʣѿ̾ζڤʸ
                              ! Delimiter for multiple variable names

  type(HASH), save, public:: opened_files
                              ! ʣѿĤΥե
                              ! Ϥ뤿Υåѿ. 
                              ! 
                              ! Variables for checking for 
                              ! output multiple variables to one file. 

  character(*), parameter, public:: version = &
    & '$Name: gtool5-20090729 $' // &
    & '$Id: gtool_history_nmlinfo_internal.f90,v 1.1 2009-05-11 15:15:15 morikawa Exp $'

  !-----------------------------------------------------------------
  !  ³
  !  Private procedures
  !-----------------------------------------------------------------

  interface ListNext
    module procedure HstNmlInfoListNext
  end interface

  interface ListLast
    module procedure HstNmlInfoListLast
  end interface

  interface ListSearch
    module procedure HstNmlInfoListSearch
  end interface

contains

  subroutine HstNmlInfoListNext( &
    & gthstnml_list, err )
    !
    ! ꥹȹ¤Ǥ *gthstnml_list* (GTHST_NMLINFO_ENTRY ) , 
    ! Υȥ *gthstnml_list* ˺Ʒ礷֤ޤ. 
    ! Υȥ̵꤬, *gthstnml_list* κǸΥȥ 
    ! *next* () ³֤ޤ. 
    ! *gthstnml_list* Ϥᤫξˤ϶֤֤ޤ. 
    !
    ! *gthstnml_list* (type "GTHST_NMLINFO_ENTRY") that is a list structure 
    ! is recieved, and *gthstnml_list* is reassociated to next entry, and
    ! is returned. 
    ! If next entry is not found, *gthstnml_list* is associated to 
    ! *next* in last entry (null), and returned. 
    ! If *gthstnml_list* is null from the beginning, null is returned.
    !
    use gtool_history_nmlinfo_types, only: GTHST_NMLINFO_ENTRY
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR
    use dc_types, only: TOKEN, STRING
    implicit none
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list
                              ! (inout)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoListNext'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ֤ξϲ⤷ʤ֤
    !  If null, return without change
    !-----------------------------------------------------------------
    if ( .not. associated( gthstnml_list ) ) goto 999

    !-----------------------------------------------------------------
    !  Υȥ˷礷֤
    !  Next entry is associated, and returned
    !-----------------------------------------------------------------
    gthstnml_list => gthstnml_list % next

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoListNext

  subroutine HstNmlInfoListLast( &
    & gthstnml_list, previous, err )
    !
    ! ꥹȹ¤Ǥ *gthstnml_list* (GTHST_NMLINFO_ENTRY ) , 
    ! ǸΥȥ˺Ʒ礷֤ޤ. 
    ! *gthstnml_list* Ϥᤫξˤ϶֤֤ޤ. 
    !
    ! *previous* Ϳ, ȥΰ
    ! ȥ˷礷ޤ. 
    !
    ! *gthstnml_list* (type "GTHST_NMLINFO_ENTRY") that is a list structure 
    ! is recieved, and *gthstnml_list* is reassociated to 
    ! last entry, and returned. 
    ! If *gthstnml_list* is null from the beginning, null is returned.
    !
    ! If *previous* is given, an entry previous to the above entry
    ! is associated. 
    !
    use gtool_history_nmlinfo_types, only: GTHST_NMLINFO_ENTRY
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR
    use dc_types, only: TOKEN, STRING
    implicit none
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list
                              ! (inout)
    type(GTHST_NMLINFO_ENTRY), pointer, optional:: previous
                              ! (out)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoListLast'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    if ( present( previous ) ) nullify( previous )

    !-----------------------------------------------------------------
    !  ֤ξϲ⤷ʤ֤
    !  If null, return without change
    !-----------------------------------------------------------------
    if ( .not. associated( gthstnml_list ) ) goto 999

    !-----------------------------------------------------------------
    !  ǸΥȥ *next* ˷礷֤
    !  "*next*" in last entry is associated, and returned
    !-----------------------------------------------------------------
    do while ( associated( gthstnml_list % next ) )
      if ( present( previous ) ) previous => gthstnml_list
      call ListNext( gthstnml_list = gthstnml_list ) ! (inout)
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoListLast

  subroutine HstNmlInfoListSearch( &
    & gthstnml_list, name, &
    & previous, next, err )
    !
    ! ꥹȹ¤Ǥ *gthstnml_list* (GTHST_NMLINFO_ENTRY ) , 
    !  *name* Ʊͤĥȥ˺Ʒ礷֤ޤ. 
    ! Ĥʤ϶֤֤ޤ.
    ! *gthstnml_list* Ϥᤫξˤ϶֤֤ޤ. 
    ! 
    ! *previous* Ϳ, ȥΰ
    ! ȥ˷礷ޤ. Υȥ̵꤬ˤ
    ! ֤֤ޤ. 
    !
    ! *next* Ϳ, ȥΰĸ
    ! ȥ˷礷ޤ. Υȥ̵꤬ˤ
    ! ֤֤ޤ. 
    ! 
    ! *gthstnml_list* (type "GTHST_NMLINFO_ENTRY") that is a list structure 
    ! is recieved, and *gthstnml_list* is reassociated to 
    ! the entry that has a value that is same as argument *name*, 
    ! and returned. 
    ! If the entry is not found, null is returned. 
    ! If *gthstnml_list* is null from the beginning, null is returned. 
    !
    ! If *previous* is given, an entry previous to the above entry
    ! is associated. If previous entries are not found, 
    ! null is returned.
    !
    ! If *next* is given, an entry next to the above entry
    ! is associated. If next entries are not found, 
    ! null is returned.
    !
    use gtool_history_nmlinfo_types, only: GTHST_NMLINFO_ENTRY
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR
    use dc_types, only: TOKEN, STRING
    implicit none
    type(GTHST_NMLINFO_ENTRY), pointer:: gthstnml_list
                              ! (inout)
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! Variable identifier. 
                              ! Blanks at the head of the name are ignored. 
    type(GTHST_NMLINFO_ENTRY), pointer, optional:: previous
                              ! (out)
    type(GTHST_NMLINFO_ENTRY), pointer, optional:: next
                              ! (out)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoListSearch'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  ֤ξϲ⤷ʤ֤
    !  If null, return without change
    !-----------------------------------------------------------------
    if ( .not. associated( gthstnml_list ) ) goto 999

    !-----------------------------------------------------------------
    !   *name* Ʊ *name* ĥȥõ
    !  The entry that has *name* that is same as argument *name* is searched
    !-----------------------------------------------------------------
    if ( present( previous ) ) nullify( previous )
    if ( present( next ) ) nullify( next )
    if ( trim( adjustl( gthstnml_list % name ) ) == trim( adjustl( name ) ) ) then
      if ( present( next ) ) then
        next => gthstnml_list % next
      end if
      goto 999
    end if

    do while ( associated( gthstnml_list ) )
      if ( present( previous ) ) previous => gthstnml_list
      call ListNext( gthstnml_list = gthstnml_list ) ! (inout)
      if ( .not. associated( gthstnml_list ) ) goto 999
      if ( trim( adjustl( gthstnml_list % name ) ) == trim( adjustl( name ) ) ) then
        if ( present( next ) ) then
          next => gthstnml_list % next
        end if
        goto 999
      end if
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoListSearch

end module gtool_history_nmlinfo_internal
