!= GT_HISTORY_ATTR ѿؤ䤤碌
!= Inquire for a "GT_HISTORY" variable
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: historyinquire.f90,v 1.2 2009-05-25 09:45:19 morikawa Exp $
! Tag Name::  $Name: gtool5-20090704 $
! Copyright:: Copyright (C) GFD Dennou Club, 2004-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  subroutine HistoryInquire1(history, err, file, title, source, &
    & dims, dimsizes, longnames, units, xtypes, &
    & institution, origin, interval, newest, oldest, &
    & conventions, gt_version, &
    & axes, varinfo )
    !
    !== GT_HISTORY ѿؤ䤤碌
    !
    ! HistoryCreate  HistoryAddVariable ʤɤꤷͤ
    ! ȤԤޤ
    !
    ! file, title, source, institution, origin, interval,
    ! conventions, gt_version, dims, dimsizes, longnames, units,
    ! xtypes ˴ؤƤ HistoryCreate 򻲾ȤƤ
    !
    ! title, source, institution, origin, interval, conventions, gt_version
    ! ˴ؤƤϡͤʤä "unknown" ֤ޤ
    !
    ! dims, dimsizes, longnames, units, xtypes ˴ؤƤϥݥ󥿤
    ! ֤ͤᡢɬݥ󥿤֤ˤƤͿƤ
    !
    ! axes  varinfo ˤϤ줾ɸѿ֤ޤ
    ! ŪˤƤ°֤ͤͽǤߤ
    ! long_name, units, xtype Τߤ°ͤȤ֤ޤ
    !
    ! *HistoryInquire*  2 ĤΥ֥롼̾Ǥ
    ! HistoryCreate  *history* Ϳʤä䤤碌˴ؤƤ
    ! 嵭Υ֥롼򻲾ȤƤ
    !
    !=== 顼
    !
    ! ʲξˡΥ֥롼ϥ顼ץλޤ
    ! *err* Ϳ硢ΰ <tt>.true.</tt> 
    ! ֤ץ³Ԥޤ
    !
    ! - *history*  HistoryCreate ˤäƽꤵƤʤ
    ! - HistoryAddVariable  HistoryCopyVariable ˤѿ
    !   ٤ԤƤʤ GT_HISTORY ѿФư varinfo
    !   Ϥ
    !
    use gtool_history_types, only: GT_HISTORY, GT_HISTORY_AXIS, GT_HISTORY_VARINFO, GT_HISTORY_ATTR
    use gtool_history_internal, only: default
    use gtdata_generic, only: Inquire, Get_Attr, Open, Close
    use gtdata_types, only: GT_VARIABLE
    use dc_url, only: UrlSplit
    use dc_error, only: StoreError, DC_NOERR, GT_EBADHISTORY, NF_ENOTVAR
    use dc_date, only: EvalByUnit
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_types, only: STRING, TOKEN, DP
    implicit none
    type(GT_HISTORY), intent(in):: history
    logical, intent(out), optional :: err
    character(*), intent(out), optional:: file, title, source, institution
    real,intent(out), optional:: origin, interval
    real,intent(out), optional:: newest ! ǿλ
    real,intent(out), optional:: oldest ! ǽλ
    character(*), intent(out), optional:: conventions, gt_version
    character(*), pointer, optional:: dims(:) ! (out)
    integer,pointer, optional:: dimsizes(:) ! (out)
    character(*), pointer, optional:: longnames(:) ! (out)
    character(*), pointer, optional:: units(:) ! (out)
    character(*), pointer, optional:: xtypes(:) ! (out)
    type(GT_HISTORY_AXIS), pointer, optional :: axes(:) ! (out)
    type(GT_HISTORY_VARINFO), pointer, optional :: varinfo(:) ! (out)

    ! Internal Work
    character(STRING)      :: url, cause_c
    character(TOKEN)       :: unknown_mes = 'unknown'
    integer          :: i, j, numdims, numvars, alldims, stat
    logical                :: growable
    type(GT_VARIABLE)      :: dimvar
    character(*), parameter:: subname = "HistoryInquire1"
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c =  ''
    if (.not. associated(history % dimvars) .or. &
      & size(history % dimvars) < 1) then
      stat = GT_EBADHISTORY
      goto 999
    end if

    if (present(file)) then
      call Inquire(history % dimvars(1), url=url)
      call UrlSplit(fullname=url, file=file)
    end if
    if (present(title)) then
      call Get_Attr(history % dimvars(1), '+title', title, trim(unknown_mes))
    end if
    if (present(source)) then
      call Get_Attr(history % dimvars(1), '+source', source, trim(unknown_mes))
    end if
    if (present(institution)) then
      call Get_Attr(history % dimvars(1), '+institution', institution, trim(unknown_mes))
    end if

    if (present(origin)) then
      origin = EvalByUnit( history % origin, '', history % unlimited_units_symbol )
    end if
    if (present(interval)) then
      interval = EvalByUnit( history % interval, '', history % unlimited_units_symbol )
    end if
    if (present(newest)) then
      newest = EvalByUnit( history % newest, '', history % unlimited_units_symbol )
    end if
    if (present(oldest)) then
      oldest = EvalByUnit( history % oldest, '', history % unlimited_units_symbol )
    end if
    if (present(conventions)) then
      call Get_Attr(history % dimvars(1), '+Conventions', conventions, trim(unknown_mes))
    end if
    if (present(gt_version)) then
      call Get_Attr(history % dimvars(1), '+gt_version', gt_version, trim(unknown_mes))
    end if
    if (present(dims)) then
      numdims = size(history % dimvars)
      allocate(dims(numdims))
      do i = 1, numdims
        call Inquire(history % dimvars(i), name=dims(i))
      end do
    end if
    if (present(dimsizes)) then
      numdims = size(history % dimvars)
      allocate(dimsizes(numdims))
      do i = 1, numdims
        call Inquire(history % dimvars(i), size=dimsizes(i), growable=growable)
        if (growable) dimsizes(i) = 0
      end do
    end if
    if (present(longnames)) then
      numdims = size(history % dimvars)
      allocate(longnames(numdims))
      do i = 1, numdims
        call Get_attr(history % dimvars(i), 'long_name', &
          & longnames(i), 'unknown')
      end do
    end if
    if (present(units)) then
      numdims = size(history % dimvars)
      allocate(units(numdims))
      do i = 1, numdims
        call Get_attr(history % dimvars(i), 'units', &
          & units(i), 'unknown')
      end do
    end if
    if (present(xtypes)) then
      numdims = size(history % dimvars)
      allocate(xtypes(numdims))
      do i = 1, numdims
        call Inquire(history % dimvars(i), xtype=xtypes(i))
      end do
    end if
    if (present(axes)) then
      numvars = size(history % dimvars)
      allocate(axes(numvars))
      do i = 1, numvars 
        call Inquire(history % dimvars(i), &
          & allcount=axes(i) % length, &
          & xtype=axes(i) % xtype, name=axes(i) % name)
        call Get_Attr(history % dimvars(i), 'long_name', &
          & axes(i) % longname, 'unknown')
        call Get_Attr(history % dimvars(i), 'units', &
          & axes(i) % units, 'unknown')

        ! ° GT_HISTORY_ATTR ϤޤǤʤ
        !
        ! 뤿ˤ, °̾Ф͡ʷ¸ߤ
        ! ͤ뤿, get_attr (gtdata_generic  gtdata_netcdf_generic)
        !  err °, Ǥʤݤ˥顼
        ! ֤ƤʤФʤʤ.

      end do
    end if

    if (present(varinfo)) then
      if (.not. associated(history % vars) .or. &
        & size(history % vars) < 1) then
        stat = NF_ENOTVAR
        goto 999
      end if

      numvars = size(history % vars)
      allocate(varinfo(numvars))
      do i = 1, numvars 
        call Inquire(history % vars(i), alldims=alldims, &
          & xtype=varinfo(i) % xtype, name=varinfo(i) % name)
        call Get_Attr(history % vars(i), 'long_name', &
          & varinfo(i) % longname, 'unknown')
        call Get_Attr(history % vars(i), 'units', &
          & varinfo(i) % units, 'unknown')

        ! ° GT_HISTORY_ATTR ϤޤǤʤ
        !
        ! 뤿ˤ, °̾Ф͡ʷ¸ߤ
        ! ͤ뤿, get_attr (gtdata_generic  gtdata_netcdf_generic)
        !  err °, Ǥʤݤ˥顼
        ! ֤ƤʤФʤʤ.

        allocate(varinfo(i) % dims(alldims))
        do j = 1, alldims
          call Open(var=dimvar, source_var=history % vars(i), &
            & dimord=j, count_compact=.true.)
          call Inquire(dimvar, name=varinfo(i) % dims(j))
          call Close(dimvar)
        end do

        varinfo(i) % initialized = .true.
        
      end do
    end if
999 continue
    call StoreError(stat, subname, err, cause_c=cause_c)
    call EndSub(subname)
  end subroutine HistoryInquire1

  !-------------------------------------------------------------------

  subroutine HistoryInquire2(history, err, file, title, source, &
    & dims, dimsizes, longnames, units, xtypes, &
    & institution, origin, interval, newest, oldest, &
    & conventions, gt_version, &
    & axes, varinfo )
    !
    !== GT_HISTORY ѿؤ䤤碌
    !
    ! HistoryCreate  *history* ꤷʤäϤ
    ! ֥롼䤤碌Ԥޤ
    ! *history* ˤɬ "<tt>default</tt>" ȤʸͿƤ
    !
    ! *HistoryInquire*  2 ĤΥ֥롼̾Ǥ
    ! ưξ˴ؤƤϲΥ֥롼򻲾ȤƤ
    !
    !--
    ! HistoryInquire1 Ʊǽ, 
    ! history  "default" Ȥʸ뤳Ȥ,
    ! ǥեȤǽϤե̾ (HistoryCreate 
    ! history ͿʤΥե̾) ֤.
    !++
    !
    use gtool_history_types, only: GT_HISTORY, GT_HISTORY_AXIS, GT_HISTORY_VARINFO, GT_HISTORY_ATTR
    use gtool_history_internal, only: default
    use gtool_history_generic, only: HistoryInquire
    use dc_error, only: StoreError, DC_NOERR, NF_EINVAL
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_types, only: STRING, TOKEN, DP
    implicit none
    character(*), intent(in):: history
    logical, intent(out), optional :: err
    character(*), intent(out), optional:: file, title, source, institution
    real,intent(out), optional:: origin, interval, newest, oldest
    character(*), intent(out), optional:: conventions, gt_version
    character(*), pointer, optional:: dims(:) ! (out)
    integer,pointer, optional:: dimsizes(:) ! (out)
    character(*), pointer, optional:: longnames(:) ! (out)
    character(*), pointer, optional:: units(:) ! (out)
    character(*), pointer, optional:: xtypes(:) ! (out)
    type(GT_HISTORY_AXIS), pointer, optional :: axes(:) ! (out)
    type(GT_HISTORY_VARINFO), pointer, optional :: varinfo(:) ! (out)
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = "HistoryInquire2"
  continue
    call BeginSub(subname, "history=%c", c1=trim(history))
    stat = DC_NOERR
    cause_c = ''
    if (trim(history) /= 'default') then
      stat = NF_EINVAL
      cause_c = 'history="' // trim(history) // '"'
      goto 999
    end if
    call HistoryInquire(default, err, file, title, source, &
      & dims, dimsizes, longnames, units, xtypes, &
      & institution, origin, interval, newest, oldest, &
      & conventions, gt_version, &
      & axes, varinfo )
999 continue
    call StoreError(stat, subname, cause_c=cause_c)
    call EndSub(subname)
  end subroutine HistoryInquire2

  !-------------------------------------------------------------------

  subroutine HistoryInquire3(history, err, file, title, source, &
    & dims, dimsizes, longnames, units, xtypes, &
    & institution, origin, interval, newest, oldest, &
    & conventions, gt_version, &
    & axes, varinfo )
    !
    ! ˡ HistoryInquire ƱͤǤ. 
    !
    ! Usage is same as "HistoryInquire".
    !
    !--
    ! ̾ Inquire Ȥ󶡤뤿Υ֥롼Ǥ. 
    ! ǽ HistoryInquire1 ƱǤ. 
    !++
    !
    use gtool_history_types, only: GT_HISTORY, GT_HISTORY_AXIS, GT_HISTORY_VARINFO, GT_HISTORY_ATTR
    use gtool_history_generic, only: HistoryInquire
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    implicit none
    type(GT_HISTORY), intent(in):: history
    logical, intent(out), optional :: err
    character(*), intent(out), optional:: file, title, source, institution
    real,intent(out), optional:: origin, interval
    real,intent(out), optional:: newest ! ǿλ
    real,intent(out), optional:: oldest ! ǽλ
    character(*), intent(out), optional:: conventions, gt_version
    character(*), pointer, optional:: dims(:) ! (out)
    integer,pointer, optional:: dimsizes(:) ! (out)
    character(*), pointer, optional:: longnames(:) ! (out)
    character(*), pointer, optional:: units(:) ! (out)
    character(*), pointer, optional:: xtypes(:) ! (out)
    type(GT_HISTORY_AXIS), pointer, optional :: axes(:) ! (out)
    type(GT_HISTORY_VARINFO), pointer, optional :: varinfo(:) ! (out)

    character(*), parameter:: subname = "HistoryInquire3"
  continue
    call BeginSub(subname)
    call HistoryInquire(history, err, file, title, source, &
      & dims, dimsizes, longnames, units, xtypes, &
      & institution, origin, interval, newest, oldest, &
      & conventions, gt_version, &
      & axes, varinfo )
    call EndSub(subname)
  end subroutine HistoryInquire3

  !-------------------------------------------------------------------

  subroutine HistoryInquire4(history, err, file, title, source, &
    & dims, dimsizes, longnames, units, xtypes, &
    & institution, origin, interval, newest, oldest, &
    & conventions, gt_version, &
    & axes, varinfo )
    !
    ! ˡ HistoryInquire ƱͤǤ. 
    !
    ! Usage is same as "HistoryInquire".
    !
    !--
    ! ̾ Inquire Ȥ󶡤뤿Υ֥롼Ǥ. 
    ! ǽ HistoryInquire2 ƱǤ. 
    !++
    !
    use gtool_history_types, only: GT_HISTORY, GT_HISTORY_AXIS, GT_HISTORY_VARINFO, GT_HISTORY_ATTR
    use gtool_history_generic, only: HistoryInquire
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    implicit none
    character(*), intent(in):: history
    logical, intent(out), optional :: err
    character(*), intent(out), optional:: file, title, source, institution
    real,intent(out), optional:: origin, interval, newest, oldest
    character(*), intent(out), optional:: conventions, gt_version
    character(*), pointer, optional:: dims(:) ! (out)
    integer,pointer, optional:: dimsizes(:) ! (out)
    character(*), pointer, optional:: longnames(:) ! (out)
    character(*), pointer, optional:: units(:) ! (out)
    character(*), pointer, optional:: xtypes(:) ! (out)
    type(GT_HISTORY_AXIS), pointer, optional :: axes(:) ! (out)
    type(GT_HISTORY_VARINFO), pointer, optional :: varinfo(:) ! (out)
    character(*), parameter:: subname = "HistoryInquire4"
  continue
    call BeginSub(subname)
    call HistoryInquire(history, err, file, title, source, &
      & dims, dimsizes, longnames, units, xtypes, &
      & institution, origin, interval, newest, oldest, &
      & conventions, gt_version, &
      & axes, varinfo )
    call EndSub(subname)
  end subroutine HistoryInquire4
