! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine ANVarClose(var, err)
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileClose, ANFileSync
    use an_vartable, only: vtable_delete
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    logical, intent(out), optional:: err
    integer:: fileid
continue
    fileid = vtable_delete(var)
    if (fileid < 0) then
        call StoreError(fileid, 'ANVarClose', err)
        return
    endif
    call ANFileSync(fileid)
    call ANFileClose(fileid, err)
end subroutine
