# INSTALL GUIDE                                                      {#INSTALL}

<!-- English bellow -->

@ja
## 必要要件

gtool5 fortran library を利用するには以下のソフトウェアが必要です.

* Fortran Compiler: support >= fortran 2003 standard.
* [Ruby](https://www.ruby-lang.org/ja/): ソースコードの動的生成に [erb](ERBja) を利用しています. 
* [Unidata | NetCDF C Library](http://www.unidata.ucar.edu/software/netcdf/)
* [Unidata | NetCDF Fortran Library](http://www.unidata.ucar.edu/downloads/netcdf/index.jsp)
* Optional: ドキュメントの再生成には [Doxygen](http://www.stack.nl/~dimitri/doxygen/) が必要となります. 

## インストールの手引き

### はじめに. 

gtool5 fortran library は autotools ([autoconf],[automake],[libtool]) を利用しています.
autotools を利用する典型的なソフトウェアと同様に

    ./configure & make & make install

でインストールすることができるでしょう. 

### 環境変数の設定

先ずは環境変数 `FC` に使用する Fortran コンパイラを, 
環境変数 `FCFLAGS` に最適化やデバッグのためのオプションを指定して下さい. 
例えば

    % FC=gfortran
    % FCFLAGS="-g -O2 -fopenmp"

などです.

### ソースの展開と `configure` の実行

次に適当な作業ディレクトリでソースアーカイブを展開します.
ソースは gtool5-`バージョン` というディレクトリに展開されます.

	$ tar xvf gtool5_current.tar.gz

展開されたディレクトリに移動し, `./configure`を実行します.

    % ./configure

out ot tree build にも対応していますので, 例えば `build` 以下でコンパイルをしたい場合には

    % mkdir build
    % cd build
    % ../configure

といったことも可能です. 

インストール先などを変更したい場合などは, `configure` に `--help` オプ
ションをつけて, 指定可能なオプションリストをご確認下さい. 

	% ./configure --help

主なオプションは以下の通りです.

* `--with-nf-config=ARG`
  * Defatult: `PATH` から探索.
  * `ARG` に `nf-config` を明示的に指定することもできます.
    これによって NetCDF C Library および NetCDF Fortran Library に関する
    設定が行なわれます.

* `--with-netcdf=ARG`
  * `nf-config` が使えない場合に NetCDF C Library の場所を指定します.

* `--with-netcdff=ARG`
  * `nf-config` が使えない場合に NetCDF Fortran Library の場所を指定します.

* `--with-netcdff-include=ARG`
  * `nf-config` が使えない場合に NetCDF Fortran Library の
    モジュールファイル `netcdf.mod` 場所を指定します.

* `--prefix=ARG`
  * Defatult: `/usr/local/gtool5`
  * `ARG` にライブラリやモジュール, 実行ファイルのインストール先の
    ディレクトリのプレフィックスを指定します.

* `--host=ARG`
  * クロスコンパイルを行う場合には,
    パッケージが実行されるシステムタイプ名を `ARG` に指定します.

* `--enable-mpi`
  * Defatult: enabled
  * MPI を有効にします. `FC` に
    MPI 用のコンパイラ(例えば mpif90 等)を指定して下さい.

* `--with-mpiexec`
  * Defatult: none
  * テスト時に使用する MPI 実行プログラムを指定します.

* `--with-mpiexec-opts`
  * Default: none
  * テスト時に使用する MPI 実行プログラムのオプションを指定します.

* `--with-mpiexec-procnum`
  * Default: 4
  * テスト時に使用する MPI 実行プログラムの並列数を指定します.

* `--with-ncdump`
  * Defatult: `'PATH`' から探索
  * テスト時に使用する ncdump を指定します.

### ビルド

`configure` が正常に終了したならば,
例えば以下の様に結果のサマリが表示されますので, 内容を確認して下さい. 

```
% export FCFLAGS="-g -O2 -Wall -Wextra"
% export FC=mpif90
% ./configure --with-mpiexec-opts=--oversubscribe --with-nf-config=/usr/bin/nf-config
  :
-----------------------------------------------------------------------
Summary of build options:

version:               1.0.0.rc1
Host type:             x86_64-pc-linux-gnu
Install prefix:        /usr/local/gtool
C Compiler:            gcc
C Flags:               -g -O2
C Preprocessor:        gcc -E
CPP Flags:              -DF03_FEATURE -DLIB_MPI
Fortran Compiler:      mpif90
Fortran Flags:         -I/usr/include -I/usr/include -g -O2 -Wall -Wextra
Linker:                /usr/bin/ld
Linker Flags:
Linking Libraries:     -L/usr/lib/x86_64-linux-gnu -lnetcdff -Wl,-z,relro -Wl,-z,now -lnetcdf -lnetcdf -ldl -lm
MPI Fortran Compiler:  mpif90
MPI Executer:          /usr/bin/mpiexec
MPI Executer option:   --oversubscribe -n
MPI Executer number:   4
NetCDF ncdump binary:  /usr/bin/ncdump
-----------------------------------------------------------------------
```

表示された結果が期待通りである場合には

    % make

でビルドが始まります.

### テストプログラム実行

カレントディレクトリにおいて, 以下のコマンドを実行してください.

	$ make test

### インストール

カレントディレクトリで以下のコマンドを実行してください.
システム領域にインストールする場合には管理者権限が
必要です(デフォルトの場合は `/usr/local/gtool5` にインストールします).

	# make install

### gt5frt へのパスの設定

上記のように正しくインストールが行われたら,
`gt5config`, `gt5frt` というシェルスクリプトが
`--prefix=ARG` で指定されたディレクトリ以下の `bin` ディレクトリ
(`ARG/bin`)に作成されているはずです.
( `--prefix=` を指定しなかった場合は `/usr/local/gtool5/bin/` 以下).
このディレクトリへ `PATH` を通してください.

`gt5config` は gtool5 ライブラリのビルドに利用したコンパイラ等の情報が含まれています. 
これを用いることで, gtool5 ライブラリを基盤としたソフトウェアのインストールが簡便になることが期待されています. 

```
This gtool5 1.0.0.rc1 has been built with the following features:

  --fc         -> mpif90
  --mpifc      -> mpif90
  --fcflags    -> -I/usr/local/stow/gtool5-gnu/include -I/usr/include -I/usr/include -g -O2
  --fflags     -> -I/usr/local/stow/gtool5-gnu/include -I/usr/include -I/usr/include -g -O2
  --ldflags    ->  -L/usr/local/stow/gtool5-gnu/lib
  --ldlibs     -> -lgtool -L/usr/lib/x86_64-linux-gnu -lnetcdff

  --prefix     -> /usr/local/stow/gtool5-gnu
  --includedir -> /usr/local/stow/gtool5-gnu/include
  --version    -> gtool5 1.0.0.rc1
```

`gt5frt` は `gt5cofnig` の情報をベースに, 
gtool5 ライブラリを利用した Fortran プログラムを簡単にコンパイル・リンクを行なうためにシェルスクリプトです.
`gt5frt` を用いることで, 自動的に gtool5 ライブラリへのリンクとモジュール群へのディレクトリ指定を行ってくれます.

``` 4d
	% gt5frt test.f90
    mpif90 -I/usr/local/stow/gtool5-gnu/include -I/usr/include -I/usr/include -g -O2 test.f90 \
    -L/usr/local/stow/gtool5-gnu/lib -lgtool -L/usr/lib/x86_64-linux-gnu -lnetcdff

```

@endja
@en
## Set PATH to gt5frt

If the installation is correctly done as stated above,
shell script ((*gt5frt*)) is made under the directory
`--prefix=ARG`/bin
(By default, `/usr/local/gtool5/bin/` ).

Please specify PATH to this directory.
It is an example as follows when ((*gt5frt*)) is installed in
`/usr/local/gtool5/bin/` .

((*gt5frt*)) is a shell script in order to easily compile and link
Fortran programs which utilizes the gtool5 library.
Link to the gtool5 library and directory appointment to the modules
are done automatically by using gt5frt in place of command of the
Fortran compiler.

	$ gt5frt test.f90
    /usr/bin/gfortran -I/usr/local/gtool5/include -I/usr/include -g -O2 test.f90 \
      -L/usr/local/stow/gtool5/lib -lgtool -L/usr/lib -lnetcdff -lnetcdf


@enden
@en
## Prerequisite

To use the gtool5 fortran library, the following software is required.

* Fortran Compiler: support >= fortran 2003 standard.
* [Unidata | NetCDF C Library](http://www.unidata.ucar.edu/software/netcdf/)
* [Unidata | NetCDF Fortran Library](http://www.unidata.ucar.edu/downloads/netcdf/index.jsp)
* Optional: [Doxygen](http://www.stack.nl/~dimitri/doxygen/) : For regeneration of doucments. 

## How to install

### Extract tar.gz

Make an empty directory, and extract archive.
A directory `gtool5-`version`'
created at the current working directory.

	$ tar xvf gtool5_current.tar.gz

### Specify Fortran Compiler

Specify Fortran compiler to environment variable ((* FC *)), e.g.

    % FC=gfortran

Specify Fortran compiler options for optimization and debug to
environment variable `FCFLAGS`, e.g.,

    % FCFLAGS="-g -O2 -fopenmp"

Move created directroy, and excute `./configure`'.

    % ./configure

If you want to change directory to which the library and the module, etc.
are installed, please set `--help` option as follow. Available
options are showed.

	% ./configure --help

Descriptions about principal options are listed below.

* `--with-nf-config=ARG`
  * Default: search `nf-config` from ((:PATH:)).
  * If you want to use another `nf-config`,
    set the location of `nf-config` to `ARG` explicitly.

* `--with-netcdf=ARG`
  * When you can't execute `nf-config`,
    set the location of NetCDF C Library to `ARG` explicitly.

* `--with-netcdff=ARG`
  * When you can't execute `nf-config`,
    set the location of NetCDF Fortran library to `ARG` explicitly.

* `--with-netcdff-include=ARG`
  * When you can't execute `nf-config`,
    set the location of module file `netcdf.mod` to `ARG` explicitly.

* `--prefix=ARG`
  * Default: `/usr/local/gtool5`.
    set prefix to `ARG`.

* `--host=ARG`
  * When cross-compiling,
    set the type of system on which the package will run to `ARG`.

* `--enable-mpi`
  * Default: enable
  * Enable MPI support.
    Set MPI Fortran Compiler to ((:FC:)), e.g. mpif90.

* `--with-mpiexec`
  * Default: none
  * Set MPI execute program for test.

* `--with-ncdump`
  * Default: search ((:ncdump:)) from ((:PATH:)).
  * Set ((:ncdump:)) for test.

@enden


[autoconf]: https://www.gnu.org/software/autoconf/autoconf.html
[automake]: https://www.gnu.org/software/automake/
[libtool]: https://www.gnu.org/software/automake/
[ERBja]: https://docs.ruby-lang.org/ja/3.1/library/erb.html
[ERBen]: https://docs.ruby-lang.org/en/3.1/library/erb.html
