# gtool5 fortran library

<!-- English bellow -->

@ja
## gtool5 とは?

**gtool5 fortran ライブラリ** は地球惑星流体科学の研究・教育のための
様々な数値モデルで用いることを想定して開発されているライブラリです.
[地球流体電脳倶楽部 gtool プロジェクト][gtool project] の一環として開発・管理されています.

gtool5 は, データ入出力をはじめ, 日付および時刻の操作やメッセージ出力,
CPU 時間の計測など, Fortran (≥2003) で書かれた数値モデルのための様々な機能を提供します.
特にデータ入出力については,
複数の人間が数値モデルから得られた計算結果に対する理解・認識を共有することを容易とするために,
[gtool4 NetCDF 規約][xref] に基づくデータの入出力を用いています.

gtool5 は [地球流体電脳倶楽部 dcmodel プロジェクト][dcmodel project]
などで導入され, データの共有を容易にするとともに,
ソースコードの可読性向上にも役立っています.
論文としては [GMD 論文][GMD paper] を参照下さい.

## 最新安定版

* tar.gz ファイル
* ソースツリー
  * 過去のバージョンとそのソースツリー
* [インストールガイド](@ref INSTALL)
  *  [gt4f90io からの移行](@ref transition-gt4f90io)
* チュートリアル
* ドキュメント
* [開発者, 貢献者一覧](@ref CREDITS)

## 開発版

* tar.gz ファイル
* ソースツリー


## 使用上の注意とライセンス

* gtool5 fortran library に関連するソースコードは2条項BSDライセンスです.
* doxygen によって生成したドキュメントの表示に利用する CSS, Javascript(e.g. MathJax) は
  * bootstrap, jquery: MIT/X11
  * mathjax: Apache-2.0
  です.
* 正式なライセンス表記は \subpage COPYRIGHT を参照して下さい. 

### 科学者・研究者の方へのお願い

本ソフトウェアはフリーソフトウェアとしてリリースされていますが,
適切な引用を行なう科学的な作法までを免責していないことにご注意下さい.
本ソフトウェアを使用した研究を記述した論文を書く際には、
再現性の担保のためにも、適切な形式での引用をお願いします.

引用例は以下の通りです:

引用例 (和文)
> 森川 靖大, 高橋 芳幸, 佐々木 洋平, 西澤 誠也, 乙部 直人, 石渡 正樹, 小高正嗣, 竹広 真一, 堀之内 武, 林 祥介, 豊田 英司, gtool 開発グループ, 2010: gtool5 ライブラリ, http://www.gfd-dennou.org/library/gtool/gtool5, 地球流体電脳倶楽部.
引用例 (英文)
> Morikawa,Y., Takahashi,O.Y., Sasaki,Y., Nishizawa,S., Otobe,N., Ishiwatari,M., Odaka,M., Takehiro,S., Horinouchi,T., Hayashi,Y.-Y., Toyoda,E., Gtool Devlopment Group, 2010: Gtool5 library, http://www.gfd-dennou.org/library/gtool/gtool5, GFD Dennou Club.

査読付き論文しか引用できない場合には, 次の[論文][GMD paper]を引用して下さい:
> Ishiwatari, M., Toyoda, E., Morikawa, Y., Takehiro, S., Sasaki, Y., Nishizawa, S., Odaka, M., Otobe, N., Takahashi, Y. O., Nakajima, K., Horinouchi, T., Shiotani, M., Hayashi, Y.-Y., Gtool development group, 2012: gtool5 - development of Fortran90 library for self-descriptive multi-dimensional data input/output interfaces, Geosci. Model Dev., 5, 449-455., 2012, doi:10.5194/gmd-5-449-2012.

## 旧版との関係

gtool5 ライブラリは
[gtool4][gtool4 url] と [gt4f90io][gt4f90io url] の後継となるライブラリです. 

* [gtool4][gtool4 url] から解析可視化機能を分離し、 
  データ入出力ライブラリとして特化させたものが [gt4f90io][gt4f90io url] 
  です.
* [gt4f90io][gt4f90io url]に入出力以外の汎用ユーティリティを加えたものが
  gtool5 となります.

[TOC]
@endja

<!-- English page -->
@en
## What is gtool5?

The **gtool5 fortran library** is being developed for use in a variety
of numerical models for research and education in geophysical and
planetary fluid science. This library is being developed and maintained
as part of [GFD Dennou Club Gtool project][gtool project].

The gtool5 provides various functions for numerical models written in
fortran (≥2003), such as data input/output, date/time manipulation,
message output, and CPU time measurement. In particular, for data
input/output, gtool5 adopts data input/output based on the 
[gtool4 NetCDF convention][xref] in order to facilitate 
multiple users to understand, recognize, and share the computational 
results obtained from the numerical model.

The gtool5 library has been used in
[GFD Dennouc Club dcmodel project][dcmodel project]
to facilitate data sharing and to improve the readability of the source
code. For the detail, please refer to the [GMD paper][GMD paper].

## Latest stable release

* tar.gz file
* source tree
  * old versions and their source tree
* \subpage INSTALL : Install Guide
  *  \subpage transition-gt4f90io : Upgrade from gt4f90io
* Tutorial
* Documents
* \subpage CREDITS : Developers, Contributors List

## Development version

* tar.gz file
* source tree

## Precautions and Licenses

* The source code associated with gtool5 fortran library is under the 2 terms BSD license. 
* The licenses of CSS and Javascript (e.g. MathJax) used to display the documents generated by doxygen are as follows:
  * bootstrap, jquery: MIT/X11
  * mathjax: Apache-2.0
* Please refer to [Copyright][\subpage COPYRIGHT] for the official license description. 

### For SCIENTISTS

Please be aware that the fact that these programs are released as Free
Software does not excuse you from scientific propriety, which obligates
you to give appropriate credit. If you write a scientific paper
describing research that made substantive use of these programs, it is
your obligation as a scientist to (a) mention the fashion in which this
software was used with a citation to the literature or (b) mention this
software in the Acknowledgements section.

Example:
> Morikawa,Y., Takahashi,O.Y., Sasaki,Y., Nishizawa,S., Otobe,N., Ishiwatari,M., Odaka,M., Takehiro,S., Horinouchi,T., Hayashi,Y.-Y., Toyoda,E., Gtool Devlopment Group, 2010: Gtool5 library, http://www.gfd-dennou.org/library/gtool/gtool5, GFD Dennou Club.

When you have to refer only an article of a refereed journal, please
cite our ariticle of [GMD paper][GMD_paper] as follows:
> Ishiwatari, M., Toyoda, E., Morikawa, Y., Takehiro, S., Sasaki, Y., Nishizawa, S., Odaka, M., Otobe, N., Takahashi, Y. O., Nakajima, K., Horinouchi, T., Shiotani, M., Hayashi, Y.-Y., Gtool development group, 2012: gtool5 - development of Fortran90 library for self-descriptive multi-dimensional data input/output interfaces, Geosci. Model Dev., 5, 449-455., 2012, doi:10.5194/gmd-5-449-2012.


## Releation to previous editions

The gtool5 library is the successor to [gtool4][gtool4 url] and [gt4f90io][gt4f90io url].

* The [gt4f90io][gt4f90io url] is a library specialized in data I/O,
  with visualization functions separated from [gtool4][gtool4 url].
* The gtool5 is a library that added general-purpose utilities
  to [gt4f90io][gt4f90io url].

[TOC]
@enden

[GMD paper]: http://www.geosci-model-dev.net/5/449/2012/
[gtool project]: https://www.gfd-dennou.org/library/gtool/index.htm
[dcmodel project]: https://www.gfd-dennou.org/library/dcmodel/index.htm
[gtool4 url]: https://www.gfd-dennou.org/library/gtool4/gtool4-tools-library.htm)
[gt4f90io url]: https://www.gfd-dennou.org/library/gtool/gt4f90io.htm
[xref]: https://www.gfd-dennou.org/library/gtool/gt4ncconv/gt4ncconv_current/
<!-- Local Variables: -->
<!-- mode: markdown -->
<!-- End: -->
