module lower_boundary_noslip
 	use datatype
 	use model_info
 	use mem_manager
 	implicit none
  
	interface lower_boundary_noslip_x 
   	module procedure lower_boundary_noslip_x_x, lower_boundary_noslip_x_xy, lower_boundary_noslip_x_xz, lower_boundary_noslip_x_xyz 
	end interface

 	interface lower_boundary_noslip_y 
   	module procedure lower_boundary_noslip_y_y, lower_boundary_noslip_y_xy, lower_boundary_noslip_y_yz, lower_boundary_noslip_y_xyz 
	end interface

 	interface lower_boundary_noslip_z 
   	module procedure lower_boundary_noslip_z_z, lower_boundary_noslip_z_xz, lower_boundary_noslip_z_yz, lower_boundary_noslip_z_xyz
	end interface

contains
 	subroutine lower_boundary_noslip_x_x(var) 
   	type(var_x), intent(inout) :: var
   	integer :: i

  		if (var%grid(1) == 0) then 
    		work_x(plb1,:,:,var%id) = 0.0D0 
     		do i = 1, margin_1
      		work_x(plb1-i,:,:,var%id) = - work_x(plb1+i,:,:,var%id) 
     		end do

   	else if (var%grid(1) == 1) then 
     		do i = 0, margin_1
      		work_x(plb1-i,:,:,var%id) = - work_x(plb1+i+1,:,:,var%id) 
      	end do
  
    	end if

 	end subroutine lower_boundary_noslip_x_x


 	subroutine lower_boundary_noslip_x_xy(var) 
   	type(var_xy), intent(inout) :: var
   	integer :: i

   	if (var%grid(1) == 0) then 
    		work_xy(plb1,:,:,var%id) = 0.0D0 
     		do i = 1, margin_1
 				work_xy(plb1-i,:,:,var%id) = - work_xy(plb1+i,:,:,var%id) 
     	end do

   	else if (var%grid(1) == 1) then 
     		do i = 0, margin_1
       		work_xy(plb1-i,:,:,var%id) = - work_xy(plb1+i+1,:,:,var%id) 
      	end do
      
    	end if
  
	end subroutine lower_boundary_noslip_x_xy


 	subroutine lower_boundary_noslip_x_xz(var) 
   	type(var_xz), intent(inout) :: var
   	integer :: i

   	if (var%grid(1) == 0) then 
    		work_xz(plb1,:,:,var%id) = 0.0D0 
     		do i = 1, margin_1
       		work_xz(plb1-i,:,:,var%id) = - work_xz(plb1+i,:,:,var%id) 
     		end do

   	else if (var%grid(1) == 1) then 
     		do i = 0, margin_1
       		work_xz(plb1-i,:,:,var%id) = - work_xz(plb1+i+1,:,:,var%id) 
      	end do

    	end if

 	end subroutine lower_boundary_noslip_x_xz


 	subroutine lower_boundary_noslip_x_xyz(var) 
   	type(var_xyz), intent(inout) :: var
   	integer :: i

   	if (var%grid(1) == 0) then 
    		work_xyz(plb1,:,:,var%id) = 0.0D0 
     		do i = 1, margin_1
       		work_xyz(plb1-i,:,:,var%id) = - work_xyz(plb1+i,:,:,var%id) 
     		end do

   	else if (var%grid(1) == 1) then 
     		do i = 0, margin_1
       		work_xyz(plb1-i,:,:,var%id) = - work_xyz(plb1+i+1,:,:,var%id) 
     		end do
  
    	end if
  
	end subroutine lower_boundary_noslip_x_xyz


 	subroutine lower_boundary_noslip_y_y(var) 
   	type(var_y), intent(inout) :: var
   	integer :: i

   	if (var%grid(2) == 0) then 
    		work_y(:,plb2,:,var%id) = 0.0D0 
     		do i = 1, margin_2
       		work_y(:,plb2-i,:,var%id) = - work_y(:,plb2+i,:,var%id) 
     		end do

   	else if (var%grid(2) == 1) then 
     		do i = 0, margin_2
       		work_y(:,plb2-i,:,var%id) = - work_y(:,plb2+i+1,:,var%id) 
      	end do
     
    	end if
  
	end subroutine lower_boundary_noslip_y_y


 	subroutine lower_boundary_noslip_y_xy(var) 
   	type(var_xy), intent(inout) :: var
   	integer :: i

   	if (var%grid(2) == 0) then 
    		work_xy(:,plb2,:,var%id) = 0.0D0 
     		do i = 1, margin_2
       		work_xy(:,plb2-i,:,var%id) = - work_xy(:,plb2+i,:,var%id) 
     		end do

   	else if (var%grid(2) == 1) then 
     		do i = 0, margin_2
       		work_xy(:,plb2-i,:,var%id) = - work_xy(:,plb2+i+1,:,var%id) 
      	end do
      
    	end if

 	end subroutine lower_boundary_noslip_y_xy


 	subroutine lower_boundary_noslip_y_yz(var) 
   	type(var_yz), intent(inout) :: var
   	integer :: i

   	if (var%grid(2) == 0) then 
    		work_yz(:,plb2,:,var%id) = 0.0D0 
     		do i = 1, margin_2
       		work_yz(:,plb2-i,:,var%id) = - work_yz(:,plb2+i,:,var%id) 
     		end do

   	else if (var%grid(2) == 1) then 
     		do i = 0, margin_2
       		work_yz(:,plb2-i,:,var%id) = - work_yz(:,plb2+i+1,:,var%id) 
      	end do
    
   	end if
 
	end subroutine lower_boundary_noslip_y_yz


 	subroutine lower_boundary_noslip_y_xyz(var) 
   	type(var_xyz), intent(inout) :: var
   	integer :: i

   	if (var%grid(2) == 0) then 
   		work_xyz(:,plb2,:,var%id) = 0.0D0 
    		do i = 1, margin_2
       		work_xyz(:,plb2-i,:,var%id) = - work_xyz(:,plb2+i,:,var%id) 
     		end do

   	else if (var%grid(2) == 1) then 
     		do i = 0, margin_2
      		work_xyz(:,plb2-i,:,var%id) = - work_xyz(:,plb2+i+1,:,var%id) 
      	end do
      
    	end if
  
	end subroutine lower_boundary_noslip_y_xyz


 	subroutine lower_boundary_noslip_z_z(var) 
  		type(var_z), intent(inout) :: var
  		integer :: i

   	if (var%grid(3) == 0) then 
    		work_z(:,:,plb3,var%id) = 0.0D0 
    		do i = 1, margin_3
      		work_z(:,:,plb3-i,var%id) = - work_z(:,:,plb3+i,var%id) 
     		end do

   	else if (var%grid(3) == 1) then 
     		do i = 0, margin_3
       		work_z(:,:,plb3-i,var%id) = - work_z(:,:,plb3+i+1,var%id) 
      	end do
 
    	end if
 
 	end subroutine lower_boundary_noslip_z_z


 	subroutine lower_boundary_noslip_z_xz(var) 
   	type(var_xz), intent(inout) :: var
   	integer :: i

   	if (var%grid(3) == 0) then 
    		work_xz(:,:,plb3,var%id) = 0.0D0 
     		do i = 1, margin_3
       		work_xz(:,:,plb3-i,var%id) = - work_xz(:,:,plb3+i,var%id) 
     		end do

   	else if (var%grid(3) == 1) then 
     		do i = 0, margin_3
       		work_xz(:,:,plb3-i,var%id) = - work_xz(:,:,plb3+i+1,var%id) 
      	end do
   
    	end if
  
	end subroutine lower_boundary_noslip_z_xz


 	subroutine lower_boundary_noslip_z_yz(var) 
   	type(var_yz), intent(inout) :: var
   	integer :: i

   	if (var%grid(3) == 0) then 
    		work_yz(:,:,plb3,var%id) = 0.0D0 
     		do i = 1, margin_3
      		work_yz(:,:,plb3-i,var%id) = - work_yz(:,:,plb3+i,var%id) 
     		end do

   	else if (var%grid(3) == 1) then 
     		do i = 0, margin_3
       		work_yz(:,:,plb3-i,var%id) = - work_yz(:,:,plb3+i+1,var%id) 
      	end do
   
    	end if
  
	end subroutine lower_boundary_noslip_z_yz


 	subroutine lower_boundary_noslip_z_xyz(var) 
   	type(var_xyz), intent(inout) :: var
   	integer :: i

   	if (var%grid(3) == 0) then 
    		work_xyz(:,:,plb3,var%id) = 0.0D0 
     		do i = 1, margin_3
       		work_xyz(:,:,plb3-i,var%id) = - work_xyz(:,:,plb3+i,var%id) 
     		end do

   	else if (var%grid(3) == 1) then 
     		do i = 0, margin_3
       		work_xyz(:,:,plb3-i,var%id) = - work_xyz(:,:,plb3+i+1,var%id) 
      	end do
     
    	end if
  
	end subroutine lower_boundary_noslip_z_xyz


end module lower_boundary_noslip
