module gms_get_all
  use model_info
  use datatype
  use mem_manager
  implicit none

	interface get_all
		module procedure get_all_x
		module procedure get_all_y
		module procedure get_all_z
		module procedure get_all_xy
		module procedure get_all_xz
    	module procedure get_all_yz
		module procedure get_all_xyz 
  end interface

contains
	function get_all_x(input) result(output)
		type(var_x) ::input
		real(8), dimension(lb_axis1:ub_axis1) ::output

		output(lb_axis1:ub_axis1) = work_x(lb_axis1:ub_axis1,1,1,input%id)
  
	end function get_all_x


	function get_all_y(input) result(output)
		type(var_y) ::input
		real(8), dimension(lb_axis2:ub_axis2) ::output

		output(lb_axis2:ub_axis2) = work_y(1,lb_axis2:ub_axis2,1,input%id)
  
	end function get_all_y


	function get_all_z(input) result(output)
		type(var_z) ::input
		real(8), dimension(lb_axis3:ub_axis3) ::output

		output(lb_axis3:ub_axis3) = work_z(1,1,lb_axis3:ub_axis3,input%id)

	end function get_all_z


	function get_all_xy(input) result(output)
		type(var_xy) ::input
		real(8), dimension(lb_axis1:ub_axis1, lb_axis2:ub_axis2) ::output

		output(lb_axis1:ub_axis1, lb_axis2:ub_axis2) &
	= work_xy(lb_axis1:ub_axis1, lb_axis2:ub_axis2,1,input%id)
  
	end function get_all_xy


	function get_all_xz(input) result(output)
		type(var_xz) ::input
		real(8), dimension(lb_axis1:ub_axis1, lb_axis3:ub_axis3) ::output

		output(lb_axis1:ub_axis1, lb_axis3:ub_axis3) &
	= work_xz(lb_axis1:ub_axis1, 1, lb_axis3:ub_axis3,input%id)

  end function get_all_xz


	function get_all_yz(input) result(output)
		type(var_yz) ::input
		real(8), dimension(lb_axis2:ub_axis2, lb_axis3:ub_axis3) ::output

		output(lb_axis2:ub_axis2, lb_axis3:ub_axis3) &
	= work_xz(1,lb_axis2:ub_axis2, lb_axis3:ub_axis3,input%id)
 
	end function get_all_yz


	function get_all_xyz(input) result(output)
		type(var_xyz) ::input
		real(8), dimension(lb_axis1:ub_axis1, lb_axis2:ub_axis2, lb_axis3:ub_axis3) ::output

		output(lb_axis1:ub_axis1, lb_axis2:ub_axis2, lb_axis3:ub_axis3) &
	= work_xyz(lb_axis1:ub_axis1, lb_axis2:ub_axis2, lb_axis3:ub_axis3,input%id)
	
	end function get_all_xyz


end module gms_get_all
