module cyclic_boundary
  use datatype
  use model_info
  use mem_manager
  implicit none
  interface cyclic_boundary_x 
    module procedure cyclic_boundary_x_x, cyclic_boundary_x_xy, cyclic_boundary_x_xz, cyclic_boundary_x_xyz 
 end interface

  interface cyclic_boundary_y 
    module procedure cyclic_boundary_y_y, cyclic_boundary_y_xy, cyclic_boundary_y_yz, cyclic_boundary_y_xyz 
 end interface

  interface cyclic_boundary_z 
    module procedure cyclic_boundary_z_z, cyclic_boundary_z_xz, cyclic_boundary_z_yz, cyclic_boundary_z_xyz
 end interface

contains
  subroutine cyclic_boundary_x_x(var) 
    type(var_x), intent(inout) :: var
    integer :: i

    if (var%grid(1) == 0) then 
      do i = 1, margin_1
        work_x(plb1-i,:,:,var%id) = work_x(pub1-i,:,:,var%id) 
        work_x(pub1+i,:,:,var%id) = work_x(plb1+i,:,:,var%id) 
      end do

    else if (var%grid(1) == 1) then 
      do i = 0, margin_1
        work_x(plb1-i,:,:,var%id) = work_x(pub1-i,:,:,var%id) 
       end do
      do i = 1, margin_1
        work_x(pub1+i,:,:,var%id) = work_x(plb1+i,:,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_x_x

  subroutine cyclic_boundary_x_xy(var) 
    type(var_xy), intent(inout) :: var
    integer :: i

    if (var%grid(1) == 0) then 
      do i = 1, margin_1
        work_xy(plb1-i,:,:,var%id) = work_xy(pub1-i,:,:,var%id) 
        work_xy(pub1+i,:,:,var%id) = work_xy(plb1+i,:,:,var%id) 
      end do

    else if (var%grid(1) == 1) then 
      do i = 0, margin_1
        work_xy(plb1-i,:,:,var%id) = work_xy(pub1-i,:,:,var%id) 
       end do
      do i = 1, margin_1
        work_xy(pub1+i,:,:,var%id) = work_xy(plb1+i,:,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_x_xy

  subroutine cyclic_boundary_x_xz(var) 
    type(var_xz), intent(inout) :: var
    integer :: i

    if (var%grid(1) == 0) then 
      do i = 1, margin_1
        work_xz(plb1-i,:,:,var%id) = work_xz(pub1-i,:,:,var%id) 
        work_xz(pub1+i,:,:,var%id) = work_xz(plb1+i,:,:,var%id) 
      end do

    else if (var%grid(1) == 1) then 
      do i = 0, margin_1
        work_xz(plb1-i,:,:,var%id) = work_xz(pub1-i,:,:,var%id) 
       end do
      do i = 1, margin_1
        work_xz(pub1+i,:,:,var%id) = work_xz(plb1+i,:,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_x_xz

  subroutine cyclic_boundary_x_xyz(var) 
    type(var_xyz), intent(inout) :: var
    integer :: i

    if (var%grid(1) == 0) then 
      do i = 1, margin_1
        work_xyz(plb1-i,:,:,var%id) = work_xyz(pub1-i,:,:,var%id) 
        work_xyz(pub1+i,:,:,var%id) = work_xyz(plb1+i,:,:,var%id) 
      end do

    else if (var%grid(1) == 1) then 
      do i = 0, margin_1
        work_xyz(plb1-i,:,:,var%id) = work_xyz(pub1-i,:,:,var%id) 
       end do
      do i = 1, margin_1
        work_xyz(pub1+i,:,:,var%id) = work_xyz(plb1+i,:,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_x_xyz

  subroutine cyclic_boundary_y_y(var) 
    type(var_y), intent(inout) :: var
    integer :: i

    if (var%grid(2) == 0) then 
      do i = 1, margin_2
        work_y(:,plb2-i,:,var%id) = work_y(:,pub2-i,:,var%id) 
        work_y(:,pub2+i,:,var%id) = work_y(:,plb2+i,:,var%id) 
      end do

    else if (var%grid(2) == 1) then 
      do i = 0, margin_2
        work_y(:,plb2-i,:,var%id) = work_y(:,pub2-i,:,var%id) 
       end do
      do i = 1, margin_2
        work_y(:,pub2+i,:,var%id) = work_y(:,plb2+i,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_y_y

  subroutine cyclic_boundary_y_xy(var) 
    type(var_xy), intent(inout) :: var
    integer :: i

    if (var%grid(2) == 0) then 
      do i = 1, margin_2
        work_xy(:,plb2-i,:,var%id) = work_xy(:,pub2-i,:,var%id) 
        work_xy(:,pub2+i,:,var%id) = work_xy(:,plb2+i,:,var%id) 
      end do

    else if (var%grid(2) == 1) then 
      do i = 0, margin_2
        work_xy(:,plb2-i,:,var%id) = work_xy(:,pub2-i,:,var%id) 
       end do
      do i = 1, margin_2
        work_xy(:,pub2+i,:,var%id) = work_xy(:,plb2+i,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_y_xy

  subroutine cyclic_boundary_y_yz(var) 
    type(var_yz), intent(inout) :: var
    integer :: i

    if (var%grid(2) == 0) then 
      do i = 1, margin_2
        work_yz(:,plb2-i,:,var%id) = work_yz(:,pub2-i,:,var%id) 
        work_yz(:,pub2+i,:,var%id) = work_yz(:,plb2+i,:,var%id) 
      end do

    else if (var%grid(2) == 1) then 
      do i = 0, margin_2
        work_yz(:,plb2-i,:,var%id) = work_yz(:,pub2-i,:,var%id) 
       end do
      do i = 1, margin_2
        work_yz(:,pub2+i,:,var%id) = work_yz(:,plb2+i,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_y_yz

  subroutine cyclic_boundary_y_xyz(var) 
    type(var_xyz), intent(inout) :: var
    integer :: i

    if (var%grid(2) == 0) then 
      do i = 1, margin_2
        work_xyz(:,plb2-i,:,var%id) = work_xyz(:,pub2-i,:,var%id) 
        work_xyz(:,pub2+i,:,var%id) = work_xyz(:,plb2+i,:,var%id) 
      end do

    else if (var%grid(2) == 1) then 
      do i = 0, margin_2
        work_xyz(:,plb2-i,:,var%id) = work_xyz(:,pub2-i,:,var%id) 
       end do
      do i = 1, margin_2
        work_xyz(:,pub2+i,:,var%id) = work_xyz(:,plb2+i,:,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_y_xyz

  subroutine cyclic_boundary_z_z(var) 
    type(var_z), intent(inout) :: var
    integer :: i

    if (var%grid(3) == 0) then 
      do i = 1, margin_3
        work_z(:,:,plb3-i,var%id) = work_z(:,:,pub3-i,var%id) 
        work_z(:,:,pub3+i,var%id) = work_z(:,:,plb3+i,var%id) 
      end do

    else if (var%grid(3) == 1) then 
      do i = 0, margin_3
        work_z(:,:,plb3-i,var%id) = work_z(:,:,pub3-i,var%id) 
       end do
      do i = 1, margin_3
        work_z(:,:,pub3+i,var%id) = work_z(:,:,plb3+i,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_z_z

  subroutine cyclic_boundary_z_xz(var) 
    type(var_xz), intent(inout) :: var
    integer :: i

    if (var%grid(3) == 0) then 
      do i = 1, margin_3
        work_xz(:,:,plb3-i,var%id) = work_xz(:,:,pub3-i,var%id) 
        work_xz(:,:,pub3+i,var%id) = work_xz(:,:,plb3+i,var%id) 
      end do

    else if (var%grid(3) == 1) then 
      do i = 0, margin_3
        work_xz(:,:,plb3-i,var%id) = work_xz(:,:,pub3-i,var%id) 
       end do
      do i = 1, margin_3
        work_xz(:,:,pub3+i,var%id) = work_xz(:,:,plb3+i,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_z_xz

  subroutine cyclic_boundary_z_yz(var) 
    type(var_yz), intent(inout) :: var
    integer :: i

    if (var%grid(3) == 0) then 
      do i = 1, margin_3
        work_yz(:,:,plb3-i,var%id) = work_yz(:,:,pub3-i,var%id) 
        work_yz(:,:,pub3+i,var%id) = work_yz(:,:,plb3+i,var%id) 
      end do

    else if (var%grid(3) == 1) then 
      do i = 0, margin_3
        work_yz(:,:,plb3-i,var%id) = work_yz(:,:,pub3-i,var%id) 
       end do
      do i = 1, margin_3
        work_yz(:,:,pub3+i,var%id) = work_yz(:,:,plb3+i,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_z_yz

  subroutine cyclic_boundary_z_xyz(var) 
    type(var_xyz), intent(inout) :: var
    integer :: i

    if (var%grid(3) == 0) then 
      do i = 1, margin_3
        work_xyz(:,:,plb3-i,var%id) = work_xyz(:,:,pub3-i,var%id) 
        work_xyz(:,:,pub3+i,var%id) = work_xyz(:,:,plb3+i,var%id) 
      end do

    else if (var%grid(3) == 1) then 
      do i = 0, margin_3
        work_xyz(:,:,plb3-i,var%id) = work_xyz(:,:,pub3-i,var%id) 
       end do
      do i = 1, margin_3
        work_xyz(:,:,pub3+i,var%id) = work_xyz(:,:,plb3+i,var%id) 
       end do
     end if
  end subroutine cyclic_boundary_z_xyz

end module cyclic_boundary
