!= Module BasicEnvInit
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: initialdata_toon2002.f90,v 1.2 2011-06-25 14:47:29 sugiyama Exp $
! Tag Name::  $Name: arare5-20120511 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǥեȤδܾꤹ뤿ѿȷ⥸塼
!   * BasicEnvFile_init: ܾͤ netCDF ե뤫
!   * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
module initialdata_odaka1998
  !
  !ǥեȤδܾꤹ뤿Υ֥롼. 
  !ܾ׻, BasicSet ⥸塼ͤ. 
  !
  !ѥν꤫, ܾ(hogeBasicZ ѿ)
  !׻ʬBasicSet ⥸塼뤫ڤΥƤ. 
  !ECCM Ϥ, BasicSet Τ˰¸뤬 hogeBasicZ  use ʤ
  !֥롼Ѥ뤿Ǥ. 
  !

  !⥸塼ɤ߹
  use dc_types,   only: STRING, DP
  use dc_iounit,   only : FileOpen      
  use dc_message, only: MessageNotify
!  use mpi_wrapper, only: myrank         
  use gridset,  only: kmin,       &! Z β
    &                 kmax,       &! Z ξ
    &                 nz
  use axesset, only:  z_Z,        &!顼ʻǤι
    &                 z_dz,       &!Z γʻֳ
    &                 r_dz         !Z γʻֳ(wʻ)
  use constants, only: &
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 Grav,          &!ϲ®
    &                 TempSfc,       &!ɽ̲
    &                 PressSfc        !ɽ̰
 
  !ۤηػ
  implicit none

  !ǥեȤ private
  private

  real(DP), parameter  :: AntA    = 27.4d0 
  real(DP), parameter  :: AntB    = 3103.0d0
  real(DP), parameter  :: TempLTP = 135.0d0
  real(DP), parameter  :: Dhight  = 6.0d2

  !
  public  initialdata_odaka1998_basic

contains

!!!------------------------------------------------------------------------------!!!

  subroutine initialdata_odaka1998_basic( z_Temp, z_Press )

    implicit none
    
    real(DP), intent(out):: z_Press(kmin:kmax) !
    real(DP), intent(out):: z_Temp(kmin:kmax)  !
    real(DP)             :: z_logP(kmin:kmax)
    real(DP)             :: TempStrt = 220.0d0 !ط
    integer              :: k
    

    ! Ǯ˱äʬۤη׻
    ! 
    z_Temp = TempSfc - z_Z * Grav / CpDry 

    ! ط٤㲹ΰǤط٤
    z_Temp = Max( TempStrt, z_Temp )

    ! Ϥη׻
    ! * ſ尵ʿդμ鰵Ϥ
    ! * 
    ! 
    z_LogP(1) = - 0.5d0*Grav/GasRDry * &
      &  (z_Temp(1) + TempSfc)/(z_Temp(1)*TempSfc)*0.5d0*z_dz(1)

    do k = 2, nz
      z_LogP(k) = z_LogP(k-1) - &
        & 0.5d0*Grav/GasRDry *  &
        & (z_Temp(k) + z_Temp(k-1))/(z_Temp(k)*z_Temp(k-1))*r_dz(k-1)
    end do
   
    z_Press = PressSfc * exp(z_LogP)

  end subroutine initialdata_odaka1998_basic
  
end module initialdata_odaka1998
