!= ͥեå
!
!= Set solar constant
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_solarconst.f90,v 1.2 2013-03-01 14:14:16 yot Exp $
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module set_solarconst
  !
  != ͥեå
  !
  != Set solar constant
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== References
  !
!!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling 
!!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#set_solarconst_nml
  !

  ! USE statements
  !

  ! 
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify


  ! Declaration statements
  !
  implicit none
  private

  ! 
  ! Public procedure
  !
  public:: SetSolarConst
  public:: SetSolarConstInit


  character(*), parameter:: module_name = 'set_solarconst'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: set_solarconst.f90,v 1.2 2013-03-01 14:14:16 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  real(DP), save         :: SolarConst

  character(STRING), save:: SolarConstFile
  character(STRING), save:: SolarConstVarName

  logical, save :: set_solarconst_inited = .false.
                              ! ե饰.
                              ! Initialization flag

contains

  !--------------------------------------------------------------------------------------

  subroutine SetSolarConst( &
    & SolarFlux             & ! (out)
    & )


    ! USE statements
    !

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & TimesetClockStart, TimesetClockStop

    ! ǡɤ߹
    ! Reading time series
    !
    use read_time_series, only: SetValuesFromTimeSeriesWrapper


    real(DP), intent(out):: SolarFlux


    !
    ! Work variables
    !


    ! ǧ
    ! Initialization check
    !
    if ( .not. set_solarconst_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    if ( SolarConstFile == '' ) then

      SolarFlux = SolarConst

    else

      call SetValuesFromTimeSeriesWrapper(   &
        & "SolarConst",                      &
        & SolarConstFile, SolarConstVarName, &
        & SolarFlux                          & ! (inout)
        & )

    end if


    call HistoryAutoPut( TimeN, "SolarConst", SolarFlux )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )


  end subroutine SetSolarConst

  !--------------------------------------------------------------------------------------

  subroutine SetSolarConstInit


    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid


    !
    ! Work variables
    !
    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /set_solarconst_nml/ &
      & SolarConst,     &
      & SolarConstFile, &
      & SolarConstVarName
          !
          ! ǥեͤˤĤƤϽ³ "set_solarconst#SetSolarConstInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "set_solarconst#SetSolarConstInit" for the default values.
          !

    if ( set_solarconst_inited ) return


    ! ǥեͤ
    ! Default values settings
    !

!!$    SolarConst     = 1380.0_DP
    SolarConst        = 1366.0_DP

    SolarConstFile    = ''
    SolarConstVarName = "SolarConst"


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = set_solarconst_nml,       & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    call HistoryAutoAddVariable( "SolarConst", & ! (in)
      & (/ 'time' /),                          & ! (in)
      & "solar constant", 'W m-2' )              ! (in)

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  SolarConst        = %f', d = (/ SolarConst /) )
    call MessageNotify( 'M', module_name, '  SolarConstFile    = %c', c1 = trim( SolarConstFile ) )
    call MessageNotify( 'M', module_name, '  SolarConstVarName = %c', c1 = trim( SolarConstVarName ) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    set_solarconst_inited = .true.

  end subroutine SetSolarConstInit

  !--------------------------------------------------------------------------------------

end module set_solarconst
