!= ׻ѶֳǮΨ׻
!
!= Calculation of near infrared heating rate in the case of Mars
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: rad_Mars_NIR.f90,v 1.4 2012-10-08 12:48:44 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module rad_Mars_NIR
  !
  != ׻ѶֳǮΨ׻
  !
  != Calculation of near infrared heating rate in the case of Mars
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
!!$  ! DryConvAdjust :: ήĴ
!!$  ! ------------  :: ------------
!!$  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#rad_M_NIR_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: RadMarsNIRInit
  public :: RadMarsNIR
  public :: RadMarsNIRINOUT

  ! ѿ
  ! Public variables
  !
  logical, save, public:: rad_Mars_NIR_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  logical, save:: FlagUse
                              ! ѥե饰
                              ! flag for use of this scheme

  character(*), parameter:: module_name = 'rad_Mars_NIR'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: rad_Mars_NIR.f90,v 1.4 2012-10-08 12:48:44 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  subroutine RadMarsNIR(         &
    & xyz_Press,                 &  ! (in)
    & xyz_DTempDt                &  ! (out)
    & )
    !
    ! ׻ѶֳǮΨ׻
    !
    ! Calculation of near infrared heating rate in the case of Mars
    !
    ! Calculation schume of solar nir infrared heating rate follows
    ! that shown in Forget et al., 1999


    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalInquire

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncome


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in ):: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(out):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency

    ! ѿ
    ! Work variables
    !
    real(DP) :: qnir0
    real(DP) :: RefPress
    real(DP) :: NLTEPress

    integer  :: hour_in_day
    integer  :: min_in_hour
    real(DP) :: sec_in_min

    real(DP) :: DistFromStarScld
    real(DP) :: DiurnalMeanFactor
    real(DP) :: xy_CosZet  (0:imax-1, 1:jmax)
    real(DP) :: xy_CosZetSq(0:imax-1, 1:jmax)

    real(DP) :: MuFac

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. rad_Mars_NIR_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    call DCCalInquire( &
      & hour_in_day      = hour_in_day  , &     ! (out)
      & min_in_hour      = min_in_hour  , &     ! (out)
      & sec_in_min       = sec_in_min     &     ! (out)
      & )

    ! constants
    !
    qnir0     = 1.3_DP / ( hour_in_day * min_in_hour * sec_in_min )
    RefPress  = 700.0_DP
    NLTEPress = 0.0075_DP


    call RadShortIncome( &
      & DistFromStarScld   = DistFromStarScld,   & ! (out) optional
      & xy_CosZet          = xy_CosZet,          & ! (out) optional
      & DiurnalMeanFactor  = DiurnalMeanFactor,  & ! (out) optional
      & FlagOutput         = .false.             & ! (in)  optional
      & )

    xy_CosZetSq = xy_CosZet**2

    do j = 1, jmax
      do i = 0, imax-1

        if( xy_CosZet(i,j) < 0.0_DP ) then
          do k = 1, kmax
            xyz_DTempDt(i,j,k) = 0.0_DP
          end do
        else
          MuFac = sqrt( ( 1224.0_DP * xy_CosZetSq(i,j) + 1.0d0 ) / 1225.0_DP )
          do k = 1, kmax
            xyz_DTempDt(i,j,k) = &
              & qnir0 / DistFromStarScld**2 &
              & * sqrt( RefPress / xyz_Press(i,j,k) * MuFac ) &
              & / ( 1.0d0 + NLTEPress / xyz_Press(i,j,k) )
          end do
        end if

      end do
    end do

    xyz_DTempDt = xyz_DTempDt * DiurnalMeanFactor


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DTempDtMNIR', xyz_DTempDt )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine RadMarsNIR

  !-------------------------------------------------------------------

  subroutine RadMarsNIRINOUT(  &
    & xyz_Press,                 &  ! (in   )
    & xyz_DTempDt                &  ! (inout)
    & )
    !
    ! ׻ѶֳǮΨ׻
    !
    ! Calculation of near infrared heating rate in the case of Mars
    !
    ! Calculation schume of solar nir infrared heating rate follows
    ! that shown in Forget et al., 1999


    ! ⥸塼 ; USE statements
    !


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(inout):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency

    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_DTempDtLocal(0:imax-1, 1:jmax, 1:kmax)

    ! ¹ʸ ; Executable statement
    !


    ! 
    ! Initialization
    !
    if ( .not. rad_Mars_NIR_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    call RadMarsNIR(         &
      & xyz_Press,           &  ! (in )
      & xyz_DTempDtLocal     &  ! (out)
      & )

    xyz_DTempDt = xyz_DTempDt + xyz_DTempDtLocal


  end subroutine RadMarsNIRINOUT

  !-------------------------------------------------------------------

  subroutine RadMarsNIRInit
    !
    ! rad_Mars_NIR ⥸塼νԤޤ. 
    ! NAMELIST#rad_Mars_NIR_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "rad_Mars_NIR" module is initialized. 
    ! "NAMELIST#rad_Mars_NIR_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & AxnameX, &
      & AxnameY, &
      & AxnameZ, &
      & AxnameT

    ! û ()
    ! Short wave (insolation) incoming
    !
    use rad_short_income, only : RadShortIncomeInit

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /rad_Mars_NIR_nml/ &
      & FlagUse

          ! ǥեͤˤĤƤϽ³ "dry_conv_adjust#DryConvAdjustInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "dry_conv_adjust#DryConvAdjustInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( rad_Mars_NIR_inited ) return

    ! ǥեͤ
    ! Default values settings
    !
    FlagUse = .true.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                &  ! (in)
        & nml = rad_Mars_NIR_nml,    &  ! (out)
        & iostat = iostat_nml )         ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DTempDtMNIR',    &
      & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),  &
      & 'near infrared heating rate', 'K s-1' )



    ! Initialization of modules used in this module
    !

    ! û ()
    ! Short wave (insolation) incoming
    !
    call RadShortIncomeInit



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FlagUse    = %b', l = (/ FlagUse /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    rad_Mars_NIR_inited = .true.

  end subroutine RadMarsNIRInit

  !-------------------------------------------------------------------

end module rad_Mars_NIR
