!= 絬϶ŷ (ήŷ) (Manabe et al., 1965)
!
!= Large scale condensation (non-convective condensation) (Manabe et al., 1965)
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. Takahashi
! Version::   $Id: lscond.f90,v 1.14 2012-11-10 12:53:10 yot Exp $ 
! Tag Name::  $Name: dcpam5-20130302 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module lscond
  !
  != 絬϶ŷ (ήŷ)
  !
  != Large scale condensation (non-convective condensation)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 絬϶ŷˤäƲ٤漾Ĵᤷޤ. 
  !
  ! Adjust temperature and specific humidity by 
  ! a large scale condensation process.
  !
  !== References
  !
  !  Manabe, S., J. Smagorinsky, R. F. Strickler,
  !    Simulated climatology of a general circulation model with a hydrologic cycle,
  !    Mon. Wea. Rev., 93, 769-798, 1965.
  !
  !== Procedures List
  ! 
  ! LScaleCond    :: ٤漾Ĵ
  ! ------------  :: ------------
  ! LScaleCond    :: Adjust temperature and specific humidity
  !
  !== NAMELIST
  !
  ! NAMELIST#lscond_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: LScaleCond
  public:: LScaleCondInit

  ! ѿ
  ! Public variables
  !
  logical, save :: lscond_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !
  real(DP), save:: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
  integer, save:: ItrtMax
                              ! ƥ졼. 
                              ! Number of iteration
  logical, save:: FlagUse
                              ! ѥե饰
                              ! flag for use of this scheme

  character(*), parameter:: module_name = 'lscond'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20130302 $' // &
    & '$Id: lscond.f90,v 1.14 2012-11-10 12:53:10 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine LScaleCond(        &
    & xyz_Temp, xyz_QVap,       &  ! (inout)
    & xyz_DTempDt, xyz_DQVapDt, &  ! (inout)
    & xyz_Press, xyr_Press,     &  ! (in)
    & xyz_DQH2OLiqDt            &  ! (out)
    & )
    !
    ! 絬϶ŷ륹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! Adjust temperature and specific humidity by 
    ! large scale condensation scheme. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(inout):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP), intent(inout):: xyz_DQVapDt (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency
    real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)


    ! ѿ
    ! Work variables
    !
    real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
                              ! ߿. 
                              ! Precipitation
    real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency

    real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
                              !
    real(DP):: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DD{q_{\rm{sat}}}{T} $
    real(DP):: DelTemp
                              ! Ĵˤ벹Ѳ. 
                              ! Temperature variation by adjustment

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction

    real(DP):: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)

    real(DP):: TempBefAdj
    real(DP):: QVapBefAdj

    logical:: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. lscond_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    if ( .not. FlagUse ) return


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! Ĵ "QVap", "Temp" ¸
    ! Store "QVap", "Temp" before adjustment
    !
    xyz_QVapB  = xyz_QVap
    xyz_TempB  = xyz_Temp


    ! Ĵ
    ! Adjustment
    !

    ! ˰漾׻
    ! Calculate saturation specific humidity 
    !
    xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )

    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1

          if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
            xyz_FlagSaturated(i,j,k) = .true.
          else
            xyz_FlagSaturated(i,j,k) = .false.
          end if

        end do
      end do
    end do

    do itr = 1, ItrtMax

      ! ˰漾׻
      ! Calculate saturation specific humidity
      !
      xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_Temp, xyz_Press   )
      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )

      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax-1

            ! ˰¤Ƥ, ٤漾Ѳ׻
            ! Calculate tendency of temperature and humidity 
            ! if moist is saturation. 
            !
            if ( xyz_FlagSaturated(i,j,k) ) then

              ! ٤Ѳʬ˥塼ȥˡǵ
              ! Calculate variation of temperature
              !
!!$              DelTemp = &
!!$                & LatentHeat * ( xyz_QVap(i,j,k) - xyz_QVapSat(i,j,k) ) &
!!$                &    / ( CpDry + LatentHeat * xyz_DQVapSatDTemp(i,j,k) )
              DelTemp =                                                 &
                & LatentHeat                                            &
                &   * ( xyz_QVap(i,j,k) - CrtlRH * xyz_QVapSat(i,j,k) ) &
                &   / ( CpDry + LatentHeat * CrtlRH * xyz_DQVapSatDTemp(i,j,k) )


              !=========
              ! check routine
              !---------
!!$              TempBefAdj = xyz_Temp(i,j,k)
!!$              QVapBefAdj = xyz_QVap(i,j,k)
              !=========

              ! ٤漾Ĵ
              ! Adjust temperature and specific humidity
              !
              xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
!!$              xyz_QVap(i,j,k) = xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp
              xyz_QVap(i,j,k) = &
                & CrtlRH * ( xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp )

              !=========
              ! check routine
              !---------
!!$              write( 6, * ) '====='
!!$              write( 6, * ) 'Energy difference before and after adjustment and each energy'
!!$              write( 6, * ) &
!!$                &     CpDry * TempBefAdj      + LatentHeat * QVapBefAdj            &
!!$                & - ( CpDry * xyz_Temp(i,j,k) + LatentHeat * xyz_QVap(i,j,k) ),    &
!!$                &     CpDry * TempBefAdj      + LatentHeat * QVapBefAdj,           &
!!$                &   ( CpDry * xyz_Temp(i,j,k) + LatentHeat * xyz_QVap(i,j,k) )
              !=========


            end if

          end do
        end do
      end do

    end do

    ! 漾ѲΨ, ѲΨ, ߿̤λ
    ! Calculate specific humidity tendency, temperature tendency, 
    ! precipitation
    !
    xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
    xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    xyz_DTempDt = xyz_DTempDt + xyz_DTempDtLsc
    xyz_DQVapDt = xyz_DQVapDt + xyz_DQVapDtLsc


    xyz_DQH2OLiqDt = - xyz_DQVapDtLsc


    ! calculation for output
    xy_RainLsc     = 0.0d0
    do k = kmax, 1, -1
      xy_RainLsc = xy_RainLsc                                     &
        & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'RainLsc',    xy_RainLsc * LatentHeat )
    call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
    call HistoryAutoPut( TimeN, 'DQVapDtLsc', xyz_DQVapDtLsc )



    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine LScaleCond

  !--------------------------------------------------------------------------------------

  subroutine LScaleCondInit
    !
    ! lscond ⥸塼νԤޤ. 
    ! NAMELIST#lscond_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "lscond" module is initialized. 
    ! "NAMELIST#lscond_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /lscond_nml/ &
      & CrtlRH, ItrtMax, FlagUse
          !
          ! ǥեͤˤĤƤϽ³ "lscond#LSCondInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "lscond#LSCondInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( lscond_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    CrtlRH  = 1.0_DP
    ItrtMax = 3
    FlagUse = .true.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = lscond_nml, &   ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
    end if

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'RainLsc', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'precipitation by large scale condensation', 'W m-2' )
    call HistoryAutoAddVariable( 'DTempDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation heating', 'K s-1' )
    call HistoryAutoAddVariable( 'DQVapDtLsc', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'large-scale condensation moistening', 'kg kg-1 s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FlagUse = %b', l = (/ FlagUse /) )
    call MessageNotify( 'M', module_name, '  CrtlRH  = %f', d = (/ CrtlRH /) )
    call MessageNotify( 'M', module_name, '  ItrtMax = %d', i = (/ ItrtMax /) )
    call MessageNotify( 'M', module_name, '' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    lscond_inited = .true.

  end subroutine LScaleCondInit

  !--------------------------------------------------------------------------------------

end module lscond
