
  subroutine xyz_CalcQVapSat( is, ie, js, je, ks, ke, xyz_Temp, xyz_Press, FillValue, xyz_QVapSat )
    !
    !  *Temp* ȵ *Press* Ѥ, 
    ! ˰漾 *QVapSat* ޤ. 
    !
    ! Calculate saturation specific humidity *QVapSat* using
    ! temperature *Temp* and air pressure *Press*. 
    !

    ! ⥸塼 ; USE statements
    !
    use vtype_module


    ! ʸ ; Declaration statements
    !
    implicit none

    integer , intent(in):: is
    integer , intent(in):: ie
    integer , intent(in):: js
    integer , intent(in):: je
    integer , intent(in):: ks
    integer , intent(in):: ke
    real(DP), intent(in):: xyz_Temp (is:ie, js:je, ks:ke)
                              ! $ T $ . . Temperature
    real(DP), intent(in):: xyz_Press(is:ie, js:je, ks:ke)
                              ! $ p $ . . Air pressure
    real(DP), intent(in):: FillValue

    real(DP), intent(out):: xyz_QVapSat(is:ie, js:je, ks:ke)
                              ! $ q^{*} $ . ˰漾. Saturation specific humidity


    ! ѿ
    ! Work variables
    !
    real(dp), parameter:: Es0 = 611.0_DP
                              ! 0 ˰¾ [Pa]. 
                              ! Saturation water vapor pressure at 0 deg C [Pa]
    real(dp), parameter:: GasRUniv = 8.314_DP
    real(dp), parameter:: MolWtDry = 28.964e-3_DP
    real(dp), parameter:: MolWtWet = 18.01528e-3_DP
    real(dp), parameter:: LatentHeat = 2.5e6_DP
!!$    real(dp), parameter:: LatentHeat = 2.5e6_DP + 334.0d3

    real(dp) :: GasRWet
    real(dp) :: EpsV

    integer :: i, j, k

    GasRWet          = GasRUniv / MolWtWet
    EpsV             = MolWtWet / MolWtDry

    ! ¹ʸ ; Executable statement
    !

    do k = ks, ke
      do j = js, je
        do i = is, ie
          if ( xyz_Temp(i,j,k) /= FillValue ) then
            xyz_QVapSat(i,j,k) = &
              & EpsV * Es0 * exp( LatentHeat / GasRWet * ( 1./273. - 1./xyz_Temp(i,j,k) ) ) &
              & / xyz_Press(i,j,k)
          else
            xyz_QVapSat(i,j,k) = FillValue
          end if
        end do
      end do
    end do


  end subroutine xyz_CalcQVapSat

