!= եå
!
!= Lower boundary flux
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: lb_flux_simple.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $ 
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module lb_flux_simple
  !
  != եå
  !
  != Lower boundary flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== References
  !
!!$  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn, 
!!$  ! A short history of the PBL parameterization at ECMWF, 
!!$  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K., 
!!$  ! 1982.
  !
  !== Procedures List
  !
!!$  ! SurfaceFlux       :: ɽ̥եåη׻
!!$  ! SurfaceFluxOutput :: ɽ̥եåν
!!$  ! ------------      :: ------------
!!$  ! SurfaceFlux       :: Calculate surface fluxes
!!$  ! SurfaceFluxOutput :: Output surface fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#lb_flux_simple_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ˴ؤ
  ! Settings of array for atmospheric composition
  !
  use composition, only: ncmax, IndexH2OVap

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: LBFluxSimple
  public :: LBFluxSimpleInit
!!$  public :: SurfaceFluxOutput

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: lb_flux_simple_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  integer, save      :: IDLBMomFluxMode
  integer, parameter :: IDLBMomFluxModeNoFlux       = 10
  integer, parameter :: IDLBMomFluxModeFixTimeConst = 11
  integer, save      :: IDLBHeatFluxMode
  integer, parameter :: IDLBHeatFluxModeFixFlux     = 20
  integer, parameter :: IDLBHeatFluxModeFixTemp     = 21
  integer, save      :: IDLBH2OVapFluxMode
  integer, parameter :: IDLBH2OVapFluxModeFixFlux   = 30
  integer, parameter :: IDLBH2OVapFluxModeFixMixRt  = 31


  real(DP), save:: FricTimeConstAtLB
                            ! ໤η (s).
                            ! Time constant of surface friction (s).
  real(DP), save:: FricLowestLatAtLB
                            ! ໤Ư (degree).
                            ! Lowest latitude where the friction is applied (degree)
  real(DP), save:: HeatFluxAtLB
                            ! ǤǮեå (W m-2).
                            ! Heat flux at the lower boundary (W m-2).
  real(DP), save:: TempAtLB
  real(DP), save:: H2OVapFluxAtLB
                            ! Ǥ H2O ̥եå (W m-2).
                            ! ºݤˤϥ˸ꤹ뤿˻Ȥ٤ˤȤʤ.
                            ! H2O vapor flux at the lower boundary (kg m-2 s-1).
  real(DP), save:: QH2OVapAtLB
  real(DP), save:: DiffCoefHeatMass


  character(*), parameter:: module_name = 'lb_flux_simple'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: lb_flux_simple.f90,v 1.2 2014/05/07 09:39:22 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  !--------------------------------------------------------------------------------------

  subroutine LBFluxSimple( &
    & xyz_U, xyz_V, xyz_Temp, xyr_VirTemp, xyzf_QMix,             & ! (in)
    & xyr_Press, xy_SurfHeight, xyz_Height, xyz_Exner, xyr_Exner, & ! (in)
    & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux,    & ! (out)
    & xy_SurfVelTransCoef, xy_SurfTempTransCoef,                  & ! (out)
    & xy_SurfQVapTransCoef                                        & ! (out)
    & )
    !
    ! , 漾, , ͥեå׻ޤ. 
    !
    ! Calculate radiation flux from temperature, specific humidity, and 
    ! air pressure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI
                              ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &               ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xy_CalcQVapSat

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat                 ! $ \varphi $ [rad.] . . Latitude

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! ʸ ; Declaration statements
    !

    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. Northward wind

    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .  (٥). 
                              ! Temperature (full level)
    real(DP), intent(in):: xyr_VirTemp (0:imax-1, 1:jmax, 0:kmax)
                              ! $ T_v $ .  (Ⱦ٥). 
                              ! Virtual temperature (half level)
    real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ p_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(in):: xy_SurfHeight(0:imax-1,1:jmax)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 
    real(DP), intent(in):: xyz_Height (0:imax-1, 1:jmax, 1:kmax)
                              !  (٥). 
                              ! Height (full level)
    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)
    real(DP), intent(out):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:0)
                              ! ư̥եå. 
                              ! Eastward momentum flux
    real(DP), intent(out):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:0)
                              ! ư̥եå. 
                              ! Northward momentum flux
    real(DP), intent(out):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:0)
                              ! Ǯեå. 
                              ! Heat flux
    real(DP), intent(out):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:0, 1:ncmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(out):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
    real(DP), intent(out):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(out):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
                              ! ͢
                              ! Transfer coefficient: water vapor

    ! ѿ
    ! Work variables
    !
    real(DP) :: xy_TempAtLB   (0:imax-1, 1:jmax)
    real(DP) :: xy_QH2OVapAtLB(0:imax-1, 1:jmax)

    integer:: j
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. lb_flux_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! ͢η׻
    ! Calculate transfer coefficient
    !
    select case ( IDLBMomFluxMode )
    case ( IDLBMomFluxModeNoFlux )
      xy_SurfVelTransCoef = 0.0_DP
    case ( IDLBMomFluxModeFixTimeConst )
      if ( FricTimeConstAtLB <= 0.0_DP ) then
        call MessageNotify( 'E', module_name, 'FricTimeConstAtLB must be greater than or equal to zero.' )
      end if
      do j = 1, jmax
        if ( abs( y_Lat(j) ) >= FricLowestLatAtLB * PI / 180.0_DP ) then
          xy_SurfVelTransCoef(:,j) =                           &
            & - ( xyr_Press(:,j,1) - xyr_Press(:,j,0) ) / Grav &
            &   / FricTimeConstAtLB
        else
          xy_SurfVelTransCoef(:,j) = 0.0_DP
        end if
      end do
    end select

    select case ( IDLBHeatFluxMode )
    case ( IDLBHeatFluxModeFixFlux )
      xy_SurfTempTransCoef = HeatFluxAtLB
    case ( IDLBHeatFluxModeFixTemp )
      xy_SurfTempTransCoef =                                    &
        &   xyr_Press(:,:,0) / ( GasRDry * xyr_VirTemp(:,:,0) ) &
        & * DiffCoefHeatMass                                    &
        & / ( xyz_Height(:,:,1) - xy_SurfHeight )
    end select

    select case( IDLBH2OVapFluxMode )
    case ( IDLBH2OVapFluxModeFixFlux )
      xy_SurfQVapTransCoef = H2OVapFluxAtLB
    case ( IDLBH2OVapFluxModeFixMixRt )
      xy_SurfQVapTransCoef =                                    &
        &   xyr_Press(:,:,0) / ( GasRDry * xyr_VirTemp(:,:,0) ) &
        & * DiffCoefHeatMass                                    &
        & / ( xyz_Height(:,:,1) - xy_SurfHeight )
    end select


    ! եåη׻
    ! Calculate fluxes at lower boundary
    !
    !   Momentum
    !
    xyr_MomFluxX(:,:,0) = - xy_SurfVelTransCoef * xyz_U(:,:,1)
    xyr_MomFluxY(:,:,0) = - xy_SurfVelTransCoef * xyz_V(:,:,1)

    !   Heat
    !
    select case ( IDLBHeatFluxMode )
    case ( IDLBHeatFluxModeFixFlux )
      xyr_HeatFlux = HeatFluxAtLB
    case ( IDLBHeatFluxModeFixTemp )
      xy_TempAtLB = TempAtLB
      xyr_HeatFlux(:,:,0) = - CpDry * xyr_Exner(:,:,0) * xy_SurfTempTransCoef &
        &                       * (   xyz_Temp(:,:,1) / xyz_Exner(:,:,1)      &
        &                           - xy_TempAtLB     / xyr_Exner(:,:,0) )
    end select

    !   Mass
    !
    select case( IDLBH2OVapFluxMode )
    case ( IDLBH2OVapFluxModeFixFlux )
      xyrf_QMixFlux(:,:,0,IndexH2OVap) = H2OVapFluxAtLB
    case ( IDLBH2OVapFluxModeFixMixRt )
      xy_QH2OVapAtLB = QH2OVapAtLB
      xyrf_QMixFlux(:,:,0,IndexH2OVap) =                      &
        & - xy_SurfQVapTransCoef                              &
        & * ( xyzf_QMix(:,:,1,IndexH2OVap) - xy_QH2OVapAtLB )
    end select
    !
    xyrf_QMixFlux(:,:,0,1:IndexH2OVap-1)     = 0.0_DP
    xyrf_QMixFlux(:,:,0,IndexH2OVap+1:ncmax) = 0.0_DP

    ! Surface flux of constituents except for water vapor is zero.
!!$    write( 6, * ) "MEMO: Surface flux of constituents except for water vapor is zero. (YOT, 2013/05/15)"


    ! ҥȥǡ
    ! History data output
    !

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine LBFluxSimple

  !--------------------------------------------------------------------------------------

  subroutine SurfaceFluxOutput(                                &
    & xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux, & ! (in)
    & xy_SurfH2OVapFluxA, xy_SurfLatentHeatFluxA,              & ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, xyzf_DQMixDt,           & ! (in)
    & xy_SurfTemp, xy_DSurfTempDt,                             & ! (in)
    & xyr_Press, xyz_Exner, xyr_Exner, xy_SurfHumidCoef,       & ! (in)
    & xy_SurfVelTransCoef, xy_SurfTempTransCoef,               & ! (in)
    & xy_SurfQVapTransCoef                                     & ! (in)
    & )
    !
    ! եå (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux). 
    ! ˤĤ, ¾ΰѤ, ϤԤ. 
    !
    ! Fluxes (xyr_MomFluxX, xyr_MomFluxY, xyr_HeatFlux, xyrf_QMixFlux) are
    ! corrected by using other arguments, and the corrected values are output.
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constant settings
    !
    use constants, only: &
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! ˰漾λ
    ! Evaluation of saturation specific humidity
    !
    use saturate, only: xy_CalcQVapSat, xy_CalcDQVapSatDTemp

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !

    real(DP), intent(in):: xyr_MomFluxX (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Eastward momentum flux
    real(DP), intent(in):: xyr_MomFluxY (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Northward momentum flux
    real(DP), intent(in):: xyr_HeatFlux (0:imax-1, 1:jmax, 0:kmax)
                              ! Ǯեå. 
                              ! Heat flux
    real(DP), intent(in):: xyrf_QMixFlux(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(in):: xy_SurfH2OVapFluxA    (0:imax-1, 1:jmax)
                              ! ɽ̿եå.
                              ! Water vapor flux at the surface
    real(DP), intent(in):: xy_SurfLatentHeatFluxA(0:imax-1, 1:jmax)
                              ! ɽǮեå.
                              ! Latent heat flux at the surface
    real(DP), intent(in):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®ѲΨ. 
                              ! Eastward wind tendency
    real(DP), intent(in):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®ѲΨ. 
                              ! Northward wind tendency
    real(DP), intent(in):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . ٻѲΨ. 
                              ! Temperature tendency
    real(DP), intent(in):: xyzf_DQMixDt(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ \DP{q}{t} $ . 漾ѲΨ. 
                              ! Specific humidity tendency
    real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature
    real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ٻѲΨ. 
                              ! Surface temperature tendency
    real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in):: xyz_Exner (0:imax-1, 1:jmax, 1:kmax)
                              ! Exner ؿ (٥). 
                              ! Exner function (full level)
    real(DP), intent(in):: xyr_Exner (0:imax-1, 1:jmax, 0:kmax)
                              ! Exner ؿ (Ⱦ٥). 
                              ! Exner function (half level)
    real(DP), intent(in):: xy_SurfHumidCoef (0:imax-1, 1:jmax)
                              ! ɽ. 
                              ! Surface humidity coefficient
    real(DP), intent(in):: xy_SurfVelTransCoef (0:imax-1, 1:jmax)
                              ! ͢ư. 
                              ! Diffusion coefficient: velocity
    real(DP), intent(in):: xy_SurfTempTransCoef (0:imax-1, 1:jmax)
                              ! ͢. 
                              ! Transfer coefficient: temperature
    real(DP), intent(in):: xy_SurfQVapTransCoef (0:imax-1, 1:jmax)
                              ! ͢
                              ! Transfer coefficient: water vapor

    ! ϤΤκѿ
    ! Work variables for output
    !
    real(DP):: xyr_MomFluxXCor (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Eastward momentum flux
    real(DP):: xyr_MomFluxYCor (0:imax-1, 1:jmax, 0:kmax)
                              ! ư̥եå. 
                              ! Northward momentum flux
    real(DP):: xyr_HeatFluxCor (0:imax-1, 1:jmax, 0:kmax)
                              ! Ǯեå. 
                              ! Heat flux
    real(DP):: xyrf_QMixFluxCor(0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP):: xyr_LatentHeatFluxCor(0:imax-1, 1:jmax, 0:kmax)
                              ! ɽǮեå.
                              ! Latent heat flux
    real(DP):: xy_SurfQVapSat (0:imax-1, 1:jmax)
                              ! ɽ˰漾. 
                              ! Saturated specific humidity on surface
    real(DP):: xy_SurfDQVapSatDTemp (0:imax-1, 1:jmax)
                              ! ɽ˰漾Ѳ. 
                              ! Saturated specific humidity tendency on surface

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: n               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituents


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. lb_flux_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! ˰漾η׻
    ! Calculate saturated specific humidity
    !
    xy_SurfQVapSat       = &
      & xy_CalcQVapSat      ( xy_SurfTemp, xyr_Press(:,:,0) )
    xy_SurfDQVapSatDTemp = &
      & xy_CalcDQVapSatDTemp( xy_SurfTemp, xy_SurfQVapSat   )

    ! Output of fluxes at t
    !

    ! ®, , 漾եå
    ! Correct fluxes of wind, temperature, specific humidity
    !
    do j = 1, jmax
      do i = 0, imax-1
        xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
          & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * DelTime

        xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
          & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * DelTime

        xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
          & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
          &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
          &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
          &   * DelTime
      end do
    end do
    n = IndexH2OVap
    do j = 1, jmax
      do i = 0, imax-1
        xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
          & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
          &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
          &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * DelTime
      end do
    end do
    do n = 1, IndexH2OVap-1
      xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
    end do
    do n = IndexH2OVap+1, ncmax
      xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
    end do
    n = IndexH2OVap
    do j = 1, jmax
      do i = 0, imax-1
        xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
      end do
    end do


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'TauX'          , xyr_MomFluxXCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'TauY'          , xyr_MomFluxYCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'Sens'          , xyr_HeatFluxCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'SurfH2OVapFlux', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
    call HistoryAutoPut( TimeN, 'Evap'          , xyr_LatentHeatFluxCor(:,:,0) )


    ! Output of fluxes at t - \Delta t
    !

    ! ®, , 漾եå
    ! Correct fluxes of wind, temperature, specific humidity
    !
    do j = 1, jmax
      do i = 0, imax-1
        xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 )
        xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 )
        xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )
      end do
    end do
    n = IndexH2OVap
    do j = 1, jmax
      do i = 0, imax-1
        xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )
      end do
    end do
    do n = 1, IndexH2OVap-1
      xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
    end do
    do n = IndexH2OVap+1, ncmax
      xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
    end do
    n = IndexH2OVap
    do j = 1, jmax
      do i = 0, imax-1
        xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
      end do
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'TauXB'          , xyr_MomFluxXCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'TauYB'          , xyr_MomFluxYCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'SensB'          , xyr_HeatFluxCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'SurfH2OVapFluxB', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
    call HistoryAutoPut( TimeN, 'EvapB'          , xyr_LatentHeatFluxCor(:,:,0) )


    ! Output of fluxes at t + \Delta t
    !

    ! ®, , 漾եå
    ! Correct fluxes of wind, temperature, specific humidity
    !
    do j = 1, jmax
      do i = 0, imax-1
        xyr_MomFluxXCor( i,j,0 ) = xyr_MomFluxX( i,j,0 ) &
          & - xy_SurfVelTransCoef( i,j ) * xyz_DUDt( i,j,1 ) * 2.0_DP * DelTime

        xyr_MomFluxYCor( i,j,0 ) = xyr_MomFluxY( i,j,0 ) &
          & - xy_SurfVelTransCoef( i,j ) * xyz_DVDt( i,j,1 ) * 2.0_DP * DelTime

        xyr_HeatFluxCor( i,j,0 ) = xyr_HeatFlux( i,j,0 )               &
          & - CpDry * xyr_Exner( i,j,0 ) * xy_SurfTempTransCoef( i,j ) &
          &     * ( xyz_DTempDt( i,j,1 ) / xyz_Exner( i,j,1 )          &
          &       - xy_DSurfTempDt( i,j ) / xyr_Exner( i,j,0 ) )       &
          &   * 2.0_DP * DelTime
      end do
    end do
    n = IndexH2OVap
    do j = 1, jmax
      do i = 0, imax-1
        xyrf_QMixFluxCor( i,j,0,n ) = xyrf_QMixFlux( i,j,0,n )                    &
          & - xy_SurfHumidCoef( i,j ) * xy_SurfQVapTransCoef( i,j )               &
          &   * ( xyzf_DQMixDt( i,j,1,n )                                         &
          &     - xy_SurfDQVapSatDTemp( i,j ) * xy_DSurfTempDt( i,j ) ) * 2.0_DP * DelTime
      end do
    end do
    do n = 1, IndexH2OVap-1
      xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
    end do
    do n = IndexH2OVap+1, ncmax
      xyrf_QMixFluxCor(:,:,0,n) = xyrf_QMixFlux(:,:,0,n)
    end do
    n = IndexH2OVap
    do j = 1, jmax
      do i = 0, imax-1
        xyr_LatentHeatFluxCor( i,j,0 ) = LatentHeat * xyrf_QMixFluxCor( i,j,0,n )
      end do
    end do

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'TauXA'          , xyr_MomFluxXCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'TauYA'          , xyr_MomFluxYCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'SensA'          , xyr_HeatFluxCor (:,:,0) )
    call HistoryAutoPut( TimeN, 'SurfH2OVapFluxA', xyrf_QMixFluxCor(:,:,0,IndexH2OVap) )
    call HistoryAutoPut( TimeN, 'EvapA'          , xyr_LatentHeatFluxCor(:,:,0) )


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'SurfH2OVapFluxU', xy_SurfH2OVapFluxA     )
    call HistoryAutoPut( TimeN, 'EvapU'          , xy_SurfLatentHeatFluxA )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine SurfaceFluxOutput

  !--------------------------------------------------------------------------------------

  subroutine LBFluxSimpleInit
    !
    ! surface_flux_bulk ⥸塼νԤޤ. 
    ! NAMELIST#surface_flux_bulk_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "surface_flux_bulk" module is initialized. 
    ! "NAMELIST#surface_flux_bulk_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA


    ! դӻμ갷
    ! Date and time handler
    !
    use dc_calendar, only: DCCalConvertByUnit

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʪ
    ! Physical constant settings
    !
    use constants, only: &
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ʸ ; Declaration statements
    !
    real(DP)         :: FricTimeConstAtLBValue
    character(TOKEN) :: FricTimeConstAtLBUnit

    character(STRING) :: LBMomFluxMode
    character(STRING) :: LBHeatFluxMode
    character(STRING) :: LBH2OVapFluxMode

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /lb_flux_simple_nml/                        &
      & LBMomFluxMode,                                   &
      & FricTimeConstAtLBValue, FricTimeConstAtLBUnit,   &
      & FricLowestLatAtLB,                               &
      & LBHeatFluxMode,                                  &
      & HeatFluxAtLB, TempAtLB,                          &
      & LBH2OVapFluxMode,                                &
      & H2OVapFluxAtLB, QH2OVapAtLB, DiffCoefHeatMass
          !
          ! ǥեͤˤĤƤϽ³ "lb_flux_simple#LBFluxSimpleInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "lb_flux_simple#LBFluxSimpleInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( lb_flux_simple_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    LBMomFluxMode            = 'FixTimeConst'
    FricTimeConstAtLBValue   = 20.0_DP   ! Schneider and Liou (2009)
    FricTimeConstAtLBUnit    = 'day'
    FricLowestLatAtLB        = 16.3_DP   ! Schneider and Liou (2009)

    LBHeatFluxMode           = 'FixFlux'
    HeatFluxAtLB             =  5.7_DP   ! Schneider and Liou (2009)
    TempAtLB                 =  160.0_DP * ( 30.0_DP / 0.6_DP )**( GasRDry / CpDry )
                                 ! Sugiyama et al. (2009), Nagare Multimedia
                                 ! Potential Temperature of 160 K with 
                                 ! reference pressure of 0.6 bars

    LBH2OVapFluxMode         = 'FixFlux'
    H2OVapFluxAtLB           =  0.0_DP
    QH2OVapAtLB              =  7.816e-4_DP
                                 ! Sugiyama et al. (2009), Nagare Multimedia
    DiffCoefHeatMass         = 800.0_DP
                                 ! Sugiyama et al. (2009), Nagare Multimedia

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = lb_flux_simple_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    FricTimeConstAtLB = &
      & DCCalConvertByUnit( FricTimeConstAtLBValue, FricTimeConstAtLBUnit, 'sec' ) ! (in)


    ! Identification of calculation method for momentum flux
    !
    call MessageNotify( 'M', module_name, &
      & 'LBMomFluxMode=<%c>.', c1 = trim(LBMomFluxMode) )
    select case ( LBMomFluxMode )
    case ( 'NoFlux' )
      IDLBMomFluxMode = IDLBMomFluxModeNoFlux
    case ( 'FixTimeConst' )
      IDLBMomFluxMode = IDLBMomFluxModeFixTimeConst
    case default
      call MessageNotify( 'E', module_name, &
        & 'LBMomFluxMode=<%c> is not supported.', c1 = trim(LBMomFluxMode) )
    end select

    ! Identification of calculation method for heat flux
    !
    call MessageNotify( 'M', module_name, &
      & 'LBHeatFluxMode=<%c>.', c1 = trim(LBHeatFluxMode) )
    select case ( LBHeatFluxMode )
    case ( 'FixFlux' )
      IDLBHeatFluxMode = IDLBHeatFluxModeFixFlux
    case ( 'FixTemp' )
      IDLBHeatFluxMode = IDLBHeatFluxModeFixFlux
    case default
      call MessageNotify( 'E', module_name, &
        & 'LBHeatFluxMode=<%c> is not supported.', c1 = trim(LBHeatFluxMode) )
    end select

    ! Identification of calculation method for H2O vapor flux
    !
    call MessageNotify( 'M', module_name, &
      & 'LBH2OVapFluxMode=<%c>.', c1 = trim(LBH2OVapFluxMode) )
    select case ( LBH2OVapFluxMode )
    case ( 'FixFlux' )
      IDLBH2OVapFluxMode = IDLBH2OVapFluxModeFixFlux
    case ( 'FixMixRt' )
      IDLBH2OVapFluxMode = IDLBH2OVapFluxModeFixMixRt
    case default
      call MessageNotify( 'E', module_name, &
        & 'LBH2OVapFluxMode=<%c> is not supported.', c1 = trim(LBH2OVapFluxMode) )
    end select



    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'TauX', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface stress(x)  ', 'N m-2' )
    call HistoryAutoAddVariable( 'TauY', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface stress(y)  ', 'N m-2' )
    call HistoryAutoAddVariable( 'Sens', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'sensible heat flux', 'W m-2' )
    call HistoryAutoAddVariable( 'SurfH2OVapFlux', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
    call HistoryAutoAddVariable( 'Evap', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'latent heat flux  ', 'W m-2' )

    call HistoryAutoAddVariable( 'TauXB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface stress(x)  ', 'N m-2' )
    call HistoryAutoAddVariable( 'TauYB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface stress(y)  ', 'N m-2' )
    call HistoryAutoAddVariable( 'SensB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'sensible heat flux', 'W m-2' )
    call HistoryAutoAddVariable( 'SurfH2OVapFluxB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
    call HistoryAutoAddVariable( 'EvapB', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'latent heat flux  ', 'W m-2' )

    call HistoryAutoAddVariable( 'TauXA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface stress(x)  ', 'N m-2' )
    call HistoryAutoAddVariable( 'TauYA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface stress(y)  ', 'N m-2' )
    call HistoryAutoAddVariable( 'SensA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'sensible heat flux', 'W m-2' )
    call HistoryAutoAddVariable( 'SurfH2OVapFluxA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
    call HistoryAutoAddVariable( 'EvapA', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'latent heat flux  ', 'W m-2' )

    call HistoryAutoAddVariable( 'SurfH2OVapFluxU', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'surface H2O vapor flux  ', 'kg m-2 s-1' )
    call HistoryAutoAddVariable( 'EvapU', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'latent heat flux  ', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'LBMomFluxMode            = %c', c1 = trim( LBMomFluxMode ) )
    call MessageNotify( 'M', module_name, 'FricTimeConstAtLB        = %f', d = (/ FricTimeConstAtLB /) )
    call MessageNotify( 'M', module_name, 'FricLowestLatAtLB        = %f', d = (/ FricLowestLatAtLB /) )
    call MessageNotify( 'M', module_name, 'LBHeatFluxMode           = %c', c1 = trim( LBHeatFluxMode ) )
    call MessageNotify( 'M', module_name, 'HeatFluxAtLB             = %f', d = (/ HeatFluxAtLB /) )
    call MessageNotify( 'M', module_name, 'TempAtLB                 = %f', d = (/ TempAtLB /) )
    call MessageNotify( 'M', module_name, 'LBH2OVapFluxMode         = %c', c1 = trim( LBH2OVapFluxMode ) )
    call MessageNotify( 'M', module_name, 'H2OVapFluxAtLB           = %f', d = (/ H2OVapFluxAtLB /) )
    call MessageNotify( 'M', module_name, 'QH2OVapAtLB              = %f', d = (/ QH2OVapAtLB /) )
    call MessageNotify( 'M', module_name, 'DiffCoefHeatMass         = %f', d = (/ DiffCoefHeatMass /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    lb_flux_simple_inited = .true.

  end subroutine LBFluxSimpleInit

  !--------------------------------------------------------------------------------------

end module lb_flux_simple
