#!/usr/bin/env ruby
#
#= cvs tag name is converted to latex commands
#
#  Developers :: Yasuhiro MORIKAWA
#  Version    :: $Id: cvstag2latex.rb,v 1.1.1.1 2008/07/30 08:41:32 morikawa Exp $
#
#== Overview
#
#CVS tag name (XXXXXX-YYYYMMDD is expected) is converted to
#latex commands (ex. \Dmodeldateprint \Dmodelverprint)
#
#= Operation Environment
#
#This program is operated in ruby 1.8 .
#
#== Usage
#
#   $ cvstag2latex.rb  < file > latexfile
#
#== Desctiption
#
#None
#
#== Future Plans
#
#None
#
#== Notes
#
#None
#
#== Acknowledgements
#
#None
#
#== History
#
#These entries is generated by CVS automatically.
#So do not add new information manually.
#(But please adjust old log format to latest log format manually,
#if format gap between them causes).
#
#$Log: cvstag2latex.rb,v $
#Revision 1.1.1.1  2008/07/30 08:41:32  morikawa
#DCPAM (Dennou Club Planetary Atmospheric Model) Version 5
#
#Revision 1.3  2008-06-24 18:00:07  morikawa
#* A bug is fixed.
#
#* Хν.
#
#Revision 1.2  2008-06-24 16:29:52  morikawa
#* Structure of documents are being changed.
#  * Optimization for "latex2html"
#
#* ɥȤιѹ.
#  * latex2html غŬ.
#
#Revision 1.1  2008-06-24 15:37:19  morikawa
#* Structure of documents are being changed.
#  * Optimization for "latex2html"
#
#* ɥȤιѹ.
#  * latex2html غŬ.
#
#
#
##################################################

require "kconv"

##################################################

tag = ""
day = ""
STDIN.each{|line| 
  if /^\$Name: (\S+)/ =~ line then 
    tag = $1
  elsif /^\$Date: (\S+) (\S+)/ =~ line then 
    day = $1
  end
}
if tag.empty?
  tag = day.gsub(/[\/\-]/, "")
else
  if /dcpam\d-(\S+)/i =~ tag then
    tag = $1 
  end 
  if /(\d+)-\d+/i =~ tag then
    tagr = $1 
  else
    tagr = tag
  end 
  day = "#{tagr[0,4]}-#{tagr[4,2]}-#{tagr[6,2]}"
end
y, m, d = day.split("-")
#m = m.gsub(/^0+/, "")
#d = d.gsub(/^0+/, "")
date  = "#{y}/#{m}/#{d}"
dateJ = "#{y}ǯ#{m}#{d}"
Kconv::toeuc(dateJ)
#STDOUT.print "\\Dver{#{tag}} " 
#STDOUT.print "\\Dmodify{#{y}}{#{m}}{#{d}}\n"'
STDOUT.print "\\newcommand{\\Dmodelverprint}{#{tag}}\n"
STDOUT.print "\\newcommand{\\Dmodeldateprint}{#{date}}\n"
STDOUT.print "\\newcommand{\\DmodeldateprintJ}{#{dateJ}}\n"
