*-----------------------------------------------------------------------
*     GLPQNP / GLPQID / GLPQCP / GLPQVL / GLPSVL
*-----------------------------------------------------------------------
      SUBROUTINE GLPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=19)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LW(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EQUIVALENCE (IX(16),MSGUNT),(IX(19),LNSIZE)

      EXTERNAL  LCHREQ,LENC

      SAVE

      DATA CPARA( 1)/'LMISS   '/, LW( 1)/.TRUE. /, LX( 1)/.FALSE./
      DATA CPARA( 2)/'IMISS   '/, LW( 2)/.TRUE. /, IX( 2)/999/
      DATA CPARA( 3)/'RMISS   '/, LW( 3)/.TRUE. /, RX( 3)/999.0/
      DATA CPARA( 4)/'IUNDEF  '/, LW( 4)/.TRUE. /, IX( 4)/-999/
      DATA CPARA( 5)/'RUNDEF  '/, LW( 5)/.TRUE. /, RX( 5)/-999.0/
      DATA CPARA( 6)/'LEPSL   '/, LW( 6)/.TRUE. /, LX( 6)/.FALSE./
      DATA CPARA( 7)/'REPSL   '/, LW( 7)/.FALSE./, RX( 7)/@REPSL/
      DATA CPARA( 8)/'RFACT   '/, LW( 8)/.TRUE. /, RX( 8)/1.0/

      DATA CPARA( 9)/'INTMAX  '/, LW( 9)/.FALSE./, IX( 9)/@INTMAX/
      DATA CPARA(10)/'REALMAX '/, LW(10)/.FALSE./, IX(10)/@REALMAX/
      DATA CPARA(11)/'REALMIN '/, LW(11)/.FALSE./, IX(11)/@REALMIN/
      DATA CPARA(12)/'NBITSPW '/, LW(12)/.FALSE./, IX(12)/32/
      DATA CPARA(13)/'NCHRSPW '/, LW(13)/.FALSE./, IX(13)/4/

      DATA CPARA(14)/'IIUNIT  '/, LW(14)/.TRUE. /, IX(14)/5/
      DATA CPARA(15)/'IOUNIT  '/, LW(15)/.TRUE. /, IX(15)/6/
      DATA CPARA(16)/'MSGUNIT '/, LW(16)/.TRUE. /, IX(16)/6/
      DATA CPARA(17)/'MAXMSG  '/, LW(17)/.TRUE. /, IX(17)/20/
      DATA CPARA(18)/'MSGLEV  '/, LW(18)/.TRUE. /, IX(18)/0/
      DATA CPARA(19)/'NLNSIZE '/, LW(19)/.TRUE. /, IX(19)/78/

      DATA      LFIRST /.TRUE./


      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY GLPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','GLPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY GLPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CMSG='***** ERROR (GLPQCP) ***  IDX IS OUT OF RANGE.'
        CALL MSZDMP(CMSG,MSGUNT,LNSIZE)
        STOP
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY GLPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('GL:', CPARA, IX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
      ELSE
        CMSG='***** ERROR (GLPQVL) ***  IDX IS OUT OF RANGE.'
        CALL MSZDMP(CMSG,MSGUNT,LNSIZE)
        STOP
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY GLPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('GL:', CPARA, IX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IF (LW(IDX)) THEN
          IX(IDX)=IPARA
          RETURN
        ELSE
          NCP=LENC(CP)
          CMSG='***** ERROR (GLPSVL) ***  PARAMETER '''//CP(1:NCP)
     +         //''' CANNOT BE SET.'
          CALL MSZDMP(CMSG,MSGUNT,LNSIZE)
          STOP
        END IF
      ELSE
        CMSG='***** ERROR (GLPSVL) ***  IDX IS OUT OF RANGE'
        CALL MSZDMP(CMSG,MSGUNT,LNSIZE)
        STOP
      END IF

      RETURN
      END
