*=======================================================================
*     Conversion of bitmap data in half size
*     Aug. 29, 1991;  S. Sakai
*=======================================================================

      CHARACTER CPAT1*32, CPAT2*32, CBF1*32, CBF2*32, CFMT1*6, CFMT2*6
      LOGICAL   LEN1

      WRITE(6,*) 'INPUT BITMAP FILE > '
      READ (5,*) CBF1
      WRITE(6,*) 'OUTPUT BITMAP FILE > '
      READ (5,*) CBF2
      OPEN(1, FILE= CBF1)
      OPEN(2, FILE= CBF2)

      READ  (1,'(I4)') NREC
      WRITE (2,'(I4)') NREC
      DO 100 I=1, NREC
        READ (1,'(4I4)') IPAT1, IPAT2, IWDTH,   ILEN
        ILEN2  = ILEN/2
        IWDTH2 = IWDTH/2
        LEN1   = ILEN.EQ.1
        IF(LEN1) ILEN2 = 1
        WRITE(2,'(4I4)') IPAT1, IPAT2, IWDTH2, ILEN2
        WRITE(6,*) I, IPAT1, IPAT2, IWDTH, ILEN

        IP1 = MOD(IPAT1, 100)
        IP2 = MOD(IPAT2, 100)
        IF(IP1.NE.IP2) THEN
          WRITE(6,*) 'PATTERN NUMBER MAY BE WRONG ! '
          PAUSE
        ENDIF

        CFMT1='(Axx)'
        CFMT2='(Axx)'
        WRITE(CFMT1(3:4), '(I2)') IWDTH
        WRITE(CFMT2(3:4), '(I2)') IWDTH2

        DO 110 J=1, ILEN2
          READ(1, CFMT1) CPAT1
          IF(LEN1) THEN
            CPAT2 = CPAT1
          ELSE
            READ(1, CFMT1) CPAT2
          ENDIF
          CALL BITPCI(CPAT1, IBIT1)
          CALL BITPCI(CPAT2, IBIT2)

          IBIT1 = IOR (IBIT1, IBIT2)
          CALL BITPIC(IBIT1, CPAT1)
          DO 120 K=1, IWDTH2
            K2 = K*2
            K1 = K2-1
            IF(CPAT1(K1:K1).EQ.'1' .OR. CPAT1(K2:K2).EQ.'1') THEN
              CPAT2(K:K) = '1'
            ELSE
              CPAT2(K:K) = '0'
            ENDIF
  120     CONTINUE
          WRITE(2, CFMT2) CPAT2(1:IWDTH2)
  110   CONTINUE

  100 CONTINUE

      STOP
      END
