#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include "../../../config.h"

#undef DUMP_IMAGE

#ifdef HAVE_GTK_H
  #include <gtk/gtk.h>
  #include <gdk/gdkkeysyms.h>

  #include <gdk/gdkx.h>

#ifdef HAVE_GDK_IMLIB_H
  #include <gdk_imlib.h>
  #define DUMP_IMAGE 1
#endif

#ifdef HAVE_GDK_PIXBUF_H
  #include <gdk-pixbuf/gdk-pixbuf.h>
  #define DUMP_IMAGE 1
#endif
 
static DCL_REAL rwxold, rwyold;

#define FACTZ  0.03          /* scaling factor */

#ifndef TRUE
#define TRUE   1             /* numeric value for true  */
#endif
#ifndef FALSE
#define FALSE  0             /* numeric value for false */
#endif

#define PAD    2.0           /* padding for workstation window */
#define LWDATR TRUE          /* line width  capability */
#define LCLATR TRUE          /* line color  capability */
#define LTNATR TRUE          /* hard fill   capability */
#define LIMATR TRUE          /* bit image   capability */
#define LPTATR FALSE         /* mouse point capability */

#define MAXWDI 9             /* maximum number of line index */
#define MAXCLI 255           /* maximum number of line color */
#define MAXBMP 300           /* maximum number of bitmaps */

#define DOPN   1
#define DCLS   2
#define PCLS   3

static int linewidth[MAXWDI] = { 1, 2, 2, 3, 3, 4, 4, 5, 5 };

static int iwdidz;           /* pen width */
static int iclidz;           /* pen color index */
static int iwtroz;           /* direction of frame */
static int lclatrz;          /* type of screen */
static int wsxwd, wsywd, wsxmnz, wsxmxz, wsymnz, wsymxz;
static int ixz, iyz, iwz, ihz, ixxz, iyyz, page; /* for image */
static int posx, posy, wait_np, wait_op, wait_cl, key, dump, fgbg;
static int nbmap, nn1[MAXBMP], nn2[MAXBMP], nx[MAXBMP], ny[MAXBMP];
static char dmpfile[80], xtitle[80];
static char bmline[MAXBMP][260];

static int lfirst = TRUE;

static GdkGC *gc;
static GdkGC *gct;
static GtkWidget *window = NULL;
static GtkWidget *drawing_area = NULL;
static GdkPixmap *pixmap = NULL;

static int ldclonly = FALSE;

static int wnd;

#ifdef DUMP_IMAGE
static char imgfmt[8];
#endif

static GdkColor cx[MAXCLI];

static int ifunc, next;
static int dumpz = FALSE;

/*------------------------- GDK  ------------------------*/

void zgupdate(void)
{
    GdkRectangle update_rect;

    update_rect.x = 0;
    update_rect.y = 0;
    update_rect.width = drawing_area->allocation.width;
    update_rect.height = drawing_area->allocation.height;

    gtk_widget_draw(drawing_area, &update_rect);
}

void zgsdrw_(GtkWidget *d)
{

  /* set/reset drawing_area */

  drawing_area = d;
}

/*-----------------------------------------------*/
gint zg_expose_event(GtkWidget *widget, GdkEventExpose *event)
{

  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  pixmap,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);

  return FALSE;
}

gint zg_key_press_event(GtkWidget *widget, GdkEventKey *event)
{
  switch (ifunc){
  case DOPN:
    next = TRUE;
    break;

  case DCLS:
    switch (event->keyval) {
    case GDK_space:
    case GDK_Return:
      next = TRUE;
      break;
    default:
      next = FALSE;
    }
    break;

  case PCLS:
    switch (event->keyval) {
    case GDK_Return:
    case GDK_space:
      next = TRUE;
      break;
    case GDK_d:
      next = TRUE;
      dumpz = TRUE;
      break;
    case GDK_s:
      next = TRUE;
      wait_np = FALSE;
      break;
    case GDK_q:
      gtk_exit(0);
      exit(0);
    default:
      next = FALSE;
    }
    break;

  default:
    next = FALSE;
  }

  return TRUE;
}

gint zg_button_press_event(GtkWidget *widget, GdkEventButton *event)
{
  switch (ifunc){
  case DOPN:
  case DCLS:
  case PCLS:
    next = TRUE;
    break;

  default:
    next = FALSE;
  }

  return TRUE;
}

/*-----------------------------------------------*/
static GtkWidget *zggdrw_(DCL_INT *width, DCL_INT *height)
{
  GtkWidget * drw;
  GtkWidget *vbox;

  wsxwd  = *width  + 2 * PAD;  /* window width */
  wsywd  = *height + 2 * PAD;  /* window height */
  wsxmnz = PAD;                /* lower-left  corner */
  wsymnz = PAD;                /* lower-left  corner */
  wsxmxz = PAD + *width  - 1;  /* upper-right corner */
  wsymxz = PAD + *height - 1;  /* upper-right corner */
  page   = 0;

  gtk_init(0,NULL);

  drw = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA (drw), wsxwd, wsywd);
  gtk_widget_show(drw);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), xtitle);
  gtk_container_add(GTK_CONTAINER (window), drw);

  if (!wnd)
    gtk_widget_realize(drw);
  else {
    if (key){
      gtk_widget_set_events(window, GDK_BUTTON_PRESS_MASK|GDK_KEY_PRESS_MASK);
      gtk_signal_connect(GTK_OBJECT (window), "key_press_event",
			 (GtkSignalFunc) zg_key_press_event, NULL);
    } else
      gtk_widget_set_events(window, GDK_BUTTON_PRESS_MASK);

    gtk_signal_connect(GTK_OBJECT (window), "button_press_event",
		       (GtkSignalFunc) zg_button_press_event, NULL);

    gtk_widget_set_events(drw, GDK_EXPOSURE_MASK);
    gtk_signal_connect(GTK_OBJECT (drw), "expose_event",
		       (GtkSignalFunc) zg_expose_event, NULL);

    gtk_widget_show(window);
  }

  return drw;
}

GtkWidget *zgqdrw_(void)
{
  return drawing_area;
}

void zgspmp_(GdkPixmap *pmap)
{

  /* set/reset pixmap */

  pixmap = pmap;
}

static GdkPixmap *zggpmp(void)
{
  GdkPixmap *pmap;

  pmap = gdk_pixmap_new(drawing_area->window,
			drawing_area->allocation.width,
			drawing_area->allocation.height,
			-1);

  gdk_draw_rectangle(pmap,
		     gc,
		     TRUE,
		     0, 0,
		     drawing_area->allocation.width,
		     drawing_area->allocation.height);

  return pmap;
}

GdkPixmap *zgqpmp_(void)
{
  return pixmap;
}

/*-----------------------------------------------*/
static void zgbmcv(int *nx, int *ny, char bmline[], char bitmap[])
{
  static int n8 = 8;
  int n, nb;
  unsigned bx;

  nb = *nx * *ny / n8;
  for (n = 0; n < nb; n++){
    sscanf(&bmline[2*n], "%2x", &bx);
    bitmap[n] = bx;
  }
  bitmap[nb] = '\0';
}
#endif


/*------------------------- device ------------------------*/
void zgdopn_(DCL_INT *width, DCL_INT *height, DCL_INT *iposx, DCL_INT *iposy, 
             DCL_INT *lwait, DCL_INT *lwait0, DCL_INT *lwait1, DCL_INT *lkey, 
             DCL_INT *ldump, DCL_INT *lwnd, DCL_INT *lfgbg,
	     char cimgfmt[], char clrmap[], char cbmmap[], char file[], char title[])
{
  void cfnchr();

#ifdef HAVE_GTK_H
  int ncolor, n, m;

  guint16 rx[MAXCLI], gx[MAXCLI], bx[MAXCLI], rx1, gx1, bx1;
  char c[80], cmapz[80], bmapz[80];

  FILE *stream;

  GdkVisual *vis;
  GdkColormap *cmap;

  GdkRectangle update_rect;
  GdkEvent *ev;

  posx      = *iposx;
  posy      = *iposy;
  wait_np   = *lwait;
  wait_op   = *lwait0;
  wait_cl   = *lwait1;
  key       = *lkey;
  dump      = *ldump;
  fgbg      = *lfgbg;

#ifdef DUMP_IMAGE
  wnd       = *lwnd;
  cfnchr(imgfmt, cimgfmt, 7);
  if (!wnd) {
    wait_np = FALSE;
    wait_op = FALSE;
    wait_cl = FALSE;
    dump    = TRUE;
  }
#else
  wnd       = TRUE;
#endif

  cfnchr(dmpfile, file, 79);
  cfnchr(xtitle, title, 79);

  /* check drawing_area, if not set, stop */

  if (drawing_area == NULL) {

    ldclonly = TRUE;

    drawing_area = zggdrw_(width,height);
  }

  /* read colormap file */

  cfnchr(cmapz, clrmap, 79);

  if ((stream = fopen(cmapz, "r")) == NULL) {
    fprintf(stderr, "*** Error in zgdopn : ");
    fprintf(stderr,
	    "Allocation failed for colormap (%s).\n", cmapz);
    exit (1);
  }

  fscanf(stream, "%d : %s", &ncolor, c);
  for (n = 0; n < ncolor; n++)
    fscanf(stream, "%6hd%6hd%6hd : %s", &rx[n], &gx[n], &bx[n], c);
  fclose(stream);

  if (fgbg) {
    rx1 = rx[0];
    gx1 = gx[0];
    bx1 = bx[0];
    rx[0] = rx[1];
    gx[0] = gx[1];
    bx[0] = bx[1];
    rx[1] = rx1;
    gx[1] = gx1;
    bx[1] = bx1;
  }

  /* read bitmap file */

  cfnchr (bmapz, cbmmap, 79);

  if ((stream = fopen(bmapz, "r")) == NULL) {
    fprintf(stderr, "*** Error in zgdopn : ");
    fprintf(stderr,
	     "Allocation failed for bitmap (%s).\n", bmapz);
    exit (1);
  }

  fscanf(stream, "%d", &nbmap);
  for (n = 0; n < nbmap; n++)
    fscanf(stream, "%4d%4d%3d%3d%s",
	   &nn1[n], &nn2[n], &nx[n], &ny[n], bmline[n]);
  fclose(stream);

  /* set colormap */

  vis = gtk_widget_get_visual(drawing_area);

  lclatrz = (vis->type != GDK_VISUAL_STATIC_GRAY);

  if (lclatrz) {

    cmap = gtk_widget_get_colormap(drawing_area);

    for (n = 0; n < MAXCLI; n++) {

      m = n % ncolor;

      cx[n].red   = rx[m];
      cx[n].green = gx[m];
      cx[n].blue  = bx[m];

      if (!gdk_colormap_alloc_color(cmap, &cx[n], FALSE, FALSE))
	break;

    }

    if (n < MAXCLI) {

      fprintf (stderr, "*** Warning in zgdopn : ");
      fprintf (stderr, "Only %d colors are allocated.\n", n);

      for ( ; n < MAXCLI; n++)
	cx[n].pixel = drawing_area->style->black.pixel;

    }

  } else {
    cx[0].pixel = drawing_area->style->white.pixel;
    for (n = 1; n < MAXCLI; n++)
      cx[n].pixel = drawing_area->style->black.pixel;
  }

  gc = gdk_gc_new(drawing_area->window);
  gdk_gc_set_foreground(gc, &cx[0]);

  if (ldclonly) {

    if (pixmap)
      gdk_pixmap_unref(pixmap);

    pixmap = zggpmp();

    zgupdate();

    if (wait_op) {
      next = FALSE;
      ifunc = DOPN;
      while (1) {
	gtk_main_iteration();
	if (next)
	  break;
      }
    }

  } else
    if (!pixmap)
      pixmap = zggpmp();
#endif
}

void zgdcls_(void)
{
#ifdef HAVE_GTK_H
  /* device closing proc. */

  GdkEvent *ev;

  if (ldclonly) {

    zgupdate();

    if (!wait_np && wait_cl) {
      next = FALSE;
      ifunc = DCLS;
      while (1) {
	gtk_main_iteration();
	if (next)
	  break;
      }
    }

    gtk_widget_destroy(drawing_area);
    drawing_area = NULL;
    gtk_widget_destroy(window);
    window = NULL;

  }
#endif
}

/*------------------------- page --------------------------*/

void zgpopn_(void)
{
#ifdef HAVE_GTK_H

  /* background drawing proc. */
  ++page;

  iwdidz = 1;
  iclidz = 1;
  gdk_gc_set_foreground(gc, &cx[0]);
  gdk_draw_rectangle(pixmap,
		     gc,
		     TRUE,
		     0, 0,
		     drawing_area->allocation.width,
		     drawing_area->allocation.height);
#endif
}

void zgpcls_(void)
{
#ifdef HAVE_GTK_H

  /* event loop */

  char cout[64];


  if (ldclonly) {

    zgupdate();

    if (wait_np) {
      dumpz = FALSE;
      next = FALSE;
      ifunc = PCLS;
      while (1) {
	gtk_main_iteration();
	if (next)
	  break;
      }
    }
    if (dump || dumpz) {

#ifdef HAVE_GDK_PIXBUF_H
      sprintf (cout, "%s_%03d.%s", dmpfile, page, imgfmt);
      if (!gdk_pixbuf_save(gdk_pixbuf_get_from_drawable(
							NULL,
							pixmap,
							NULL,
							0, 0,
							0, 0,
							wsxwd, wsywd),
			   cout, imgfmt, NULL, NULL) ) {
	fprintf(stderr, " *** Error in zgdopn : ");
	fprintf(stderr,
		"Image format (\"%s\") is not supported.\n", imgfmt);
      }

#elif defined(HAVE_GDK_IMLIB_H)
      sprintf (cout, "%s_%03d.%s", dmpfile, page, imgfmt);
      gdk_imlib_save_image(gdk_imlib_create_image_from_drawable(
								pixmap,
								NULL,
								0, 0,
								wsxwd,wsywd),
			   cout, NULL);
#else
      sprintf (cout, "xwd -name %s -out %s_%03d.xwd", xtitle, dmpfile, page);
      system (cout);
#endif

    }
  }
#endif
}


/*------------------------- object ------------------------*/

void zgoopn_(char *objname, char *comment)
{
#ifdef HAVE_GTK_H

  /* for long-type message? */
#endif
}

void zgocls_(char *objname)
{
#ifdef HAVE_GTK_H

  /* for long-type message? */
#endif
}

/*------------------------- line --------------------------*/

void zgswdi_(DCL_INT *iwdidx)
{
#ifdef HAVE_GTK_H

  /* set line width index */

  iwdidz = *iwdidx % 10;

  if (iwdidz == 0)
    iwdidz = 1;
#endif
}

void zgscli_(DCL_INT *iclidx)
{
#ifdef HAVE_GTK_H

  /* set line color index */

  iclidz = *iclidx % MAXCLI;

/*if (iclidz == 0)
    iclidz = 1; */
#endif
}

void zggopn_(void)
{
#ifdef HAVE_GTK_H

  /* open graphic segment */

  gdk_gc_set_foreground(gc,
			&cx[iclidz]);

  gdk_gc_set_line_attributes(gc,
			     linewidth[iwdidz-1],
			     GDK_LINE_SOLID,
			     GDK_CAP_ROUND,
			     GDK_JOIN_BEVEL);
#endif
}

void zggmov_(DCL_REAL *wx, DCL_REAL *wy)
{
#ifdef HAVE_GTK_H

  /* pen-up move */

  rwxold = *wx;
  rwyold = *wy;
#endif
}

void zggplt_(DCL_REAL *wx, DCL_REAL *wy)
{
#ifdef HAVE_GTK_H
  DCL_INT iwxold, iwyold, iwx, iwy;
  void zgfint_();

  /* pen-down move */

  zgfint_(&rwxold, &rwyold, &iwxold, &iwyold);
  zgfint_( wx,      wy,     &iwx,    &iwy   );

  if (iwxold == iwx && iwyold == iwy)
    gdk_draw_point(pixmap, gc, (int) iwx, (int) iwy);
  else
    gdk_draw_line(pixmap, gc, (int) iwxold, (int) iwyold, (int) iwx, (int) iwy);

  rwxold = *wx;
  rwyold = *wy;
#endif
}

void zggcls_(void)
{
#ifdef HAVE_GTK_H

  /* close graphic segment */
#endif
}

/*------------------------- tone --------------------------*/

void zggton_(DCL_INT *np, DCL_REAL wpx[], DCL_REAL wpy[], DCL_INT *itpat)
{
#ifdef HAVE_GTK_H
  static int ltfrst = TRUE, ibitold = -1;
  static GdkPoint p[16384];
  DCL_INT ipx, ipy, iclr, ibit;
  int i, nb;
  char bitmap[16384];

  GdkPixmap *pattern;

  void zgfint_();

  /* hard fill */

  if (ltfrst) {
    gct = gdk_gc_new (drawing_area->window);

    ltfrst = FALSE;
  }

  ibit = *itpat % 1000;
  iclr = (*itpat / 1000) % MAXCLI;
/*if (iclr == 0)
    iclr = 1; */

  gdk_gc_set_foreground (gct, &cx[iclr]);

  if (ibit != ibitold) {
    ibitold = ibit;
    nb = -1;
    if (iwtroz == 1) {
      for (i = 0; i < nbmap; i++)
	if (ibit == nn1[i]) {
	  nb = i;
	  break;
	}
    }
    else {
      for (i = 0; i < nbmap; i++)
	if (ibit == nn2[i]) {
	  nb = i;
	  break;
	}
    }
    if (nb >= 0) {
      zgbmcv(&nx[nb], &ny[nb], bmline[nb], bitmap);
      pattern = gdk_bitmap_create_from_data(NULL, bitmap, nx[nb], ny[nb]);
      gdk_gc_set_fill(gct, GDK_STIPPLED);
      gdk_gc_set_stipple(gct, pattern);
    }
    else
      return;
  }

  for (i = 0; i < *np; i++) {
    zgfint_(&wpx[i],&wpy[i], &ipx, &ipy);
    p[i].x = ipx;
    p[i].y = ipy;
  }

  gdk_draw_polygon(pixmap, gct, TRUE, p, *np);
#endif
}

/*------------------------- image -------------------------*/

void zgiopn_(DCL_INT *iwx, DCL_INT *iwy, DCL_INT *iwidth, DCL_INT *iheight)
{
#ifdef HAVE_GTK_H
  ixz = *iwx;
  iyz = *iwy;
  iwz = *iwidth;
  ihz = *iheight;
  ixxz = ixz;
  iyyz = iyz;
  printf (" *** image ");
#endif
}

void zgidat_(DCL_INT image[], DCL_INT *nlen)
{
#ifdef HAVE_GTK_H
  int i;

  for (i = 0; i < *nlen; i++) {
    if (image[i] != 0) {
      gdk_gc_set_foreground(gc, &cx[image[i]]);
      gdk_draw_point(pixmap, gc, ixxz, iyyz);
    }
    ixxz = ixxz + 1;
    if (ixxz >= ixz+iwz) {
      ixxz = ixz;
      iyyz = iyyz + 1;
      if (iyyz % 16 == 0) {
	printf (".");
	fflush (stdout);
      }
    }
  }
#endif
}

void zgicls_(void)
{
#ifdef HAVE_GTK_H

  printf (" end\n");
#endif
}

/*------------------------- mouse -------------------------*/

void zgqpnt_(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *mb)
{
#ifdef HAVE_GTK_H

  /* mouse pointer position info. */
#endif
}

/*---------------------- transformation -------------------*/

void zgfint_(DCL_REAL *wx, DCL_REAL *wy, DCL_INT *iwx, DCL_INT *iwy)
{
#ifdef HAVE_GTK_H
  int dheight;
  int dwidth;

  *iwx = *wx + 0.5;
  *iwy = drawing_area->allocation.height - *wy + 0.5;
#endif
}

void zgiint_(DCL_INT *iwx, DCL_INT *iwy, DCL_REAL *wx, DCL_REAL *wy)
{
#ifdef HAVE_GTK_H
  *wx = *iwx;
  *wy = drawing_area->allocation.height - *iwy;
#endif
}

/*------------------------- inquiry -----------------------*/

void zgqwdc_(DCL_INT *lwdatr)
{
#ifdef HAVE_GTK_H

  /* inquire line width capability */

  *lwdatr = LWDATR;
#endif
}

void zgqclc_(DCL_INT *lclatr)
{
#ifdef HAVE_GTK_H

  /* inquire line color capability */

  *lclatr = lclatrz;
#endif
}

void zgqtnc_(DCL_INT *ltnatr)
{
#ifdef HAVE_GTK_H

  /* inquire hard fill capability */

  *ltnatr = LTNATR;
#endif
}

void zgqimc_(DCL_INT *limatr)
{
#ifdef HAVE_GTK_H

  /* inquire bit image capability */

  *limatr = LIMATR;
#endif
}

void zgqptc_(DCL_INT *lptatr)
{
#ifdef HAVE_GTK_H

  /* inquire mouse point capability */

  *lptatr = LPTATR;
#endif
}

void zgqrct_(DCL_REAL *wsxmn, DCL_REAL *wsxmx, DCL_REAL *wsymn, DCL_REAL *wsymx, DCL_REAL *fact)
{
#ifdef HAVE_GTK_H

  /* inquire workstation rectangle */

  *wsxmn = 0.;
  *wsxmx = drawing_area->allocation.width;
  *wsymn = 0.;
  *wsymx = drawing_area->allocation.height;
  *fact  = FACTZ;
#endif
}

void zgsrot_(DCL_INT *iwtrot)
{
#ifdef HAVE_GTK_H

  /* set frame rotation flag */

  iwtroz = *iwtrot;
#endif
}
