#!/usr/bin/env ruby

require "numru/netcdf"
require "numru/dcl"
require "numru/ggraph"
require "getoptlong"
include NumRu

parser = GetoptLong.new
parser.set_options(
                   ###    global option   ###
                   ['--DelTime',      GetoptLong::REQUIRED_ARGUMENT],
                   ['--Time',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--info',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--Num',          GetoptLong::REQUIRED_ARGUMENT],
                   ['--MaxT',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--MinT',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--MaxW',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--MinW',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--ZMin',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--ZMax',         GetoptLong::REQUIRED_ARGUMENT],
                   ['--mpi',          GetoptLong::REQUIRED_ARGUMENT],
                   ['--dump',         GetoptLong::NO_ARGUMENT]
                   )
begin
  parser.each_option do |name, arg|
    eval "$OPT_#{name.sub(/^--/, '').gsub(/-/, '_')} = '#{arg}'" 
  end
    rescue
  exit(1)
end

file = ARGV[0]
info = $OPT_info
time0= $OPT_Time.to_f
num  = $OPT_Num.to_f
delt = $OPT_DelTime.to_f
time1=time0+delt*num

if ($OPT_ZMin)
  zmin = $OPT_ZMin.to_f
else
  zmin = 1.0e5
end
if ($OPT_ZMax) 
  zmax = $OPT_ZMax.to_f
else
  zmax = 2.0e5
end

if ($OPT_mpi) 
  files0 = Array.new
  files1 = Array.new
  files2 = Array.new
  files3 = Array.new
  files4 = Array.new
  files5 = Array.new
  files6 = Array.new
  files7 = Array.new
  files8 = Array.new
  files9 = Array.new
  ($OPT_mpi.to_i).times {|i|
    fnum = sprintf("%03d", i)
    inputfile = "#{file}-node#{fnum}_BasicZ.nc"
    files0.push( inputfile )
    inputfile = "#{file}-node#{fnum}_H2O-g.nc"
    files1.push( inputfile )
    inputfile = "#{file}-node#{fnum}_H2S-g.nc"
    files2.push( inputfile )
    inputfile = "#{file}-node#{fnum}_NH3-g.nc"
    files3.push( inputfile )
    inputfile = "#{file}-node#{fnum}_H2O-s-Cloud.nc"
    files4.push( inputfile )
    inputfile = "#{file}-node#{fnum}_H2O-s-Rain.nc"
    files5.push( inputfile )
    inputfile = "#{file}-node#{fnum}_NH4SH-s-Cloud.nc"
    files6.push( inputfile )
    inputfile = "#{file}-node#{fnum}_NH4SH-s-Rain.nc"
    files7.push( inputfile )
    inputfile = "#{file}-node#{fnum}_NH3-s-Cloud.nc"
    files8.push( inputfile )
    inputfile = "#{file}-node#{fnum}_NH3-s-Rain.nc"
    files9.push( inputfile )
  } 
  var1  = "H2O-g"
  var2  = "H2O-gBasicZ"
  H2OgD = GPhys::IO.open(files1, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2OgB = GPhys::IO.open(files0, var2).cut('z'=>zmin..zmax)
  H2Og  = H2OgD + H2OgB
  H2Og.coord(0).val = H2Og.coord(0).val / 1000
  H2Og.coord(1).val = H2Og.coord(1).val / 1000
  
  var1  = "H2O-s-Cloud"
  var2  = "H2O-s-Rain"
  H2OsC = GPhys::IO.open(files4, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2OsR = GPhys::IO.open(files5, var2).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2Os  = (H2OsC + H2OsR) * 1.0e0
  H2Os.coord(0).val = H2Os.coord(0).val / 1000
  H2Os.coord(1).val = H2Os.coord(1).val / 1000
  
  var1  = "NH3-g"
  var2  = "NH3-gBasicZ"
  file1 = file+"*_"+var1+".nc"
  file2 = file+"*_BasicZ.nc"
  NH3gD = GPhys::IO.open(files3, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH3gB = GPhys::IO.open(files0, var2).cut('z'=>zmin..zmax)
  NH3g  = NH3gD + NH3gB
  NH3g.coord(0).val = NH3g.coord(0).val / 1000
  NH3g.coord(1).val = NH3g.coord(1).val / 1000
  
  var1  = "NH3-s-Cloud"
  var2  = "NH3-s-Rain"
  file1 = file+"*_"+var1+".nc"
  file2 = file+"*_"+var2+".nc"
  NH3sC = GPhys::IO.open(files8, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH3sR = GPhys::IO.open(files9, var2).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH3s  = (NH3sC + NH3sR) * 1.0e0
  NH3s.coord(0).val = NH3s.coord(0).val / 1000
  NH3s.coord(1).val = NH3s.coord(1).val / 1000
  
  var1  = "H2S-g"
  var2  = "H2S-gBasicZ"
  file1 = file+"*_"+var1+".nc"
  file2 = file+"*_BasicZ.nc"
  H2SgD = GPhys::IO.open(files2, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2SgB = GPhys::IO.open(files0, var2).cut('z'=>zmin..zmax)
  H2Sg  = H2SgD + H2SgB
  H2Sg.coord(0).val = H2Sg.coord(0).val / 1000
  H2Sg.coord(1).val = H2Sg.coord(1).val / 1000

  var1   = "NH4SH-s-Cloud"
  var2   = "NH4SH-s-Rain"
  file1  = file+"*_"+var1+".nc"
  file2  = file+"*_"+var2+".nc"
  NH4SHsC = GPhys::IO.open(files6, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH4SHsR = GPhys::IO.open(files7, var2).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH4SHs  = (NH4SHsC + NH4SHsR) * 1.0e0
  NH4SHs.coord(0).val = NH4SHs.coord(0).val / 1000
  NH4SHs.coord(1).val = NH4SHs.coord(1).val / 1000  

else
  var1  = "H2O-g"
  var2  = "H2O-gBasicZ"
  file1 = file+"_"+var1+".nc"
  file2 = file+"_BasicZ.nc"
  H2OgD = GPhys::IO.open(file1, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2OgB = GPhys::IO.open(file2, var2).cut('z'=>zmin..zmax)
  H2Og  = H2OgD + H2OgB
  H2Og.coord(0).val = H2Og.coord(0).val / 1000
  H2Og.coord(1).val = H2Og.coord(1).val / 1000
  
  var1  = "H2O-s-Cloud"
  var2  = "H2O-s-Rain"
  file1 = file+"_"+var1+".nc"
  file2 = file+"_"+var2+".nc"
  H2OsC = GPhys::IO.open(file1, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2OsR = GPhys::IO.open(file2, var2).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2Os  = (H2OsC + H2OsR) * 1.0e0
  H2Os.coord(0).val = H2Os.coord(0).val / 1000
  H2Os.coord(1).val = H2Os.coord(1).val / 1000
  
  var1  = "NH3-g"
  var2  = "NH3-gBasicZ"
  file1 = file+"_"+var1+".nc"
  file2 = file+"_BasicZ.nc"
  NH3gD = GPhys::IO.open(file1, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH3gB = GPhys::IO.open(file2, var2).cut('z'=>zmin..zmax)
  NH3g  = NH3gD + NH3gB
  NH3g.coord(0).val = NH3g.coord(0).val / 1000
  NH3g.coord(1).val = NH3g.coord(1).val / 1000
  
  var1  = "NH3-s-Cloud"
  var2  = "NH3-s-Rain"
  file1 = file+"_"+var1+".nc"
  file2 = file+"_"+var2+".nc"
  NH3sC = GPhys::IO.open(file1, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH3sR = GPhys::IO.open(file2, var2).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH3s  = (NH3sC + NH3sR) * 1.0e0
  NH3s.coord(0).val = NH3s.coord(0).val / 1000
  NH3s.coord(1).val = NH3s.coord(1).val / 1000
  
  var1  = "H2S-g"
  var2  = "H2S-gBasicZ"
  file1 = file+"_"+var1+".nc"
  file2 = file+"_BasicZ.nc"
  H2SgD = GPhys::IO.open(file1, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  H2SgB = GPhys::IO.open(file2, var2).cut('z'=>zmin..zmax)
  H2Sg  = H2SgD + H2SgB
  H2Sg.coord(0).val = H2Sg.coord(0).val / 1000
  H2Sg.coord(1).val = H2Sg.coord(1).val / 1000

  var1   = "NH4SH-s-Cloud"
  var2   = "NH4SH-s-Rain"
  file1  = file+"_"+var1+".nc"
  file2  = file+"_"+var2+".nc"
  NH4SHsC = GPhys::IO.open(file1, var1).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH4SHsR = GPhys::IO.open(file2, var2).cut('t'=>time0..time1).cut('z'=>zmin..zmax)
  NH4SHs  = (NH4SHsC + NH4SHsR) * 1.0e0
  NH4SHs.coord(0).val = NH4SHs.coord(0).val / 1000
  NH4SHs.coord(1).val = NH4SHs.coord(1).val / 1000
end

DCL::swpset('IWIDTH',  450 )
DCL::swpset('IHEIGHT', 600 )
DCL.sgscmn(5)

if ( $OPT_dump )
  DCL::swlset("lwnd",false)
end

DCL.gropn(4)
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.sgpset('lcorner',false)  # ʡޡ񤫤ʤ
DCL.uzfact(0.7)              # ɸʸ󥵥
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ
DCL.udpset('lmsg',false)     # 󥿡ֳɽ

#vx   = 0.85
vx   = 0.6
#vz   = 0.25
vz   = 0.36
xmgn = 0.02
zmgn = 0.08
vx0  = 0.1
vz0  = 0.1

vpt00 = NArray[vx0, vx0+vx, vz0, vz0+vz*1]
#vpt10 = NArray[vx0+xmgn+vx, vx0+xmgn+vx*2, vz0+vz*0, vz0+vz*1]
vpt10 = NArray[vx0, vx0+vx, vz0+zmgn+vz, vz0+zmgn+vz*2]
#vpt00 = NArray[vx0, vx0+vx, vz0+vz*0+zmgn*0, vz0+vz*1+zmgn*0]
#vpt10 = NArray[vx0+xmgn+vx, vx0+xmgn+vx*2, vz0+vz*0+zmgn*0, vz0+vz*1+zmgn*0]

#==============================================================================
CND = [ H2Os,  NH4SHs, NH3s]
GAS = [ H2Og,  H2Sg,   NH3g]
GASb= [ H2OgB, H2SgB,  NH3gB]

for j in 0..num
  p j
  for i in 0..2
    
    lev=[0,1e-8,2e-8,5e-8,1e-7,2e-7,5e-7,1e-6,2e-6,5e-6,1e-5,2e-5,5e-5,1e-4,2e-4,5e-4]
    maximum = GASb[i].max * 1.2
    minimum = 0

    GGraph.set_fig('viewport'=>vpt10, 'new_frame'=>true)
    GGraph.set_axes('xunits'=>'','yunits'=>'','xtitle'=>'Length [km]','ytitle'=>'Height [km]') 
    DCL.uzpset('labelyl',true)
    DCL.uzpset('labelxb',false)
    GGraph.tone( CND[i].cut('t'=>time0+delt*j), 
                 true, 
                 'annot'=>false, 
                 'titl'=>'', 
                 'levels'=>lev )
    DCL.uzpset('pad1',0.4) 
    DCL.uxsttl('t','(a) Cloud Mixing Ratio [kg/kg]',0) 
    DCL.uzpset('pad1',0.7)
    
    GGraph.set_fig('viewport'=>vpt00, 'new_frame'=>false)
    GGraph.set_axes('xunits'=>'','yunits'=>'','xtitle'=>'Length [km]','ytitle'=>'Height [km]') 
    DCL.uzpset('labelyl',true)
    DCL.uzpset('labelxb',true)
    GGraph.tone( GAS[i].cut('t'=>time0+delt*j), 
                 true, 
                 'annot'=>false, 
                 'titl'=>'', 
                 'max' => maximum, 
                 'min' => minimum, 
                 'nlev'=> 50 )
    DCL.uzpset('pad1',0.4) 
    DCL.uxsttl('t','(c) Vapor Mixing Ratio [kg/kg]',0) 
    DCL.uzpset('pad1',0.7)
  end
end
#==============================================================================

DCL.grcls


if ($OPT_dump)

  order = Math::log10(time0+delt*num).to_i + 1 
  fmt = "%0"+(order.to_i).to_s+"d"  

  for i in 0..num
    time = sprintf(fmt, time0.to_f+(i*delt).to_f)

    j = sprintf("%03d", i * 3 + 1 )
    k = sprintf("%03d", i * 3 + 2 )
    l = sprintf("%03d", i * 3 + 3 )

    outputfile = info+"-2_t"+time.to_s+".png"  

#    convert1 = "convert -negate dcl_"+j+".png dcl1.pgm"
#    convert2 = "convert -negate dcl_"+k+".png dcl2.pgm"
#    convert3 = "convert -negate dcl_"+l+".png dcl3.pgm"
    convert1 = "convert  dcl_"+j+".png dcl1.pgm"
    convert2 = "convert  dcl_"+k+".png dcl2.pgm"
    convert3 = "convert  dcl_"+l+".png dcl3.pgm"
#    convert4 = "convert -channel Red dcl1.pgm -channel Green dcl2.pgm -channel Blue dcl3.pgm -combine "+outputfile
    convert4 = "convert -combine dcl1.pgm dcl2.pgm dcl3.pgm "+outputfile
#    convert4 = "convert -channel Red dcl1.pgm -channel Green dcl3.pgm -channel Blue dcl2.pgm -combine "+outputfile
    
    system( convert1 )
    p convert1
    system( convert2 )
    p convert2
    system( convert3 )
    p convert3
    system( convert4 )
    p convert4
    
  end
  system('/bin/rm dcl*.png dcl*.pgm')
  
end


