!= Module CFLCheck_3D
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: cflcheck_3d.f90,v 1.4 2009-02-28 08:19:12 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!CFL Υå򤹤뤿Υѥå⥸塼
!  * ȤФ CFL å
!  * Ϥ줿®٤Ф CFL å
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!Error Handling  gtool5 Ѥ褦ѹ
!

module CFLCheck_3d
  !
  !CFL Υå򤹤뤿Υѥå⥸塼
  !  * ȤФ CFL å
  !  * Ϥ줿®٤Ф CFL å
  !

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use dc_message, only: MessageNotify

  use gridset_3d, only: DimXMin,    &! x β
    &                DimXMax,       &! x ξ
    &                DimYMin,       &! z β
    &                DimYMax,       &! z ξ
    &                DimZMin,       &! z β
    &                DimZMax,       &! z ξ
    &                xyz_dX,          &! x γʻֳ
    &                xyz_dY,          &! y γʻֳ
    &                xyz_dZ            ! z γʻֳ
  use timeset, only: DelTimeShort,  &!û֥ƥå
    &                DelTimeLong     !Ĺ֥ƥå
  
  !ۤηػ
  implicit none

  !private °λ
  private

  !ؿ public °
  public CFLCheckTimeShort
  public CFLCheckTimeLongVelX
  public CFLCheckTimeLongVelY
  public CFLCheckTimeLongVelZ
  
contains  

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeShort( xyz_VelSound )
    !
    !ȤФ CFL å
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyz_VelSound &
      &                    (DimXMin:DimXMax,DimYMin:DImYMax, DimZMin:DimZMax)
                                        !®
    real(DP)             :: CFL          !
    real(DP)            :: DxyzMin      !ǾʻҴֳ
    
    !® CFL 
    DxyzMin = min(min(minval(xyz_dx), minval(xyz_dy)), minval(xyz_dz))
    CFL = DelTimeShort * maxval(xyz_VelSound) / DxyzMin

    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "Sound Wave Velocity = %f", d=(/maxval(xyz_VelSound)/) )
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "min(DelX, DelY, DelZ) = %f", d=(/DxyzMin/) )
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "DelTimeShort = %f", d=(/DelTimeSHort/) )

    !ٹå
    if ( CFL >= 1.0) then 
      call MessageNotify( "E", &
        & "CFLCheckTimeShort", &
        & "CFL Condition is broken, DelTimeShort * VelSound > min(DelX, DelZ)")
    else
      call MessageNotify( "M", &
        & "CFLCheckTimeShort", &
        & "Courant number for DelTimeSort = %f", d=(/CFL/) )
    end if
  
  end subroutine CFLCheckTimeShort


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelX( pyz_VelX )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: CFL

    !CFL 
    CFL = DelTimeLong * maxval(abs(pyz_VelX/xyz_dx))
  
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelX", &
      & "Courant number of VelX for DelTimeLong = %f", d=(/CFL/) )

  end subroutine CFLCheckTimeLongVelX
    

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelY( xqz_VelY )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xqz_VelY &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)             :: CFL

    !CFL 
    CFL = DelTimeLong * maxval(abs(xqz_VelY/xyz_dy))
  
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelY", &
      & "Courant number of VelY for DelTimeLong = %f", d=(/CFL/) )

  end subroutine CFLCheckTimeLongVelY


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelZ( xyr_VelZ )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyr_VelZ &
      &                    (DimXMin:DimXMax,DimYMin:DImYMax,DimZMin:DimZMax)
    real(DP)             :: CFL
    
    !CFL 
    CFL = DelTimeLong * maxval(abs(xyr_VelZ/xyz_dz)) 
    
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelZ", &
      & "Courant number of VelZ for DelTimeLong = %f", d=(/CFL/) )
    
  end subroutine CFLCheckTimeLongVelZ
  
end module CFLCheck_3d
