!= Module CFLCheck
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: cflcheck.f90,v 1.6 2009-02-28 08:19:12 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!CFL Υå򤹤뤿Υѥå⥸塼
!  * ȤФ CFL å
!  * Ϥ줿®٤Ф CFL å
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!Error Handling  gtool5 Ѥ褦ѹ
!

module CFLCheck
  !
  !CFL Υå򤹤뤿Υѥå⥸塼
  !  * ȤФ CFL å
  !  * Ϥ줿®٤Ф CFL å
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify

  use gridset, only: DimXMin,       &! x β
    &                DimXMax,       &! x ξ
    &                DimZMin,       &! z β
    &                DimZMax,       &! z ξ
    &                DelX,          &! X γʻֳ
    &                DelZ            ! Z γʻֳ
  use timeset, only: DelTimeShort,  &!û֥ƥå
    &                DelTimeLong     !Ĺ֥ƥå
  
  !ۤηػ
  implicit none

  !private °λ
  private

  !ؿ public °
  public CFLCheckTimeShort
  public CFLCheckTimeLongVelX
  public CFLCheckTimeLongVelZ
  
contains  

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeShort( xz_VelSound )
    !
    !ȤФ CFL å
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: xz_VelSound(DimXMin:DimXMax, DimZMin:DimZMax)
                                        !®
    real(8)             :: CFL          !
    
    !® CFL 
    CFL = DelTimeShort * maxval(xz_VelSound) / min(DelX, DelZ)

    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "Sound Wave Velocity = %f", d=(/maxval(xz_VelSound)/) )
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "min(DelX, DelZ) = %f", d=(/min(DelX, DelZ)/) )
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "DelTimeShort = %f", d=(/DelTimeSHort/) )

    !ٹå
    if ( CFL >= 1.0) then 
      call MessageNotify( "E", &
        & "CFLCheckTimeShort", &
        & "CFL Condition is broken, DelTimeShort * VelSound > min(DelX, DelZ)")
    else
      call MessageNotify( "M", &
        & "CFLCheckTimeShort", &
        & "Courant number for DelTimeSort = %f", d=(/CFL/) )
    end if
  
  end subroutine CFLCheckTimeShort


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelX( pz_VelX )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: pz_VelX(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: CFL
    
    !® CFL 
    CFL = DelTimeLong/ max(DelX / maxval(pz_VelX), - DelX / minval(pz_VelX)) 
  
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelX", &
      & "Courant number of VelX for DelTimeLong = %f", d=(/CFL/) )

  end subroutine CFLCheckTimeLongVelX
    

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelZ( xr_VelZ )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in) :: xr_VelZ(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)             :: CFL
    
    !® CFL 
    CFL = DelTimeLong / max(DelZ / maxval(xr_VelZ), - DelZ / minval(xr_VelZ)) 
    
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelZ", &
      & "Courant number of VelZ for DelTimeLong = %f", d=(/CFL/) )
    
  end subroutine CFLCheckTimeLongVelZ
  
end module CFLCheck
