!= Module ReStartFileIO_3d
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: restartfileio_3d.f90,v 1.8 2009-02-28 08:19:10 sugiyama Exp $ 
! Tag Name::  $Name: arare4-20100306 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ꥹѤξξ netCDF ե˽Ϥ뤿Υ롼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!®٤ɾʻҰ֤, ȤϤƤɸͤŪǤʤȤ
!
!== Future Plans
!

module ReStartFileIO_3d
  !
  !ꥹѤξξ netCDF ե˽Ϥ뤿Υ롼
  !

  !⥸塼ɤ߹
  use gtool_history
  use dc_types, only  : DP
  use dc_message, only: MessageNotify
  use dc_string, only : toChar
  use gridset_3d,only: x_X,               &!X ɸ(顼ʻ)
    &                 y_Y,               &!Y ɸ(顼ʻ)
    &                 z_Z,               &!Z ɸ(顼ʻ)
    &                 DimXMin,           &!X β
    &                 DimXMax,           &!X ξ
    &                 DimYMin,           &!Y β
    &                 DimYMax,           &!Y ξ
    &                 DimZMin,           &!Z β
    &                 DimZMax,           &!Z ξ
    &                 RegXMin,           &! ʪΰ X β
    &                 RegXMax,           &! ʪΰ X ξ
    &                 SpcNum              !Žʬο
  use timeset,  only: DelTimeLong
  use fileset_3d, only: RestartFile,       &!ꥹȥե̾
    &                 InitFile,          &!ե̾
    &                 exptitle,          &!ǡɽ
    &                 expsrc,            &!ǡ
    &                 expinst             !ǽѹԡȿ
  use basicset_3d,only: BasicSetArray_Init, &!
    &                 PressBasis,    &!̤δవ
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 CvDry,         &!ʬǮ
    &                 MolWtDry,      &!ʬʬ
    &                 Grav,          &!ϲ®
    &                 SpcWetMolFr,   &!Žʬν
    &                 MolWtWet,      &!Žʬʬ
    &                 GasRUniv        !׵

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ public ˻
  public ReStartFile_Open
  public ReStartFile_OutPut
  public ReStartFile_Close
  public ReStartFile_Get

  type(GT_HISTORY)   :: rstat

  save rstat

contains

  subroutine ReStartFile_Open(  )
    !
    !ꥹȥեν񤭽Ф
    !
   
    use basicset_3d, only: xyz_ExnerBasicZ,    &!ܾΥʡؿ
      &                 xyz_DensBasicZ,     &!ܾ̩
      &                 xyz_PotTempBasicZ,  &!ܾβ
      &                 xyz_VelSoundBasicZ, &!ܾβ®
      &                 xyz_PressBasicZ,    &!ܾΰ
      &                 xyz_TempBasicZ,     &!ܾβ
      &                 xyza_MixRtBasicZ,   &!ܾκ
      &                 xyz_EffMolWtBasicZ   !ܾʬ̸


    !ۤηػ
    implicit none
    
    !ѿ
    real(4)            :: SpcID(SpcNum)
    integer            :: N, L, M
    integer            :: s    

    SpcID = 0.0d0
    do s = 1, SpcNum
      SpcID(s) = real( s, 4 )
    end do
    
    N = size(x_X, 1)
    L = size(y_Y, 1)
    M = size(z_Z, 1)
    
    !-------------------------------------------------------------    
    ! ҥȥ꡼
    !-------------------------------------------------------------  
    call HistoryCreate(                              &
      & file = ReStartFile,                          &
      & title = exptitle,                            &
      & source = expsrc,                             &
      & institution = expinst,                       &
      & dims=(/'x','y','z','s','t'/),                &
      & dimsizes=(/N, L, M, SpcNum, 0/),             &
      & longnames=(/'X-coordinate',                  &
      &             'Y-coordinate',                  &
      &             'Z-coordinate',                  &
      &             'Species Num ',                  &
      &             'Time        '/),                &
      & units=(/'m','m','m','1','t'/),               &
      & xtypes=(/'double', 'double', 'double', 'double', 'double'/), &
      & origin=0.0, interval=1.0,                    &
      & history=rstat )
    
    !-------------------------------------------------------------  
    ! ѿ
    !-------------------------------------------------------------
    call HistoryPut('x', x_X, rstat )
    call HistoryPut('y', y_Y, rstat )
    call HistoryPut('z', z_Z, rstat )
    call HistoryPut('s', real(SpcID, 4), rstat )
    
    !̵Ϥδܾ
    call HistoryAddVariable(                             &
      & varname='ExnerBasicZ', dims=(/'x','y','z'/),      &
      & longname='nondimensional pressure', units='1',&
      & xtype='double', history=rstat )
    
    !̤δܾ
    call HistoryAddVariable(                            &
      & varname='PotTempBasicZ', dims=(/'x','y','z'/),    &
      & longname='potential temperature',            &
      & units='K', xtype='double', history=rstat ) 
    
    !̩٤δܾ
    call HistoryAddVariable(                            &
      & varname='DensBasicZ', dims=(/'x','y','z'/),      &
      & longname='density',                          &
      & units='Kg.m-3', xtype='double', history=rstat )
    
    !®٤δܾ
    call HistoryAddVariable(                            &
      & varname='VelSoundBasicZ', dims=(/'x','y','z'/),  &
      & longname='sound velocity',                   &
      & units='m.s-2', xtype='double', history=rstat )
    
    !٤δܾ
    call HistoryAddVariable(                            &
      & varname='TempBasicZ', dims=(/'x','y','z'/),  &
      & longname='Temperature of basic state',       &
      & units='K', xtype='double', history=rstat ) 
    
    !Ϥδܾ
    call HistoryAddVariable(                            &
      & varname='PressBasicZ', dims=(/'x','y','z'/),  &
      & longname='Pressure of basic state',             &
      & units='Pa', xtype='double', history=rstat ) 
    
    !δܾ
    call HistoryAddVariable(                            &
      & varname='MixRtBasicZ', dims=(/'x','y','z','s'/),  &
      & longname='Mixing ratio of Condensible volatiles',        &
      & units='kg.kg-1', xtype='double', history=rstat ) 
    
    !ʬ̸
    call HistoryAddVariable(                         &
      & varname='EffMolWtBasicZ', dims=(/'x','y','z'/),  &
      & longname='Effect of Mole Weight',            &
      & units='1', xtype='double', history=rstat ) 
    
    !̵
    call HistoryAddVariable(                         &
      & varname='Exner', dims=(/'x','y','z','t'/),       &
      & longname='nondimensional pressure',          &
      & units='1',                                   &
      & xtype='double', history=rstat )
    
    !̤ξ
    call HistoryAddVariable(                         &
      & varname='PotTemp', dims=(/'x','y','z','t'/),     &
      & longname='virtual potential temperature',    &
      & units='K',                                   &
      & xtype='double', history=rstat )
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelX', dims=(/'x','y','z','t'/),        &
      & longname='zonal velocity',                   &
      & units='m.s-1',                                 &
      & xtype='double', history=rstat )
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelY', dims=(/'x','y','z','t'/),        &
      & longname='meridional velocity',              &
      & units='m.s-1',                                 &
      & xtype='double', history=rstat )
    
    !®
    call HistoryAddVariable(                         &
      & varname='VelZ', dims=(/'x','y','z','t'/),        &
      & longname='vertical velocity',                &
      & units='m.s-1',                                 &
      & xtype='double', history=rstat )
    
    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Km', dims=(/'x','y','z','t'/),      &
      & longname='Km',                               &
      & units='m2.s-1',                              &
      & xtype='double', history=rstat )
    
    !Ǵ
    call HistoryAddVariable(                         &
      & varname='Kh', dims=(/'x','y','z','t'/),      &
      & longname='Kh',                               &
      & units='m2.s-1',                              &
      & xtype='double', history=rstat )
    
    !
    call HistoryAddVariable(                         &
      & varname='MixRt', dims=(/'x','y','z','s','t'/),   &
      & longname='Mixing Ratio',                     &
      & units='kg.kg-1"',                           & 
      & xtype='double', history=rstat )
    
    !-------------------------------------------------------------
    ! ܾΥե
    !-------------------------------------------------------------
    call HistoryPut( 'DensBasicZ',     xyz_DensBasicZ     , rstat)
    call HistoryPut( 'ExnerBasicZ',    xyz_ExnerBasicZ    , rstat)
    call HistoryPut( 'PotTempBasicZ',  xyz_PotTempBasicZ  , rstat)
    call HistoryPut( 'VelSoundBasicZ', xyz_VelSoundBasicZ , rstat)
    call HistoryPut( 'TempBasicZ',     xyz_TempBasicZ     , rstat)
    call HistoryPut( 'PressBasicZ',    xyz_PressBasicZ    , rstat)
    call HistoryPut( 'MixRtBasicZ',    xyza_MixRtBasicZ  , rstat)
    call HistoryPut( 'EffMolWtBasicZ', xyz_EffMolWtBasicZ, rstat)
    
  end subroutine ReStartFile_Open
  
  
  subroutine ReStartFile_OutPut(        &
    &   Time, xyz_PotTemp, xyz_Exner, pyz_VelX, xqz_VelY, xyr_VelZ, &
    &   xyza_MixRt, xyz_Km , xyz_Kh &
    & )
    !
    !ꥹȥեͽѿ񤭽Ф
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)  :: Time
    real(DP), intent(in)  :: pyz_VelX &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xqz_VelY &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyr_VelZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyz_Exner &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyz_PotTemp &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyz_Km &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyz_Kh &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(in)  :: xyza_MixRt &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
    
  
    !------------------------------------------------------------------
    ! ե
    !------------------------------------------------------------------
    call HistoryPut( 't',       Time        , rstat)
    call HistoryPut( 'VelX',    pyz_VelX    , rstat)
    call HistoryPut( 'VelY',    xqz_VelY    , rstat)
    call HistoryPut( 'VelZ',    xyr_VelZ    , rstat)
    call HistoryPut( 'Exner',   xyz_Exner   , rstat)
    call HistoryPut( 'PotTemp', xyz_PotTemp , rstat)
    call HistoryPut( 'Km',      xyz_Km      , rstat)
    call HistoryPut( 'Kh',      xyz_Kh      , rstat)
    call HistoryPut( 'MixRt',   xyza_MixRt  , rstat)    
    
  end subroutine ReStartFile_OutPut
  
  
  subroutine ReStartFile_Close
    !
    !ꥹȥեΥ
    !
    
    !⥸塼ɤ߹
    use gtool_history
    
    !ۤηػ
    implicit none

    !եĤ
    call HistoryClose(rstat)
    
  end subroutine ReStartFile_Close


  subroutine ReStartFile_Get(   &
    & ReStartTime,                            &
    & xyz_PotTempB, xyz_ExnerB, pyz_VelXB, xqz_VelYB, xyr_VelZB, &
    & xyza_MixRtB, xyz_KmB, xyz_KhB, &
    & xyz_PotTempN, xyz_ExnerN, pyz_VelXN, xqz_VelYN, xyr_VelZN, &
    & xyza_MixRtN, xyz_KmN, xyz_KhN  )
    !
    !ꥹȥե뤫
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(out) :: ReStartTime(2)
    real(DP), intent(out) :: pyz_VelXN &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xqz_VelYN &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyr_VelZN &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_ExnerN &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_PotTempN &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_KmN &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_KhN &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyza_MixRtN &
      &              (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
    real(DP), intent(out) :: pyz_VelXB &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xqz_VelYB &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyr_VelZB &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_ExnerB &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_PotTempB &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_KmB &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyz_KhB &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP), intent(out) :: xyza_MixRtB &
      &              (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
    real(DP)              :: DelTime
    real(DP)              :: Var3D &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
    real(DP)              :: Var3Ds &
      &                   (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,2)
    real(DP)              :: Var4D &
      &              (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum)
    real(DP)              :: Var4Ds &
      &           (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax,SpcNum, 2)

    real(DP)              :: xyz_ExnerBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ܾΥʡؿ
    real(DP)              :: xyz_DensBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ܾ̩
    real(DP)              :: xyz_PotTempBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ܾβ
    real(DP)              :: xyz_VelSoundBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ܾβ®
    real(DP)              :: xyz_PressBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ܾΰ
    real(DP)              :: xyz_TempBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ܾβ
    real(DP)              :: xyza_MixRtBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax, SpcNum)
                                               !ܾκ
    real(DP)              :: xyz_EffMolWtBasicZ &
      &                     (DimXMin:DimXMax,DimYMin:DimYMax,DimZMin:DimZMax)
                                               !ܾʬ̸
    character(30)        :: name               !ѿ̾
    character(10)        :: step(2)
    integer              :: t

    !-------------------------------------------------------------
    ! Get a Value from netCDF File
    !-------------------------------------------------------------    
    do t = 1, 2
      step(t) = 't=^' // adjustl(toChar(t))   
    end do

    do t = 1, 2
      name = "t"
      call HistoryGet( InitFile, name, ReStartTime(t), step(t) )
    end do

    do t = 1, 2
      name = "VelX"
      call HistoryGet( InitFile, name, Var3Ds(:,:,:,t), step(t) )    
    end do
    pyz_VelXB = Var3Ds(:,:,:,1)
    pyz_VelXN = Var3Ds(:,:,:,2)

    do t = 1, 2
      name = "VelY"
      call HistoryGet( InitFile, name, Var3Ds(:,:,:,t), step(t) )    
    end do
    xqz_VelYB = Var3Ds(:,:,:,1)
    xqz_VelYN = Var3Ds(:,:,:,2)

    do t = 1, 2    
      name = "VelZ"
      call HistoryGet( InitFile, name, Var3Ds(:,:,:,t), step(t) )    
    end do
    xyr_VelZB = Var3Ds(:,:,:,1)
    xyr_VelZN = Var3Ds(:,:,:,2)

    do t = 1, 2    
      name = "Exner"
      call HistoryGet( InitFile, name, Var3Ds(:,:,:,t), step(t) )    
    end do
    xyz_ExnerB = Var3Ds(:,:,:,1)
    xyz_ExnerN = Var3Ds(:,:,:,2)

    do t = 1, 2    
      name = "PotTemp"
      call HistoryGet( InitFile, name, Var3Ds(:,:,:,t), step(t) )    
    end do
    xyz_PotTempB = Var3Ds(:,:,:,1)
    xyz_PotTempN = Var3Ds(:,:,:,2)
    
    do t = 1, 2  
      name = "Km"
      call HistoryGet( InitFile, name, Var3Ds(:,:,:,t), step(t) )    
    end do
    xyz_KmB = Var3Ds(:,:,:,1)
    xyz_KmN = Var3Ds(:,:,:,2)
    
    do t = 1, 2  
      name = "Kh"
      call HistoryGet( InitFile, name, Var3Ds(:,:,:,t), step(t) )    
    end do
    xyz_KhB = Var3Ds(:,:,:,1)
    xyz_KhN = Var3Ds(:,:,:,2)
      
    do t = 1, 2
      name = "MixRt"
      call HistoryGet( InitFile, name, Var4Ds(:,:,:,:,t), step(t) )    
    end do
    xyza_MixRtB = Var4Ds(:,:,:,:,1)
    xyza_MixRtN = Var4Ds(:,:,:,:,2)
    
    !-------------------------------------------------------------
    ! ܾμ
    !-------------------------------------------------------------
    name = "DensBasicZ"
    call HistoryGet( InitFile, name, Var3D )
    xyz_DensBasicZ = Var3D
    
    name = "ExnerBasicZ"
    call HistoryGet( InitFile, name, Var3D )
    xyz_ExnerBasicZ = Var3D
    
    name = "PotTempBasicZ"
    call HistoryGet( InitFile, name, Var3D )
    xyz_PotTempBasicZ = Var3D
    
    name = "VelSoundBasicZ"
    call HistoryGet( InitFile, name, Var3D )
    xyz_VelSoundBasicZ = Var3D
    
    name = "TempBasicZ"
    call HistoryGet( InitFile, name, Var3D )
    xyz_TempBasicZ = Var3D
    
    name = "PressBasicZ"
    call HistoryGet( InitFile, name, Var3D )
    xyz_PressBasicZ = Var3D
    
    name = "MixRtBasicZ"
    call HistoryGet( InitFile, name, Var4D )
    xyza_MixRtBasicZ = Var4D
    
    name = "EffMolWtBasicZ"
    call HistoryGet( InitFile, name, Var3D )
    xyz_EffMolWtBasicZ = Var3D


    !----------------------------------------------------------
    ! ֹߤΥå
    !----------------------------------------------------------
    DelTime = ReStartTime(2) - ReStartTime(1)

    if ( DelTime /= real(DelTimeLong, 4) ) then 
      call MessageNotify( "W", &
        &                 "ReStartFile_Get", &
        &                 "DelTime in InitFile is not the same as DelTimeLong")
      call MessageNotify( "M", &
        &                 "ReStartFile_Get", &
        &                 "DelTime=%d", d=(/DelTime/) )
      call MessageNotify( "M", &
        &                 "ReStartFile_Get", &
        &                 "DelTimeLong=%d", d=(/DelTimeLong/) )
    end if
    
    !----------------------------------------------------------
    ! BasicSet ⥸塼ͤ
    !----------------------------------------------------------
    call BasicSetArray_Init(                                     &
      & xyz_PressBasicZ,    xyz_ExnerBasicZ, xyz_TempBasicZ,     &
      & xyz_PotTempBasicZ,  xyz_DensBasicZ,  xyz_VelSoundBasicZ, &
      & xyza_MixRtBasicZ, xyz_EffMolWtBasicZ &
      & )
    
  end subroutine ReStartFile_Get


       
end module ReStartFileIO_3d
